/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.multiblock.structure;

import com.valkyrieofnight.vlib.api.multiblock.structure.IMultiblockStructure;
import com.valkyrieofnight.vlib3.multiblock.api.tile.ITileController;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiblockContinuousScanner {
    private IMultiblockStructure structure;
    private ITileController controller;
    private Set<BlockPos> scanned = new HashSet<BlockPos>();
    private Queue<BlockPos> queue = new LinkedList<BlockPos>();
    private World world;
    private int scanRate;

    public MultiblockContinuousScanner(ITileController cont, int scanRate) {
        this.controller = cont;
        this.structure = cont.getStructure();
        this.scanRate = scanRate;
        this.world = cont.getWorld();
    }

    public void update() {
        for (int i = 0; i < this.scanRate; ++i) {
            this.scan();
        }
    }

    protected void scan() {
        if (this.queue.isEmpty()) {
            this.startQueue();
        }
        BlockPos pos = this.queue.poll();
        if (this.structure.isValidComponent(this.world, this.controller.getPos(), pos)) {
            this.controller.deformMultiblock();
        }
    }

    public void setScanRate(int scanRate) {
        this.scanRate = scanRate;
    }

    protected void startQueue() {
        this.scanned.clear();
        this.queue.clear();
        this.queue.addAll(this.structure.getSlavesLayout(this.world, this.controller.getPos(), this.controller.getDirectionE()));
    }
}

