/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.multiblock.structure;

import com.valkyrieofnight.vlib.api.multiblock.structure.IMultiblockStructure;
import com.valkyrieofnight.vlib.api.multiblock.structure.IStructureComponent;
import com.valkyrieofnight.vlib.lib.multiblock.slave.VLTileSlave;
import com.valkyrieofnight.vlib.lib.multiblock.structure.ComponentRegistry;
import com.valkyrieofnight.vlib3.core.util.client.ColorUtil;
import com.valkyrieofnight.vlib3.core.util.client.LangUtil;
import com.valkyrieofnight.vlib3.multiblock.api.structure.IBlockOffset;
import com.valkyrieofnight.vlib3.multiblock.api.structure.IStructureSize;
import com.valkyrieofnight.vlib3.multiblock.api.tile.ITileController;
import com.valkyrieofnight.vlib3.multiblock.api.tile.ITileSlave;
import com.valkyrieofnight.vlib3.multiblock.structure.BlockOffset;
import com.valkyrieofnight.vlib3.multiblock.structure.StructureSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiBlockStructure
implements IMultiblockStructure {
    private HashMap<IBlockOffset, IStructureComponent> blockLayout = new HashMap();
    private HashMap<IBlockOffset, IStructureComponent> optionalBlocks = new HashMap();
    public static int BLOCK_SETUP_INVALID = -1;
    private HashMap<InformationPosition, List<String>> information = new HashMap();
    private IMultiblockStructure nextTier = null;
    private StructureSize size;

    public MultiBlockStructure() {
        for (InformationPosition ip : InformationPosition.values()) {
            this.information.put(ip, new ArrayList());
        }
        this.size = new StructureSize();
    }

    @Override
    public int verifyLayout(World world, BlockPos controller) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            if (!this.isLayoutValid(world, controller, dir)) continue;
            return dir.func_176745_a();
        }
        return BLOCK_SETUP_INVALID;
    }

    @Override
    public void initStructure(World world, BlockPos controller, List<BlockPos> slaves) {
        TileEntity cont = world.func_175625_s(controller);
        if (!(cont instanceof ITileController)) {
            throw new IllegalArgumentException("Controller must be of type IControllerTile");
        }
        for (BlockPos pos : slaves) {
            TileEntity slave = world.func_175625_s(pos);
            if (!(slave instanceof VLTileSlave) || slave.func_145831_w() == null) continue;
            ((ITileSlave)slave).setController(cont);
        }
    }

    @Override
    public List<BlockPos> getSlavesLayout(World world, BlockPos controller, EnumFacing dir) {
        ArrayList<BlockPos> slavePositions = new ArrayList<BlockPos>();
        for (IBlockOffset bo : this.blockLayout.keySet()) {
            slavePositions.add(bo.getRotatedPosition(dir, controller));
        }
        return slavePositions;
    }

    @Override
    public List<BlockPos> getSlavesOfType(Class slaveType, BlockPos controller, EnumFacing dir) {
        ArrayList<BlockPos> slavePositions = new ArrayList<BlockPos>();
        for (IBlockOffset key : this.blockLayout.keySet()) {
            if (!this.blockLayout.get(key).isType(slaveType)) continue;
            slavePositions.add(key.getRotatedPosition(dir, controller));
        }
        return slavePositions;
    }

    @Override
    public boolean isLayoutValid(World world, BlockPos controller, EnumFacing dir) {
        for (IBlockOffset bo : this.blockLayout.keySet()) {
            IStructureComponent comp = this.blockLayout.get(bo);
            if (comp.isCorrectComponent(world, bo.getRotatedPosition(dir, controller))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidComponent(World world, BlockPos controller, BlockPos component) {
        IStructureComponent comp = this.blockLayout.get(BlockOffset.getOffset(controller, component));
        return comp != null && comp.isCorrectComponent(world, component);
    }

    @Override
    public boolean isValidComponent(World world, BlockPos controller, IBlockOffset compOffset, EnumFacing testDirection) {
        IStructureComponent comp = this.blockLayout.get(compOffset);
        return comp != null && comp.isCorrectComponent(world, compOffset.getRotatedPosition(testDirection, controller));
    }

    @Override
    public HashMap<IBlockOffset, IStructureComponent> getRequiredBlockLayout() {
        return this.blockLayout;
    }

    @Override
    public void placeAllInWorld(World world, BlockPos controller, EntityPlayer player) {
        for (IBlockOffset bo : this.blockLayout.keySet()) {
            IStructureComponent comp = this.blockLayout.get(bo);
            world.func_175656_a(bo.getPosition(controller), comp.getDefaultBlockState());
        }
    }

    @Override
    public void pickupMultiBlock(World world, BlockPos controller, EntityPlayer player) {
        for (IBlockOffset bo : this.blockLayout.keySet()) {
            IStructureComponent comp = this.blockLayout.get(bo);
            world.func_175656_a(bo.getPosition(controller), Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    public boolean placeNextBlock(World world, BlockPos controller, EntityPlayer player) {
        for (IBlockOffset bo : this.blockLayout.keySet()) {
            if (this.blockLayout.get(bo).isCorrectComponent(world, bo.getPosition(controller)) || !world.func_180495_p(bo.getPosition(controller)).func_177230_c().equals(Blocks.field_150350_a)) continue;
            IStructureComponent icomp = this.blockLayout.get(bo);
            NonNullList pInv = player.field_71069_bz.func_75138_a();
            for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                if (stack == null || !icomp.isCorrectItemStack(stack) || stack.func_190916_E() <= 0) continue;
                world.func_175656_a(bo.getPosition(controller), Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j()));
                player.field_71071_by.func_70298_a(slot, 1);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean positionTaken(IBlockOffset offset) {
        for (IBlockOffset rb : this.blockLayout.keySet()) {
            if (!rb.equals(offset)) continue;
            return true;
        }
        for (IBlockOffset rb : this.optionalBlocks.keySet()) {
            if (!rb.equals(offset)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addRequiredBlock(IStructureComponent comp, int xOffset, int yOffset, int zOffset) {
        BlockOffset offset = new BlockOffset(xOffset, yOffset, zOffset);
        if (!this.positionTaken(offset)) {
            this.blockLayout.put(offset, comp);
        }
        this.size.expand(offset);
    }

    @Override
    public List<String> getListOfRequiredBlocks(boolean withTitle) {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<IStructureComponent, Integer> totals = new HashMap<IStructureComponent, Integer>();
        for (IStructureComponent comp : this.blockLayout.values()) {
            if (totals.containsKey(comp)) {
                int i = (Integer)totals.get(comp);
                totals.put(comp, ++i);
                continue;
            }
            totals.put(comp, 1);
        }
        list.addAll((Collection)this.information.get((Object)InformationPosition.TITLE));
        list.addAll((Collection)this.information.get((Object)InformationPosition.ABOVE_LIST));
        if (withTitle) {
            list.add(ColorUtil.DARK_AQUA + LangUtil.toLoc("gui.environmentaltech.multiblockassembler.info.needed.title"));
        }
        for (IStructureComponent comp : ComponentRegistry.getInstance().getList()) {
            if (!totals.containsKey(comp)) continue;
            int n = (Integer)totals.get(comp);
            String str = "  " + ColorUtil.DARK_PURPLE + n + " " + ColorUtil.BLUE + "x " + ColorUtil.GOLD + comp.getGuideLocalization();
            list.add(str);
        }
        list.addAll((Collection)this.information.get((Object)InformationPosition.BELOW_LIST));
        return list;
    }

    public List<String> getListOfRequiredBlocksGuide() {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<IStructureComponent, Integer> totals = new HashMap<IStructureComponent, Integer>();
        for (IStructureComponent comp : this.blockLayout.values()) {
            if (totals.containsKey(comp)) {
                int i = (Integer)totals.get(comp);
                totals.put(comp, ++i);
                continue;
            }
            totals.put(comp, 1);
        }
        for (IStructureComponent comp : ComponentRegistry.getInstance().getList()) {
            if (!totals.containsKey(comp)) continue;
            int n = (Integer)totals.get(comp);
            String str = "  " + ColorUtil.DARK_PURPLE + n + " " + ColorUtil.BLUE + "x " + ColorUtil.BLACK + comp.getGuideLocalization();
            list.add(str);
        }
        return list;
    }

    @Override
    public int getTotalRequiredComponent(Class clazz) {
        int total = 0;
        for (IStructureComponent comp : this.blockLayout.values()) {
            if (!comp.isType(clazz)) continue;
            ++total;
        }
        return total;
    }

    @Override
    public int getTotalRequiredComponent(IStructureComponent comp) {
        int total = 0;
        for (IStructureComponent c : this.blockLayout.values()) {
            if (c != comp) continue;
            ++total;
        }
        return total;
    }

    public void addInformation(InformationPosition pos, String localizedText) {
        List<String> posList = this.information.get((Object)pos);
        posList.add(localizedText);
    }

    @Override
    public void setNextTier(IMultiblockStructure next) {
        this.nextTier = next;
    }

    @Override
    public IMultiblockStructure getNextTier() {
        return this.nextTier;
    }

    @Override
    public IStructureSize getStructureSize() {
        return this.size;
    }

    public static enum InformationPosition {
        TITLE,
        ABOVE_LIST,
        BELOW_LIST;

    }
}

