/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.multiblock;

import com.valkyrieofnight.vlib.lib.multiblock.tilemodule.StructureFormer;
import com.valkyrieofnight.vlib.lib.tile.energy.VLTileEnergyProducer;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.fe.ForgeEnergyUtil;
import com.valkyrieofnight.vlib.lib.tilemodule.progress.ITileProgress;
import com.valkyrieofnight.vlib.lib.tilemodule.progress.ProgressTracker;
import com.valkyrieofnight.vlib3.multiblock.api.tile.ITileController;
import com.valkyrieofnight.vlib3.multiblock.api.tile.ITileSlave;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class VLControllerEProducer
extends VLTileEnergyProducer
implements ITileController,
ITileProgress {
    protected ProgressTracker progress = new ProgressTracker();
    protected StructureFormer former = new StructureFormer(this);
    private long currentTick = 0L;

    public VLControllerEProducer(int capacity) {
        this(capacity, capacity);
    }

    public VLControllerEProducer(int capacity, int maxExtract) {
        super(capacity, maxExtract);
        this.addModule(this.former);
    }

    @Override
    public void updateTile() {
        if (!this.field_145850_b.field_72995_K) {
            this.handleForgeEnergy();
        }
        this.currentTick = this.func_145831_w().func_72820_D();
        if (this.former.isFormed() && this.former.getMBDirection() != -1) {
            if (!this.func_145831_w().func_175640_z(this.func_174877_v())) {
                this.updateProgress();
            } else {
                this.onIdleTick();
            }
        }
        super.updateTile();
    }

    @Override
    public EnumFacing getDirectionE() {
        return this.former.getMBDirectionE();
    }

    @Override
    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        super.saveTileData(nbt, toItem);
        this.progress.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        super.loadTileData(nbt, fromItem);
        this.progress.readFromNBT(nbt);
    }

    public void handleForgeEnergy() {
        ForgeEnergyUtil.sendEnergyToFirst(this.getTheWorld(), this.field_174879_c, this.eBuffer, this.validEnergyDirections());
    }

    @Override
    public String getInfo() {
        return "Owner: " + this.getOwner().getUsername(this.field_145850_b);
    }

    public abstract EnumFacing[] validEnergyDirections();

    @Override
    protected boolean canEnergyConnect(EnumFacing side) {
        for (EnumFacing dir : this.validEnergyDirections()) {
            if (side != dir) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSlave(BlockPos pos) {
        return this.getStructure().getSlavesLayout(this.func_145831_w(), this.func_174877_v(), EnumFacing.func_82600_a((int)this.former.getMBDirection())).contains(pos);
    }

    @Override
    public void onSlaveBreak(ITileSlave slave, BlockPos pos) {
        this.deformMultiblock();
    }

    @Override
    public void deformMultiblock() {
        this.former.deformMultiblock();
    }

    @Override
    public boolean isFormed() {
        return this.former.isFormed();
    }

    @Override
    public ProgressTracker getTracker() {
        return this.progress;
    }

    @Override
    public World getTheWorld() {
        return this.field_145850_b;
    }

    @Override
    public int getCurrentDuration() {
        int duration = this.modifyDuration(this.getBaseDuration());
        if (duration < this.getMinDuration()) {
            return this.getMinDuration();
        }
        if (duration > this.getMaxDuration()) {
            return this.getMaxDuration();
        }
        return duration;
    }

    @Override
    public boolean canStartProcess() {
        return this.isFormed();
    }

    @Override
    public int canProcess(int ticks) {
        return this.canProcess() ? 1 : 0;
    }

    @Override
    public int processTicks() {
        return 1;
    }

    @Override
    public void serverUpdate() {
    }

    @Override
    public void clientUpdate() {
    }

    public abstract int getBaseDuration();

    public abstract int getMinDuration();

    public abstract int getMaxDuration();

    public abstract int modifyDuration(int var1);

    public abstract boolean canProcess();

    @Override
    public boolean canSaveOnPickup() {
        return true;
    }
}

