/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.json;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public abstract class GsonRegistry<DT> {
    protected Gson gson;
    protected File file;
    protected ArrayList<DT> data;

    public GsonRegistry(Gson gson, File file) {
        this.gson = gson;
        this.file = file;
        this.data = new ArrayList();
    }

    public void saveRegistryToJson() {
        try {
            this.file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(this.file);
            writer.write(this.gson.toJson(this.data));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void loadRegistryFromJson();

    public void addEntry(@Nonnull DT entry) {
        this.data.add(entry);
    }

    public ArrayList<DT> getData() {
        return this.data;
    }

    public boolean doesFileExsist() {
        return this.file.exists();
    }
}

