/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.client.gui.elements.text;

import com.valkyrieofnight.vlib.lib.client.gui.VLGui;
import com.valkyrieofnight.vlib.lib.client.gui.elements.VLElementText;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class VLTextParagraph
extends VLElementText {
    protected int paraHeight;
    protected int paraLargestWidth;
    protected int maxWidth = 20;

    public VLTextParagraph(String elementID, int x, int y, String text, int maxWidth) {
        super(elementID, x, y, text);
        this.maxWidth = maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.paraLargestWidth = maxWidth;
        this.recalcDimensions();
    }

    @Override
    public void setGui(VLGui gui) {
        this.gui = gui;
        this.recalcDimensions();
    }

    @Override
    public VLTextParagraph setText(String text) {
        this.text = text;
        this.recalcDimensions();
        return this;
    }

    protected void recalcDimensions() {
        this.paraHeight = this.gui.getFontRenderer().func_78267_b(this.text, this.maxWidth);
        List test = this.gui.getFontRenderer().func_78271_c(this.text, this.maxWidth);
        for (String string : test) {
            int t = this.gui.getFontRenderer().func_78256_a(string);
            if (t <= this.paraLargestWidth) continue;
            this.paraLargestWidth = t;
        }
    }

    @Override
    public void drawBackgroundLayer(int mx, int my, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = this.hAlignment.getOffset(this.paraLargestWidth);
        int yOffset = this.vAlignment.getOffset(this.paraHeight);
        this.gui.getFontRenderer().func_78279_b(this.styleCodes + this.text, this.gui.getGuiLeft() + this.xPosOffset + xOffset, this.gui.getGuiTop() + this.yPosOffset + yOffset, this.maxWidth, this.textColor);
    }

    @Override
    public int getXSize() {
        return this.paraLargestWidth;
    }

    @Override
    public int getYSize() {
        return this.paraHeight;
    }
}

