/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.client.gui.elements;

import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiDraw;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiDrawTooltip;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiInput;
import com.valkyrieofnight.vlib.lib.client.gui.base.ToolTipList;
import com.valkyrieofnight.vlib.lib.client.gui.elements.VLElement;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public abstract class VLElementButton
extends VLElement
implements IGuiDraw,
IGuiInput,
IGuiDrawTooltip {
    protected ToolTipList tooltips = new ToolTipList();
    protected boolean enabled = true;

    public VLElementButton(String elementID, int xPos, int yPos, int xSize, int ySize) {
        super(elementID);
        this.xPosOffset = xPos;
        this.yPosOffset = yPos;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    @Override
    public boolean onMouseClicked(int mx, int my, int mouseButton) {
        if (this.isEnabledOutsideOfGui()) {
            return this.gui.isInBox(mx, my, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize());
        }
        return this.gui.isInBoxAndGUI(mx, my, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize());
    }

    @Override
    public boolean onMouseScrolled(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keyCode) {
        return false;
    }

    public void setEnabled(boolean opt) {
        this.enabled = opt;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void addToolTip(String localizedToolTip) {
        this.tooltips.addToolTip(localizedToolTip);
    }

    @Override
    public void setToolTipList(List<String> toolTips) {
        this.tooltips.setToolTipList(toolTips);
    }

    @Override
    public void drawToolTip(int mx, int my) {
        if (!this.enabled) {
            return;
        }
        boolean inBoxGui = false;
        if (this.isEnabledOutsideOfGui()) {
            if (this.gui.isInBox(mx, my, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize())) {
                inBoxGui = true;
            }
        } else if (this.gui.isInBoxAndGUI(mx, my, this.getXPosActual(), this.getYPosActual(), this.getXSize(), this.getYSize())) {
            inBoxGui = true;
        }
        if (inBoxGui) {
            int mxn = mx - this.gui.getGuiLeft();
            int myn = my - this.gui.getGuiTop() - 4;
            this.gui.drawHoverText(this.tooltips.getList(), mx, my);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return nbt;
    }
}

