/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.block;

import com.valkyrieofnight.vlib.lib.item.VLItemBlock;
import com.valkyrieofnight.vlib.lib.sys.init.IModNamespace;
import com.valkyrieofnight.vlib.lib.sys.init.IRegisterCustomItemBlock;
import com.valkyrieofnight.vlib.lib.sys.init.client.IRegisterModels;
import com.valkyrieofnight.vlib.lib.sys.item.tooltip.IProvideTooltipInfo;
import com.valkyrieofnight.vlib3.core.util.client.LangUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VLBlockStairs
extends BlockStairs
implements IRegisterModels,
IRegisterCustomItemBlock,
IModNamespace,
IProvideTooltipInfo {
    private String blockName;
    private boolean playerBreakOnly = false;
    protected VLItemBlock itemBlock;

    protected VLBlockStairs(IBlockState modelState, String blockName) {
        super(modelState);
        this.blockName = blockName;
        this.setRegistryName(blockName);
        this.func_149663_c(this.getModNamespace() + "." + blockName);
        this.itemBlock = new VLItemBlock((Block)this);
    }

    public void setPlayerBreakOnly(boolean opt) {
        this.playerBreakOnly = opt;
    }

    @Override
    public ItemBlock getItemBlock() {
        if (this.itemBlock == null) {
            this.itemBlock = new VLItemBlock((Block)this);
        }
        this.itemBlock.setRarity(this.getRarity(), 0);
        return this.itemBlock;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasShiftTooltipInfo() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addShiftTooltipInfo(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltipInfo(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.playerBreakOnly()) {
            tooltip.add(LangUtil.toLoc("tooltip.valkyrielib.witherproof"));
            tooltip.add(LangUtil.toLoc("tooltip.valkyrielib.playerbreakonly"));
        }
    }

    public EnumRarity getRarity() {
        return EnumRarity.COMMON;
    }

    public boolean playerBreakOnly() {
        return this.playerBreakOnly;
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityPlayer) {
            return true;
        }
        return !this.playerBreakOnly;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!this.playerBreakOnly) {
            world.func_175698_g(pos);
            this.func_180652_a(world, pos, explosion);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        if (this.playerBreakOnly) {
            return false;
        }
        return super.func_149659_a(explosionIn);
    }
}

