/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.block;

import com.google.common.collect.ImmutableList;
import com.valkyrieofnight.vlib.lib.item.VLItemBlock;
import com.valkyrieofnight.vlib.lib.sys.init.IModNamespace;
import com.valkyrieofnight.vlib.lib.sys.init.IRegisterCustomItemBlock;
import com.valkyrieofnight.vlib.lib.sys.init.client.IRegisterModels;
import com.valkyrieofnight.vlib.lib.sys.item.tooltip.IProvideTooltipInfo;
import com.valkyrieofnight.vlib.lib.sys.owner.IOwnable;
import com.valkyrieofnight.vlib.lib.sys.owner.Owner;
import com.valkyrieofnight.vlib.lib.sys.tile.info.ITleInfo;
import com.valkyrieofnight.vlib.lib.tile.VLTile;
import com.valkyrieofnight.vlib.m_multiblocks.features.VLMConfigs;
import com.valkyrieofnight.vlib3.core.util.client.LangUtil;
import com.valkyrieofnight.vlib3.core.util.player.ChatUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VLBlock
extends Block
implements IRegisterModels,
IRegisterCustomItemBlock,
IModNamespace,
IProvideTooltipInfo {
    protected VLItemBlock itemBlock;
    protected boolean playerBreakOnly = false;

    public VLBlock(Material materialIn) {
        super(materialIn);
    }

    public VLBlock(Material mat, boolean playerBreakOnly) {
        super(mat);
        this.playerBreakOnly = playerBreakOnly;
    }

    @Override
    public ItemBlock getItemBlock() {
        if (this.itemBlock == null) {
            this.itemBlock = new VLItemBlock(this);
        }
        this.itemBlock.setRarity(this.getRarity(), 0);
        return this.itemBlock;
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasShiftTooltipInfo() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addShiftTooltipInfo(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltipInfo(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.playerBreakOnly()) {
            tooltip.add(LangUtil.toLoc("tooltip.valkyrielib.witherproof"));
            tooltip.add(LangUtil.toLoc("tooltip.valkyrielib.playerbreakonly"));
        }
    }

    public boolean playerBreakOnly() {
        return this.playerBreakOnly;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        TileEntity te = world.func_175625_s(pos);
        if (VLMConfigs.STRUCTURE_PROTECTION && te instanceof IOwnable && entity instanceof EntityPlayer) {
            Owner cOwner = ((IOwnable)te).getOwner();
            return cOwner != null ? cOwner.isOwner((EntityPlayer)entity) : false;
        }
        if (this.playerBreakOnly()) {
            return entity instanceof EntityPlayer;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public EnumRarity getRarity() {
        return EnumRarity.COMMON;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!this.playerBreakOnly()) {
            world.func_175698_g(pos);
            this.func_180652_a(world, pos, explosion);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        if (this.playerBreakOnly()) {
            return false;
        }
        return super.func_149659_a(explosionIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && this instanceof ITileEntityProvider && (te = worldIn.func_175625_s(pos)) instanceof ITleInfo) {
            String mess = ((ITleInfo)te).getInfo();
            ChatUtil.noSpamServer(playerIn, (List<ITextComponent>)ImmutableList.of((Object)new TextComponentString(mess)));
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public VLBlock setHarvest(String harvestTool, int harvestLevel) {
        this.setHarvestLevel(harvestTool, harvestLevel);
        return this;
    }

    public float getHardness() {
        return this.field_149782_v;
    }

    public float getResistance() {
        return this.field_149781_w;
    }

    public SoundType getBlockSoundType() {
        return this.field_149762_H;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof VLTile) {
            VLTile vt = (VLTile)te;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                return;
            }
            if (vt.canSaveOnPickup()) {
                vt.loadTileData(nbt.func_74775_l("valk_td"), true);
            }
        }
        if (te instanceof IOwnable) {
            IOwnable o = (IOwnable)te;
            if (placer instanceof EntityPlayer) {
                o.setOwner(((EntityPlayer)placer).func_146103_bH());
            } else {
                o.setOwner(Owner.NO_OWNER);
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this instanceof ITileEntityProvider) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof VLTile) {
                VLTile vt = (VLTile)te;
                if (vt.canSaveOnPickup()) {
                    Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
                    Item itm = this.func_180660_a(state, rand, fortune);
                    if (itm != Items.field_190931_a) {
                        ItemStack is = new ItemStack(itm, 1, this.func_180651_a(state));
                        NBTTagCompound nbt = is.func_77978_p();
                        if (nbt == null) {
                            is.func_77982_d(new NBTTagCompound());
                            nbt = is.func_77978_p();
                        }
                        NBTTagCompound sd = new NBTTagCompound();
                        ((VLTile)te).saveTileData(sd, true);
                        nbt.func_74782_a("valk_td", (NBTBase)sd);
                        is.func_77982_d(nbt);
                        drops.add((Object)is);
                    }
                } else {
                    super.getDrops(drops, world, pos, state, fortune);
                }
            }
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }
}

