/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.container;

import cofh.api.core.IAugmentable;
import cofh.core.block.TileCore;
import cofh.core.gui.container.ContainerCore;
import cofh.core.gui.container.IAugmentableContainer;
import cofh.core.gui.slot.SlotAugment;
import cofh.core.network.PacketCore;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ServerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ContainerTileAugmentable
extends ContainerCore
implements IAugmentableContainer {
    protected final TileCore baseTile;
    protected Slot[] augmentSlots = new Slot[0];
    protected boolean augmentLock = true;
    protected boolean hasAugSlots = true;
    protected boolean hasPlayerInvSlots = true;

    public ContainerTileAugmentable() {
        this.baseTile = null;
    }

    public ContainerTileAugmentable(TileEntity tile) {
        this.baseTile = (TileCore)tile;
    }

    public ContainerTileAugmentable(InventoryPlayer inventory, TileEntity tile) {
        this(inventory, tile, true, true);
    }

    public ContainerTileAugmentable(InventoryPlayer inventory, TileEntity tile, boolean augSlots, boolean playerInvSlots) {
        this.baseTile = tile instanceof TileCore ? (TileCore)tile : null;
        this.hasAugSlots = augSlots;
        this.hasPlayerInvSlots = playerInvSlots;
        if (this.hasAugSlots) {
            this.addAugmentSlots();
        }
        if (this.hasPlayerInvSlots) {
            this.bindPlayerInventory(inventory);
        }
    }

    @Override
    protected int getPlayerInventoryVerticalOffset() {
        return 84;
    }

    @Override
    protected int getSizeInventory() {
        if (this.baseTile instanceof IInventory) {
            return ((IInventory)this.baseTile).func_70302_i_();
        }
        return 0;
    }

    protected void addAugmentSlots() {
        if (this.baseTile instanceof IAugmentable) {
            this.augmentSlots = new Slot[((IAugmentable)((Object)this.baseTile)).getAugmentSlots().length];
            for (int i = 0; i < this.augmentSlots.length; ++i) {
                this.augmentSlots[i] = this.func_75146_a(new SlotAugment((IAugmentable)((Object)this.baseTile), null, i, 0, 0));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.baseTile == null || this.baseTile.isUsable(player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.baseTile == null) {
            return;
        }
        for (IContainerListener listener : this.field_75149_d) {
            this.baseTile.sendGuiNetworkData(this, listener);
        }
    }

    public void func_75137_b(int i, int j) {
        if (this.baseTile == null) {
            return;
        }
        this.baseTile.receiveGuiNetworkData(i, j);
    }

    @Override
    protected boolean performMerge(int slotIndex, ItemStack stack) {
        int invAugment = this.augmentSlots.length;
        int invPlayer = invAugment + 27;
        int invFull = invPlayer + 9;
        int invTile = invFull + (this.baseTile == null ? 0 : this.baseTile.getInvSlotCount());
        if (slotIndex < invAugment) {
            return this.func_75135_a(stack, invAugment, invFull, true);
        }
        if (slotIndex < invFull) {
            if (!this.augmentLock && invAugment > 0 && AugmentHelper.isAugmentItem(stack)) {
                return this.func_75135_a(stack, 0, invAugment, false);
            }
            return this.func_75135_a(stack, invFull, invTile, false);
        }
        return this.func_75135_a(stack, invAugment, invFull, true);
    }

    @Override
    public void setAugmentLock(boolean lock) {
        this.augmentLock = lock;
        if (ServerHelper.isClientWorld(this.baseTile.func_145831_w())) {
            PacketCore.sendTabAugmentPacketToServer(lock);
        }
    }

    @Override
    public Slot[] getAugmentSlots() {
        return this.augmentSlots;
    }
}

