/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.advancements.criteria;

import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.advancements.MonkRequirement;
import com.rwtema.monkmod.data.MonkData;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class MonkRequirementSleep
extends MonkRequirement {
    public MonkRequirementSleep(String name, int defaultRequirements) {
        super(name, defaultRequirements);
    }

    @SubscribeEvent
    public void rightClickBedrock(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (!world.field_73011_w.func_76567_e() || world.func_180494_b(pos) == Biomes.field_76778_j) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        MonkData monkData = MonkManager.get(player);
        if (monkData.getLevel() != this.levelToGrant - 1) {
            return;
        }
        if (!this.checkPos(world, pos)) {
            return;
        }
        event.setCancellationResult(EnumActionResult.SUCCESS);
        event.setCanceled(true);
        if (world.field_72995_K) {
            return;
        }
        player.func_180469_a(pos.func_177984_a());
    }

    protected abstract boolean checkPos(World var1, @Nonnull BlockPos var2);

    @SubscribeEvent
    public void awaken(@Nonnull PlayerWakeUpEvent event) {
        MonkData monkData;
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (entityPlayer.func_71026_bH() && entityPlayer instanceof EntityPlayerMP && (monkData = MonkManager.get(entityPlayer)).getLevel() == this.levelToGrant - 1 && this.checkPos(entityPlayer.field_70170_p, entityPlayer.field_71081_bT.func_177977_b())) {
            this.grantLevel((EntityPlayerMP)entityPlayer);
        }
    }

    @SubscribeEvent
    public void continueSleep(@Nonnull SleepingLocationCheckEvent event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        MonkData monkData = MonkManager.get(entityPlayer);
        if (monkData.getLevel() == this.levelToGrant - 1 && this.checkPos(entityPlayer.field_70170_p, event.getSleepingLocation().func_177977_b())) {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

