/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.advancements.criteria;

import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementTick;
import com.rwtema.monkmod.data.MonkData;
import com.rwtema.monkmod.helper.TranslateHelper;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MonkRequirementEnemyDefeat
extends MonkRequirementTick {
    private final WeakHashMap<EntityLivingBase, WeakHashMap<EntityPlayerMP, Entry>> entryTracker = new WeakHashMap();
    private final ResourceLocation id;

    public MonkRequirementEnemyDefeat(String name, int defaultRequirements, ResourceLocation id) {
        super(name, defaultRequirements);
        this.id = id;
    }

    @Override
    protected void doTick(@Nonnull EntityPlayerMP player, MonkData monkData) {
        if (!this.entryTracker.isEmpty() && !MonkAbility.isUnarmored((EntityPlayer)player)) {
            this.disqualifyPlayer(player);
        }
    }

    private void disqualifyPlayer(@Nonnull EntityPlayerMP player) {
        if (this.entryTracker.values().removeIf(m -> {
            Entry remove = (Entry)m.remove(player);
            if (remove != null) {
                remove.disqualified = true;
            }
            return m.isEmpty();
        })) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("monk.disqualify", new Object[0]), true);
        }
    }

    @SubscribeEvent
    public void onDeath(@Nonnull LivingDeathEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || this.entryTracker.isEmpty() || !this.id.equals((Object)EntityList.func_191301_a((Entity)event.getEntity()))) {
            return;
        }
        EntityLivingBase entityLiving = event.getEntityLiving();
        WeakHashMap<EntityPlayerMP, Entry> map = this.entryTracker.get(entityLiving);
        if (map == null) {
            return;
        }
        for (Map.Entry<EntityPlayerMP, Entry> playerMPEntryEntry : map.entrySet()) {
            EntityPlayerMP player = playerMPEntryEntry.getKey();
            MonkData monkData = MonkManager.get((EntityPlayer)player);
            if (!this.isWorkingToLevel(monkData) || playerMPEntryEntry.getValue().disqualified || !(playerMPEntryEntry.getValue().damage > event.getEntityLiving().func_110138_aP() / 4.0f) || !monkData.increase(1, this.requirementLimit)) continue;
            this.grantLevel(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamage(@Nonnull LivingDamageEvent event) {
        EntityPlayerMP player;
        MonkData monkData;
        DamageSource source;
        Entity trueSource;
        if (!event.getEntity().field_70170_p.field_72995_K && this.id.equals((Object)EntityList.func_191301_a((Entity)event.getEntity())) && (trueSource = (source = event.getSource()).func_76346_g()) instanceof EntityPlayerMP && this.isWorkingToLevel(monkData = MonkManager.get((EntityPlayer)(player = (EntityPlayerMP)trueSource)))) {
            if (source.func_76352_a()) {
                this.disqualifyPlayer(player);
            } else {
                Entry entry = this.entryTracker.computeIfAbsent(event.getEntityLiving(), t -> new WeakHashMap()).computeIfAbsent(player, p -> new Entry());
                entry.damage += event.getAmount();
            }
        }
    }

    @Override
    @Nonnull
    protected Object[] args() {
        String s1 = EntityList.func_191302_a((ResourceLocation)this.id);
        if (s1 == null) {
            s1 = "generic";
        }
        return new Object[]{this.requirementLimit, TranslateHelper.translateKey("entity." + s1 + ".name")};
    }

    private class Entry {
        boolean disqualified;
        float damage;

        private Entry() {
        }
    }
}

