/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;

public class JSonObjBuilder {
    @Nonnull
    private final JsonObject jsonObject = new JsonObject();

    public static void writeJSon(@Nonnull File file, JsonObject model) {
        try (FileWriter writer = new FileWriter(file.getPath());){
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setIndent("  ");
            jsonWriter.setLenient(true);
            Streams.write((JsonElement)model, (JsonWriter)jsonWriter);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static JSonObjBuilder json() {
        return new JSonObjBuilder();
    }

    @Nonnull
    public JsonObject build() {
        return this.jsonObject;
    }

    @Nonnull
    public JSonObjBuilder add(@Nonnull String property, JsonElement value) {
        this.jsonObject.add(property, value);
        return this;
    }

    @Nonnull
    public JSonObjBuilder add(@Nonnull String property, @Nonnull JSonObjBuilder value) {
        this.jsonObject.add(property, (JsonElement)value.build());
        return this;
    }

    @Nonnull
    public JSonObjBuilder add(@Nonnull String property, String value) {
        this.jsonObject.addProperty(property, value);
        return this;
    }

    @Nonnull
    public JSonObjBuilder add(@Nonnull String property, Number value) {
        this.jsonObject.addProperty(property, value);
        return this;
    }

    @Nonnull
    public JSonObjBuilder add(@Nonnull String property, Boolean value) {
        this.jsonObject.addProperty(property, value);
        return this;
    }

    @Nonnull
    public JSonObjBuilder add(@Nonnull String property, Character value) {
        this.jsonObject.addProperty(property, value);
        return this;
    }
}

