/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IPetalApothecary;
import vazkii.botania.api.recipe.IFlowerComponent;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AltarVariant;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.handler.ModSounds;

public class TileAltar
extends TileSimpleInventory
implements IPetalApothecary,
ITickable {
    private static final Pattern SEED_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)seed)|(?:(?:[a-z-_.:]|^)Seed))(?:[sA-Z-_.:]|$)");
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int CRAFT_EFFECT_EVENT = 1;
    public static final String TAG_HAS_WATER = "hasWater";
    public static final String TAG_HAS_LAVA = "hasLava";
    public static final String TAG_IS_MOSSY = "isMossy";
    public boolean hasWater = false;
    public boolean hasLava = false;
    public boolean isMossy = false;
    List<ItemStack> lastRecipe = null;
    int recipeKeepTicks = 0;

    public boolean collideEntityItem(EntityItem item) {
        boolean didChange;
        block11: {
            ItemStack stack;
            block12: {
                stack = item.func_92059_d();
                if (this.field_145850_b.field_72995_K || stack.func_190926_b() || item.field_70128_L) {
                    return false;
                }
                if (!this.isMossy && this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BotaniaStateProps.ALTAR_VARIANT) == AltarVariant.DEFAULT && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150395_bd)) {
                    this.isMossy = true;
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
                    stack.func_190918_g(1);
                    return true;
                }
                if (!this.hasWater() && !this.hasLava()) {
                    if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                        FluidStack drainWater = fluidHandler.drain(new FluidStack(FluidRegistry.WATER, 1000), false);
                        FluidStack drainLava = fluidHandler.drain(new FluidStack(FluidRegistry.LAVA, 1000), false);
                        if (drainWater != null && drainWater.getFluid() == FluidRegistry.WATER && drainWater.amount == 1000) {
                            this.setWater(true);
                            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
                            fluidHandler.drain(new FluidStack(FluidRegistry.WATER, 1000), true);
                            item.func_92058_a(fluidHandler.getContainer());
                            return true;
                        }
                        if (drainLava != null && drainLava.getFluid() == FluidRegistry.LAVA && drainLava.amount == 1000) {
                            this.setLava(true);
                            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
                            fluidHandler.drain(new FluidStack(FluidRegistry.LAVA, 1000), true);
                            item.func_92058_a(fluidHandler.getContainer());
                            return true;
                        }
                    }
                    return false;
                }
                if (this.hasLava()) {
                    item.func_70015_d(100);
                    return true;
                }
                didChange = false;
                if (!this.isFlowerComponent(stack)) break block12;
                if (!this.itemHandler.getStackInSlot(this.getSizeInventory() - 1).func_190926_b()) {
                    return false;
                }
                for (int i = 0; i < this.getSizeInventory(); ++i) {
                    if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
                    this.itemHandler.setStackInSlot(i, stack.func_77979_a(1));
                    didChange = true;
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.1f, 10.0f);
                    break block11;
                }
                break block11;
            }
            if (stack.func_190926_b() || !SEED_PATTERN.matcher(stack.func_77973_b().func_77667_c(stack)).find()) break block11;
            for (RecipePetals recipe : BotaniaAPI.petalRecipes) {
                if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
                this.saveLastRecipe();
                for (int i = 0; i < this.getSizeInventory(); ++i) {
                    this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
                stack.func_190918_g(1);
                ItemStack output = recipe.getOutput().func_77946_l();
                EntityItem outputItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                this.field_145850_b.func_72838_d((Entity)outputItem);
                this.setWater(false);
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
                this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, 0);
                didChange = true;
                break;
            }
        }
        return didChange;
    }

    private IFlowerComponent getFlowerComponent(ItemStack stack) {
        IFlowerComponent c = null;
        if (stack.func_77973_b() instanceof IFlowerComponent) {
            c = (IFlowerComponent)stack.func_77973_b();
        } else if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof IFlowerComponent) {
            c = (IFlowerComponent)((ItemBlock)stack.func_77973_b()).func_179223_d();
        }
        return c;
    }

    private boolean isFlowerComponent(ItemStack stack) {
        IFlowerComponent c = this.getFlowerComponent(stack);
        return c != null && c.canFit(stack, this);
    }

    public void saveLastRecipe() {
        ItemStack stack;
        this.lastRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSizeInventory() && !(stack = this.itemHandler.getStackInSlot(i)).func_190926_b(); ++i) {
            this.lastRecipe.add(stack.func_77946_l());
        }
        this.recipeKeepTicks = 400;
        this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.altar, 0, 400);
    }

    public void trySetLastRecipe(EntityPlayer player) {
        TileAltar.tryToSetLastRecipe(player, (IItemHandlerModifiable)this.itemHandler, this.lastRecipe);
        if (!this.isEmpty()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
    }

    public static void tryToSetLastRecipe(EntityPlayer player, IItemHandlerModifiable inv, List<ItemStack> lastRecipe) {
        if (lastRecipe == null || lastRecipe.isEmpty() || player.field_70170_p.field_72995_K) {
            return;
        }
        int index = 0;
        boolean didAny = false;
        block0: for (ItemStack stack : lastRecipe) {
            if (stack.func_190926_b()) continue;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack pstack = player.field_71071_by.func_70301_a(i);
                if (pstack.func_190926_b() || !pstack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)pstack)) continue;
                inv.setStackInSlot(index, pstack.func_77979_a(1));
                didAny = true;
                ++index;
                continue block0;
            }
        }
        if (didAny) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.1f, 10.0f);
            EntityPlayerMP mp = (EntityPlayerMP)player;
            mp.field_71069_bz.func_75142_b();
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c.func_177963_a(0.0, 1.25, 0.0), this.field_174879_c.func_177963_a(1.0, 2.0, 1.0)));
            boolean didChange = false;
            for (EntityItem item : items) {
                didChange = this.collideEntityItem(item) || didChange;
            }
            if (didChange) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
            }
        } else {
            ItemStack stackAt;
            for (int i = 0; i < this.getSizeInventory() && !(stackAt = this.itemHandler.getStackInSlot(i)).func_190926_b(); ++i) {
                if (!(Math.random() >= 0.97) || this.getFlowerComponent(stackAt) == null) continue;
                Color color = new Color(this.getFlowerComponent(stackAt).getParticleColor(stackAt));
                float red = (float)color.getRed() / 255.0f;
                float green = (float)color.getGreen() / 255.0f;
                float blue = (float)color.getBlue() / 255.0f;
                if (Math.random() >= 0.75) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.1f, 10.0f);
                }
                Botania.proxy.sparkleFX((double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, red, green, blue, (float)Math.random(), 10);
            }
            if (this.hasLava()) {
                this.isMossy = false;
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.05, 0.0, new int[0]);
                if (Math.random() > 0.9) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.01, 0.0, new int[0]);
                }
            }
        }
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.lastRecipe = null;
        }
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        super.writePacketNBT(cmp);
        cmp.func_74757_a(TAG_HAS_WATER, this.hasWater());
        cmp.func_74757_a(TAG_HAS_LAVA, this.hasLava());
        cmp.func_74757_a(TAG_IS_MOSSY, this.isMossy);
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        super.readPacketNBT(cmp);
        this.hasWater = cmp.func_74767_n(TAG_HAS_WATER);
        this.hasLava = cmp.func_74767_n(TAG_HAS_LAVA);
        this.isMossy = cmp.func_74767_n(TAG_IS_MOSSY);
    }

    @Override
    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        boolean lastMossy = this.isMossy;
        super.onDataPacket(manager, packet);
        if (this.isMossy != lastMossy) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public boolean func_145842_c(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                if (this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        Botania.proxy.sparkleFX((double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, red, green, blue, (float)Math.random(), 10);
                    }
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.altarCraft, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.func_145842_c(id, param);
    }

    @Override
    public int getSizeInventory() {
        return 16;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, false){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
    }

    @Override
    public void setWater(boolean water) {
        this.hasWater = water;
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
    }

    public void setLava(boolean lava) {
        this.hasLava = lava;
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public boolean hasWater() {
        return this.hasWater;
    }

    public boolean hasLava() {
        return this.hasLava;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        int xc = res.func_78326_a() / 2;
        int yc = res.func_78328_b() / 2;
        float angle = -90.0f;
        int radius = 24;
        int amt = 0;
        for (int i = 0; i < this.getSizeInventory() && !this.itemHandler.getStackInSlot(i).func_190926_b(); ++i) {
            ++amt;
        }
        if (amt > 0) {
            float anglePer = 360.0f / (float)amt;
            for (RecipePetals recipe : BotaniaAPI.petalRecipes) {
                if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_110577_a(HUDHandler.manaBar);
                RenderHelper.drawTexturedModalRect(xc + radius + 9, yc - 8, 0.0f, 0, 8, 22, 15);
                ItemStack stack = recipe.getOutput();
                net.minecraft.client.renderer.RenderHelper.func_74520_c();
                mc.func_175599_af().func_175042_a(stack, xc + radius + 32, yc - 8);
                mc.func_175599_af().func_175042_a(new ItemStack(Items.field_151014_N), xc + radius + 16, yc + 6);
                net.minecraft.client.renderer.RenderHelper.func_74518_a();
                mc.field_71466_p.func_175063_a("+", (float)(xc + radius + 14), (float)(yc + 10), 0xFFFFFF);
            }
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            for (int i = 0; i < amt; ++i) {
                double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                GlStateManager.func_179137_b((double)xPos, (double)yPos, (double)0.0);
                mc.func_175599_af().func_175042_a(this.itemHandler.getStackInSlot(i), 0, 0);
                GlStateManager.func_179137_b((double)(-xPos), (double)(-yPos), (double)0.0);
                angle += anglePer;
            }
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
        } else if (this.recipeKeepTicks > 0 && this.hasWater) {
            String s = I18n.func_135052_a((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(s, (float)(xc - mc.field_71466_p.func_78256_a(s) / 2), (float)(yc + 10), 0xFFFFFF);
            s = I18n.func_135052_a((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(s, (float)(xc - mc.field_71466_p.func_78256_a(s) / 2), (float)(yc + 20), 0xFFFFFF);
        }
    }
}

