/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;

public class GuiHelpers {
    public static void renderFluidTank(Gui gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height) {
        if (fluidStack != null && capacity > 0) {
            int level = height * fluidStack.amount / capacity;
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon(fluidStack, EnumFacing.UP);
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                RenderHelpers.bindTexture(TextureMap.field_110575_b);
                Triple<Float, Float, Float> colorParts = Helpers.intToRGB(fluidStack.getFluid().getColor(fluidStack));
                GlStateManager.func_179124_c((float)((Float)colorParts.getLeft()).floatValue(), (float)((Float)colorParts.getMiddle()).floatValue(), (float)((Float)colorParts.getRight()).floatValue());
                gui.func_175175_a(x, y - textureHeight - verticalOffset + height, icon, width, textureHeight);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                verticalOffset += 16;
            }
        }
    }

    public static void renderOverlayedFluidTank(Gui gui, @Nullable FluidStack fluidStack, int capacity, int x, int y, int width, int height, ResourceLocation textureOverlay, int overlayTextureX, int overlayTextureY) {
        GuiHelpers.renderFluidTank(gui, fluidStack, capacity, x, y, width, height);
        if (fluidStack != null && capacity > 0) {
            GlStateManager.func_179147_l();
            RenderHelpers.bindTexture(textureOverlay);
            gui.func_73729_b(x, y, overlayTextureX, overlayTextureY, width, height);
        }
    }

    public static void renderProgressBar(Gui gui, int x, int y, int width, int height, int textureX, int textureY, ProgressDirection direction, int progress, int progressMax) {
        if (progressMax > 0 && progress > 0) {
            int offset;
            int scaledWidth = width;
            int scaledHeight = height;
            if (direction.getIncrementX() != 0) {
                scaledWidth = scaledWidth * progress / progressMax;
            }
            if (direction.getIncrementY() != 0) {
                scaledHeight = scaledHeight * progress / progressMax;
            }
            if (direction.getIncrementX() < 0) {
                offset = width - scaledWidth;
                x += offset;
                textureX += offset;
            }
            if (direction.getIncrementY() < 0) {
                offset = height - scaledHeight;
                y += offset;
                textureY += offset;
            }
            gui.func_73729_b(x, y, textureX, textureY, scaledWidth, scaledHeight);
        }
    }

    public static void renderTooltipOptional(GuiContainerExtended gui, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<Optional<List<String>>> linesSupplier) {
        if (gui.func_146978_c(x, y, width, height, mouseX, mouseY)) {
            linesSupplier.get().ifPresent(lines -> gui.drawTooltip((List<String>)lines, mouseX - gui.getGuiLeft(), mouseY - gui.getGuiTop()));
        }
    }

    public static void renderTooltip(GuiContainerExtended gui, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<List<String>> linesSupplier) {
        GuiHelpers.renderTooltipOptional(gui, x, y, width, height, mouseX, mouseY, () -> Optional.of(linesSupplier.get()));
    }

    public static enum ProgressDirection {
        UP(0, -1),
        DOWN(0, 1),
        LEFT(-1, 0),
        RIGHT(1, 0),
        UP_LEFT(-1, -1),
        UP_RIGHT(1, -1),
        DOWN_LEFT(-1, 1),
        DOWN_RIGHT(1, 1);

        private final int incrementX;
        private final int incrementY;

        private ProgressDirection(int incrementX, int incrementY) {
            this.incrementX = incrementX;
            this.incrementY = incrementY;
        }

        public int getIncrementX() {
            return this.incrementX;
        }

        public int getIncrementY() {
            return this.incrementY;
        }
    }
}

