/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.handlers;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesNotifications;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesPlayerEventHandler {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(Universe.get().getPlayer((ICommandSender)event.getEntity()));
            data.setLastDeath(new BlockDimPos(event.getEntity()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onChunkChanged(EntityEvent.EnteringChunk event) {
        if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof EntityPlayerMP) || !Universe.loaded()) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        player.func_143004_u();
        ForgePlayer p = Universe.get().getPlayer(player.func_146103_bH());
        if (p == null || p.isFake()) {
            return;
        }
        FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(p);
        data.setLastSafePos(new BlockDimPos((Entity)player));
        FTBUtilitiesNotifications.updateChunkMessage(data, player, new ChunkDimPos(event.getNewChunkX(), event.getNewChunkZ(), player.field_71093_bK));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityAttacked(AttackEntityEvent event) {
        if (!ClaimedChunks.canAttackEntity(event.getEntityPlayer(), event.getTarget())) {
            InvUtils.forceUpdate((EntityPlayer)event.getEntityPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (ClaimedChunks.blockBlockInteractions(event.getEntityPlayer(), event.getPos(), null)) {
            InvUtils.forceUpdate((EntityPlayer)event.getEntityPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (ClaimedChunks.blockItemUse(event.getEntityPlayer(), event.getHand(), event.getPos())) {
            InvUtils.forceUpdate((EntityPlayer)event.getEntityPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (ClaimedChunks.blockBlockEditing(event.getPlayer(), event.getPos(), event.getState())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (ClaimedChunks.blockBlockEditing(event.getPlayer(), event.getPos(), event.getPlacedBlock())) {
            InvUtils.forceUpdate((EntityPlayer)event.getPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (ClaimedChunks.blockBlockEditing(event.getEntityPlayer(), event.getPos(), null)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onNameFormat(PlayerEvent.NameFormat event) {
        FTBUtilitiesPlayerData data;
        ForgePlayer p;
        if (FTBUtilitiesConfig.commands.nick && Universe.loaded() && event.getEntityPlayer() instanceof EntityPlayerMP && (p = Universe.get().getPlayer(event.getEntityPlayer().func_146103_bH())) != null && !(data = FTBUtilitiesPlayerData.get(p)).getNickname().isEmpty() && PermissionAPI.hasPermission((EntityPlayer)event.getEntityPlayer(), (String)"ftbutilities.chat.nickname.set")) {
            String name = data.getNickname().replace('&', '\u00a7');
            if (!p.hasPermission("ftbutilities.chat.nickname.colors")) {
                name = StringUtils.unformatted((String)name);
            } else if (name.indexOf(167) != -1) {
                name = name + TextFormatting.RESET;
            }
            if (FTBUtilitiesConfig.chat.add_nickname_tilde) {
                name = "~" + name;
            }
            event.setDisplayname(name);
        }
    }

    private static String getStateName(IBlockState state) {
        if (state == state.func_177230_c().func_176223_P()) {
            return state.func_177230_c().getRegistryName().toString();
        }
        return state.toString();
    }

    private static String getDim(EntityPlayer player) {
        return ServerUtils.getDimensionName((int)player.field_71093_bK).func_150260_c();
    }

    private static String getPos(BlockPos pos) {
        return String.format("[%d, %d, %d]", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @SubscribeEvent
    public static void onBlockBreakLog(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (FTBUtilitiesConfig.world.logging.block_broken && player instanceof EntityPlayerMP && FTBUtilitiesConfig.world.logging.log((EntityPlayerMP)player)) {
            FTBUtilitiesUniverseData.worldLog(String.format("%s broke %s at %s in %s", player.func_70005_c_(), FTBUtilitiesPlayerEventHandler.getStateName(event.getState()), FTBUtilitiesPlayerEventHandler.getPos(event.getPos()), FTBUtilitiesPlayerEventHandler.getDim(player)));
        }
    }

    @SubscribeEvent
    public static void onBlockPlaceLog(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        if (FTBUtilitiesConfig.world.logging.block_placed && player instanceof EntityPlayerMP && FTBUtilitiesConfig.world.logging.log((EntityPlayerMP)player)) {
            FTBUtilitiesUniverseData.worldLog(String.format("%s placed %s at %s in %s", player.func_70005_c_(), FTBUtilitiesPlayerEventHandler.getStateName(event.getState()), FTBUtilitiesPlayerEventHandler.getPos(event.getPos()), FTBUtilitiesPlayerEventHandler.getDim(player)));
        }
    }

    @SubscribeEvent
    public static void onRightClickItemLog(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        if (FTBUtilitiesConfig.world.logging.item_clicked_in_air && player instanceof EntityPlayerMP && FTBUtilitiesConfig.world.logging.log((EntityPlayerMP)player)) {
            FTBUtilitiesUniverseData.worldLog(String.format("%s clicked %s in air at %s in %s", player.func_70005_c_(), event.getItemStack().func_77973_b().getRegistryName(), FTBUtilitiesPlayerEventHandler.getPos(event.getPos()), FTBUtilitiesPlayerEventHandler.getDim(player)));
        }
    }
}

