/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command.chunks;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.command.CommandUtils;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesNotifications;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class CmdClaim
extends CmdBase {
    public CmdClaim() {
        super("claim", CmdBase.Level.ALL);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!ClaimedChunks.isActive()) {
            throw FTBLib.error((ICommandSender)sender, (String)"feature_disabled_server", (Object[])new Object[0]);
        }
        EntityPlayerMP player = CmdClaim.func_71521_c((ICommandSender)sender);
        ForgePlayer p = CommandUtils.getSelfOrOther((ICommandSender)player, (String[])args, (int)0, (String)"ftbutilities.other_player.claims.claim");
        ChunkDimPos pos = new ChunkDimPos((Entity)player);
        if (!player.func_110124_au().equals(p.getId()) && !ClaimedChunks.instance.canPlayerModify(p, pos, "ftbutilities.other_player.claims.claim")) {
            FTBUtilitiesNotifications.sendCantModifyChunk(server, player);
            return;
        }
        switch (ClaimedChunks.instance.claimChunk(p, pos)) {
            case SUCCESS: {
                Notification.of((ResourceLocation)FTBUtilitiesNotifications.CHUNK_MODIFIED, (ITextComponent[])new ITextComponent[]{FTBUtilities.lang((ICommandSender)player, "ftbutilities.lang.chunks.chunk_claimed", new Object[0])}).send(server, (EntityPlayer)player);
                FTBUtilitiesNotifications.updateChunkMessage(FTBUtilitiesPlayerData.get(p), player, pos);
                break;
            }
            case DIMENSION_BLOCKED: {
                Notification.of((ResourceLocation)FTBUtilitiesNotifications.CHUNK_CANT_CLAIM, (ITextComponent[])new ITextComponent[]{FTBUtilities.lang((ICommandSender)player, "ftbutilities.lang.chunks.claiming_not_enabled_dim", new Object[0])}).setError().send(server, (EntityPlayer)player);
                break;
            }
            case NO_POWER: {
                break;
            }
            default: {
                FTBUtilitiesNotifications.sendCantModifyChunk(server, player);
            }
        }
    }
}

