/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command;

import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.command.CommandUtils;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class CmdKillall
extends CmdBase {
    private static final Predicate<Entity> ALL = CommonUtils.alwaysTruePredicate();
    private static final Predicate<Entity> ITEM = entity -> entity instanceof EntityItem;
    private static final Predicate<Entity> XP = entity -> entity instanceof EntityXPOrb;
    private static final Predicate<Entity> MOB = entity -> entity instanceof IMob;
    private static final Predicate<Entity> ANIMAL = entity -> entity instanceof EntityAnimal;
    private static final Predicate<Entity> LIVING = entity -> entity instanceof EntityLivingBase;
    private static final Predicate<Entity> PLAYER = entity -> entity instanceof EntityPlayer;
    private static final Predicate<Entity> NON_LIVING = entity -> !(entity instanceof EntityLivingBase);
    private static final Predicate<Entity> NON_PLAYER = entity -> !(entity instanceof EntityPlayer);
    private static final List<String> TAB = Arrays.asList("all", "items", "xp", "monsters", "animals", "living", "players", "non_living", "non_players");

    public CmdKillall() {
        super("killall", CmdBase.Level.OP);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CmdKillall.func_175762_a((String[])args, TAB);
        }
        if (args.length == 2) {
            return CmdKillall.func_175762_a((String[])args, (Collection)CommandUtils.getDimensionNames());
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Predicate<Entity> predicate = NON_PLAYER;
        String type = "non_players";
        if (args.length >= 1) {
            switch (args[0]) {
                case "all": {
                    predicate = ALL;
                    type = "all";
                    break;
                }
                case "item": 
                case "items": {
                    predicate = ITEM;
                    type = "items";
                    break;
                }
                case "xp": 
                case "experience": {
                    predicate = XP;
                    type = "xp";
                    break;
                }
                case "mob": 
                case "mobs": 
                case "monster": 
                case "monsters": {
                    predicate = MOB;
                    type = "monsters";
                    break;
                }
                case "animal": 
                case "animals": {
                    predicate = ANIMAL;
                    type = "animals";
                    break;
                }
                case "living": 
                case "alive": {
                    predicate = LIVING;
                    type = "living";
                    break;
                }
                case "player": 
                case "players": {
                    predicate = PLAYER;
                    type = "players";
                    break;
                }
                case "non_living": {
                    predicate = NON_LIVING;
                    type = "non_living";
                    break;
                }
                case "non_players": {
                    predicate = NON_PLAYER;
                    type = "non_players";
                }
            }
        }
        OptionalInt dimension = CommandUtils.parseDimension((ICommandSender)sender, (String[])args, (int)1);
        int killed = 0;
        for (WorldServer world : server.field_71305_c) {
            for (Entity entity : new ArrayList(world.field_72996_f)) {
                if (!predicate.test(entity) || dimension.isPresent() && dimension.getAsInt() != entity.field_71093_bK) continue;
                entity.func_174812_G();
                ++killed;
            }
        }
        sender.func_145747_a(FTBUtilities.lang(sender, "ftbutilities.lang.killed_entities", killed, type));
    }
}

