/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.rebornstorage.tiles;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import java.util.Optional;
import javax.annotation.Nullable;
import me.modmuss50.rebornstorage.blocks.BlockMultiCrafter;
import me.modmuss50.rebornstorage.init.ModBlocks;
import me.modmuss50.rebornstorage.multiblocks.MultiBlockCrafter;
import me.modmuss50.rebornstorage.tiles.CraftingNode;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockValidationException;
import reborncore.common.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import reborncore.common.util.Inventory;

public class TileMultiCrafter
extends RectangularMultiblockTileEntityBase
implements INetworkNodeProxy {
    public Optional<Integer> page = Optional.empty();
    public Optional<Integer> lastPage = Optional.empty();
    ItemStack stack = ItemStack.field_190927_a;
    CraftingNode node;
    CraftingNode clientNode;

    public void isGoodForFrame() throws MultiblockValidationException {
        if (!this.getVarient().equals("frame")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the frame of the block");
        }
    }

    public void isGoodForSides() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat") && !this.getVarient().equals("io")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForTop() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForBottom() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForInterior() throws MultiblockValidationException {
        if (!this.getVarient().equals("cpu") && !this.getVarient().equals("storage")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the inside of the block");
        }
    }

    public void onMachineActivated() {
        this.getNode().rebuildPatterns();
    }

    public void onMachineDeactivated() {
        this.getNode().rebuildPatterns();
    }

    public String getVarient() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockMultiCrafter)) {
            return "unknown";
        }
        return (String)((Object)state.func_177229_b((IProperty)BlockMultiCrafter.VARIANTS));
    }

    public MultiblockControllerBase createNewMultiblock() {
        return new MultiBlockCrafter(this.func_145831_w());
    }

    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return MultiBlockCrafter.class;
    }

    public MultiBlockCrafter getMultiBlock() {
        return (MultiBlockCrafter)this.getMultiblockController();
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("hasInv")) {
            Inventory oldInv = new Inventory(78, "storageBlock", 1, (TileEntity)this);
            oldInv.readFromNBT(data);
            CraftingNode.CachingItemHandler itemHandler = this.getNode().patterns;
            for (int i = 0; i < oldInv.contents.length; ++i) {
                ItemStack stack = oldInv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                itemHandler.setStackInSlot(i, stack.func_77946_l());
            }
            this.getNode().markDirty();
        }
        if (data.func_74764_b("page")) {
            this.page = Optional.of(data.func_74762_e("page"));
        }
        if (data.func_74764_b("lastPage")) {
            this.lastPage = Optional.of(data.func_74762_e("lastPage"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        if (this.page.isPresent()) {
            data.func_74768_a("page", this.page.get().intValue());
        }
        if (this.lastPage.isPresent()) {
            data.func_74768_a("lastPage", this.lastPage.get().intValue());
        }
        return super.func_189515_b(data);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public ItemStack getStack() {
        if (this.stack.func_190926_b()) {
            this.stack = new ItemStack(ModBlocks.BLOCK_MULTI_CRAFTER, 1, ModBlocks.BLOCK_MULTI_CRAFTER.func_176201_c(this.field_145850_b.func_180495_p(this.func_174877_v())));
        }
        return this.stack;
    }

    public void updateLastPage(int page) {
        if (this.getMultiBlock() != null) {
            for (IMultiblockPart part : this.getMultiBlock().connectedParts) {
                TileMultiCrafter tile = (TileMultiCrafter)part;
                tile.lastPage = Optional.of(page);
            }
        }
        this.lastPage = Optional.of(page);
    }

    public int getValidLastPage() {
        int page;
        if (this.lastPage.isPresent() && this.getMultiBlock() != null && (page = this.lastPage.get().intValue()) <= this.getMultiBlock().invs.size()) {
            return page;
        }
        return 0;
    }

    public CraftingNode getNode() {
        if (this.field_145850_b.field_72995_K) {
            if (this.clientNode == null) {
                this.clientNode = new CraftingNode(this.field_145850_b, this.func_174877_v());
            }
            return this.clientNode;
        }
        INetworkNodeManager manager = API.instance().getNetworkNodeManager(this.field_145850_b);
        INetworkNode node = manager.getNode(this.field_174879_c);
        if (node == null || !node.getId().equals("rebornstorage:multiblockcrafter")) {
            node = new CraftingNode(this.field_145850_b, this.func_174877_v());
            manager.setNode(this.field_174879_c, node);
            manager.markForSaving();
        }
        return (CraftingNode)node;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
    }
}

