/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.rebornstorage.tiles;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.modmuss50.rebornstorage.multiblocks.MultiBlockCrafter;
import me.modmuss50.rebornstorage.tiles.TileMultiCrafter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import reborncore.RebornCore;

public class CraftingNode
implements INetworkNode,
ICraftingPatternContainer {
    World world;
    BlockPos pos;
    List<ICraftingPattern> actualPatterns = new ArrayList<ICraftingPattern>();
    @Nullable
    INetwork network;
    int ticks = 0;
    private UUID uuid;
    public CachingItemHandler patterns = new CachingItemHandler(78, (Consumer)new ListenerNetworkNode((INetworkNode)this), new Predicate[]{s -> s.func_77973_b() instanceof ICraftingPatternProvider && ((ICraftingPatternProvider)s.func_77973_b()).create(this.world, s, (ICraftingPatternContainer)this).isValid()}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CraftingNode.this.markDirty();
            if (!CraftingNode.this.world.field_72995_K) {
                CraftingNode.this.rebuildPatterns();
            }
            if (CraftingNode.this.network != null) {
                CraftingNode.this.network.getCraftingManager().rebuild();
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public CraftingNode(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void rebuildPatterns() {
        this.actualPatterns.clear();
        if (!this.world.field_72995_K && this.isValidMultiBlock()) {
            for (int i = 0; i < this.patterns.getSlots(); ++i) {
                ICraftingPattern pattern;
                ItemStack stack = this.patterns.getStackInSlot(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICraftingPatternProvider) || !(pattern = ((ICraftingPatternProvider)stack.func_77973_b()).create(this.world, stack, (ICraftingPatternContainer)this)).isValid()) continue;
                this.actualPatterns.add(pattern);
            }
        }
        if (this.getNetwork() != null) {
            this.getNetwork().getCraftingManager().rebuild();
        }
    }

    protected void stateChange(INetwork network, boolean state) {
        if (!state) {
            network.getCraftingManager().getTasks().forEach(task -> network.getCraftingManager().cancel(task.getId()));
            this.actualPatterns.clear();
        }
        network.getCraftingManager().rebuild();
    }

    @Nullable
    public TileMultiCrafter getTile() {
        TileEntity tileEntity = this.world.func_175625_s(this.pos);
        if (tileEntity instanceof TileMultiCrafter) {
            return (TileMultiCrafter)tileEntity;
        }
        RebornCore.logHelper.debug((Object)(tileEntity + " is not an instance of TileMultiCrafter, this is an error and your RebornStorage multiblock may not work. Please report to the mod author"));
        return null;
    }

    public boolean isValidMultiBlock() {
        TileMultiCrafter tileMultiCrafter = this.getTile();
        if (tileMultiCrafter == null) {
            return false;
        }
        MultiBlockCrafter multiBlockCrafter = this.getTile().getMultiBlock();
        if (multiBlockCrafter == null) {
            return false;
        }
        return multiBlockCrafter.isAssembled();
    }

    public int getEnergyUsage() {
        return 1;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.getTile().getStack();
    }

    public void onConnected(INetwork iNetwork) {
        this.network = iNetwork;
        this.stateChange(this.network, true);
        this.rebuildPatterns();
    }

    public void onDisconnected(INetwork iNetwork) {
        this.network = null;
        this.actualPatterns.clear();
        this.stateChange(iNetwork, true);
    }

    public boolean canUpdate() {
        return true;
    }

    @Nullable
    public INetwork getNetwork() {
        return this.network;
    }

    public void update() {
        ++this.ticks;
        if (this.ticks == 1) {
            this.rebuildPatterns();
        }
    }

    public NBTTagCompound write(NBTTagCompound nbtTagCompound) {
        StackUtils.writeItems((IItemHandler)this.patterns, (int)0, (NBTTagCompound)nbtTagCompound);
        return nbtTagCompound;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public World getWorld() {
        return this.world;
    }

    public void markDirty() {
        if (!this.world.field_72995_K) {
            API.instance().getNetworkNodeManager(this.world).markForSaving();
        }
    }

    public String getId() {
        return "rebornstorage:multiblockcrafter";
    }

    public int getSpeedUpgradeCount() {
        if (!this.isValidMultiBlock()) {
            return 0;
        }
        return this.getTile().getMultiBlock().speed;
    }

    public IItemHandler getConnectedInventory() {
        return null;
    }

    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        return null;
    }

    public TileEntity getConnectedTile() {
        return null;
    }

    public TileEntity getFacingTile() {
        return null;
    }

    public EnumFacing getDirection() {
        return null;
    }

    public List<ICraftingPattern> getPatterns() {
        return this.actualPatterns;
    }

    public IItemHandlerModifiable getPatternInventory() {
        if (this.isValidMultiBlock() && this.getTile().getVarient() != null && this.getTile().getVarient().equals("storage")) {
            return this.patterns;
        }
        return null;
    }

    public String getName() {
        return "MultiBlock Crafter";
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        return null;
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public abstract class CachingItemHandler
    extends ItemHandlerBase {
        private int firstAvailable;
        private int lastUsed;

        public CachingItemHandler(@Nullable int size, Consumer<Integer> listener, Predicate<ItemStack> ... validators) {
            super(size, listener, (Predicate[])validators);
            this.firstAvailable = 0;
            this.lastUsed = -1;
        }

        protected void onLoad() {
            super.onLoad();
            this.firstAvailable = this.getSlots();
            this.lastUsed = -1;
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_190926_b()) {
                    this.firstAvailable = Integer.min(this.firstAvailable, i);
                    continue;
                }
                this.lastUsed = Integer.max(this.lastUsed, i);
            }
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            int i = slot;
            while (i < this.firstAvailable && i >= 0 && this.getStackInSlot(i).func_190926_b()) {
                this.firstAvailable = i--;
            }
            for (i = slot; i == this.firstAvailable && i < this.getSlots() && !this.getStackInSlot(i).func_190926_b(); ++i) {
                this.firstAvailable = i + 1;
            }
            i = slot;
            while (i > this.lastUsed && i < this.getSlots() && !this.getStackInSlot(i).func_190926_b()) {
                this.lastUsed = i++;
            }
            for (i = slot; i == this.lastUsed && i >= 0 && this.getStackInSlot(i).func_190926_b(); --i) {
                this.lastUsed = i - 1;
            }
        }

        public int getFirstAvailable() {
            return this.firstAvailable;
        }

        public int getLastUsed() {
            return this.lastUsed;
        }

        public boolean isEmpty() {
            return this.lastUsed == -1;
        }

        public boolean isFull() {
            return this.firstAvailable == this.getSlots();
        }
    }
}

