/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla;

import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.commoncapabilities.capability.temperature.TemperatureConfig;
import org.cyclops.commoncapabilities.capability.worker.WorkerConfig;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage.VanillaEntityItemEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage.VanillaEntityItemFrameEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler.VanillaEntityItemFluidHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler.VanillaEntityItemFrameFluidHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaEntityItemFrameItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaEntityItemItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaItemShulkerBoxItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaFurnaceTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaUniversalBucketTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaBrewingStandWorker;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaFurnaceWorker;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;

public class VanillaModCompat
implements IModCompat {
    public String getModID() {
        return "Minecraft";
    }

    public boolean isEnabled() {
        return true;
    }

    public String getComment() {
        return "Furnace and Brewing stand capabilities.";
    }

    public void onInit(IInitListener.Step initStep) {
        if (initStep == IInitListener.Step.INIT) {
            CapabilityConstructorRegistry registry = CommonCapabilities._instance.getCapabilityConstructorRegistry();
            registry.registerTile(TileEntityFurnace.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, TileEntityFurnace>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(TileEntityFurnace host) {
                    return new DefaultCapabilityProvider(WorkerConfig.CAPABILITY, (Object)new VanillaFurnaceWorker(host));
                }
            });
            registry.registerTile(TileEntityBrewingStand.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, TileEntityBrewingStand>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(TileEntityBrewingStand host) {
                    return new DefaultCapabilityProvider(WorkerConfig.CAPABILITY, (Object)new VanillaBrewingStandWorker(host));
                }
            });
            registry.registerTile(TileEntityFurnace.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, TileEntityFurnace>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(TileEntityFurnace host) {
                    return new DefaultCapabilityProvider(TemperatureConfig.CAPABILITY, (Object)new VanillaFurnaceTemperature(host));
                }
            });
            registry.registerItem(UniversalBucket.class, (ICapabilityConstructor)new ICapabilityConstructor<ITemperature, UniversalBucket, ItemStack>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(UniversalBucket hostType, ItemStack host) {
                    return new DefaultCapabilityProvider(TemperatureConfig.CAPABILITY, (Object)new VanillaUniversalBucketTemperature(host));
                }
            });
            registry.registerItem(ItemShulkerBox.class, (ICapabilityConstructor)new ICapabilityConstructor<IItemHandler, ItemShulkerBox, ItemStack>(){

                public Capability<IItemHandler> getCapability() {
                    return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemShulkerBox hostType, ItemStack host) {
                    return new DefaultCapabilityProvider(this.getCapability(), (Object)new VanillaItemShulkerBoxItemHandler(host));
                }
            });
            registry.registerEntity(EntityItem.class, (ICapabilityConstructor)new ICapabilityConstructor<IItemHandler, EntityItem, EntityItem>(){

                public Capability<IItemHandler> getCapability() {
                    return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(EntityItem hostType, final EntityItem host) {
                    return new ICapabilityProvider(){

                        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && host.func_92059_d().hasCapability(capability, facing);
                        }

                        @Nullable
                        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                            return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && host.func_92059_d().hasCapability(capability, facing) ? new VanillaEntityItemItemHandler(host, facing) : null);
                        }
                    };
                }
            });
            registry.registerEntity(EntityItemFrame.class, (ICapabilityConstructor)new ICapabilityConstructor<IItemHandler, EntityItemFrame, EntityItemFrame>(){

                public Capability<IItemHandler> getCapability() {
                    return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(EntityItemFrame hostType, final EntityItemFrame host) {
                    return new ICapabilityProvider(){

                        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && host.func_82335_i().hasCapability(capability, facing);
                        }

                        @Nullable
                        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                            return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && host.func_82335_i().hasCapability(capability, facing) ? new VanillaEntityItemFrameItemHandler(host, facing) : null);
                        }
                    };
                }
            });
            registry.registerEntity(EntityItem.class, (ICapabilityConstructor)new ICapabilityConstructor<IFluidHandler, EntityItem, EntityItem>(){

                public Capability<IFluidHandler> getCapability() {
                    return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(EntityItem hostType, final EntityItem host) {
                    return new ICapabilityProvider(){

                        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && host.func_92059_d().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing);
                        }

                        @Nullable
                        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && host.func_92059_d().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing) ? new VanillaEntityItemFluidHandler(host, facing) : null);
                        }
                    };
                }
            });
            registry.registerEntity(EntityItemFrame.class, (ICapabilityConstructor)new ICapabilityConstructor<IFluidHandler, EntityItemFrame, EntityItemFrame>(){

                public Capability<IFluidHandler> getCapability() {
                    return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(EntityItemFrame hostType, final EntityItemFrame host) {
                    return new ICapabilityProvider(){

                        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && host.func_82335_i().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing);
                        }

                        @Nullable
                        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                            return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && host.func_82335_i().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing) ? new VanillaEntityItemFrameFluidHandler(host, facing) : null);
                        }
                    };
                }
            });
            registry.registerEntity(EntityItem.class, (ICapabilityConstructor)new ICapabilityConstructor<IEnergyStorage, EntityItem, EntityItem>(){

                public Capability<IEnergyStorage> getCapability() {
                    return CapabilityEnergy.ENERGY;
                }

                @Nullable
                public ICapabilityProvider createProvider(EntityItem hostType, final EntityItem host) {
                    return new ICapabilityProvider(){

                        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                            return capability == CapabilityEnergy.ENERGY && host.func_92059_d().hasCapability(capability, facing);
                        }

                        @Nullable
                        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                            return (T)(capability == CapabilityEnergy.ENERGY && host.func_92059_d().hasCapability(capability, facing) ? new VanillaEntityItemEnergyStorage(host, facing) : null);
                        }
                    };
                }
            });
            registry.registerEntity(EntityItemFrame.class, (ICapabilityConstructor)new ICapabilityConstructor<IEnergyStorage, EntityItemFrame, EntityItemFrame>(){

                public Capability<IEnergyStorage> getCapability() {
                    return CapabilityEnergy.ENERGY;
                }

                @Nullable
                public ICapabilityProvider createProvider(EntityItemFrame hostType, final EntityItemFrame host) {
                    return new ICapabilityProvider(){

                        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                            return capability == CapabilityEnergy.ENERGY && host.func_82335_i().hasCapability(capability, facing);
                        }

                        @Nullable
                        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                            return (T)(capability == CapabilityEnergy.ENERGY && host.func_82335_i().hasCapability(capability, facing) ? new VanillaEntityItemFrameEnergyStorage(host, facing) : null);
                        }
                    };
                }
            });
        }
    }
}

