/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.struct;

import hellfirepvp.astralsorcery.common.block.BlockStructural;
import hellfirepvp.astralsorcery.common.item.base.render.ISpecialStackDescriptor;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.UniversalBucket;

public class BlockArray {
    protected static final Random STATIC_RAND = new Random();
    protected Map<BlockPos, TileEntityCallback> tileCallbacks = new HashMap<BlockPos, TileEntityCallback>();
    protected Map<BlockPos, BlockInformation> pattern = new HashMap<BlockPos, BlockInformation>();
    private Vec3i min = new Vec3i(0, 0, 0);
    private Vec3i max = new Vec3i(0, 0, 0);
    private Vec3i size = new Vec3i(0, 0, 0);

    public void addBlock(int x, int y, int z, @Nonnull IBlockState state) {
        this.addBlock(new BlockPos(x, y, z), state);
    }

    public void addBlock(BlockPos offset, @Nonnull IBlockState state) {
        Block b = state.func_177230_c();
        this.pattern.put(offset, new BlockInformation(b, state));
        this.updateSize(offset);
    }

    public void addBlock(int x, int y, int z, @Nonnull IBlockState state, BlockStateCheck match) {
        this.addBlock(new BlockPos(x, y, z), state, match);
    }

    public void addBlock(BlockPos offset, @Nonnull IBlockState state, BlockStateCheck match) {
        Block b = state.func_177230_c();
        this.pattern.put(offset, new BlockInformation(b, state, match));
        this.updateSize(offset);
    }

    public void addAll(BlockArray other) {
        this.addAll(other, null);
    }

    public void addAll(BlockArray other, @Nullable Function<BlockPos, BlockPos> positionTransform) {
        BlockPos to;
        for (Map.Entry<BlockPos, BlockInformation> entry : other.pattern.entrySet()) {
            to = entry.getKey();
            if (positionTransform != null) {
                to = positionTransform.apply(to);
            }
            this.pattern.put(to, entry.getValue());
            this.updateSize(to);
        }
        for (Map.Entry<BlockPos, Object> entry : other.tileCallbacks.entrySet()) {
            to = entry.getKey();
            if (positionTransform != null) {
                to = positionTransform.apply(to);
            }
            this.tileCallbacks.put(to, (TileEntityCallback)entry.getValue());
        }
    }

    public void addTileCallback(BlockPos pos, TileEntityCallback callback) {
        this.tileCallbacks.put(pos, callback);
    }

    public boolean hasBlockAt(BlockPos pos) {
        return this.pattern.containsKey(pos);
    }

    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    public Vec3i getMax() {
        return this.max;
    }

    public Vec3i getMin() {
        return this.min;
    }

    public Vec3i getSize() {
        return this.size;
    }

    private void updateSize(BlockPos addedPos) {
        if (addedPos.func_177958_n() < this.min.func_177958_n()) {
            this.min = new Vec3i(addedPos.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p());
        }
        if (addedPos.func_177958_n() > this.max.func_177958_n()) {
            this.max = new Vec3i(addedPos.func_177958_n(), this.max.func_177956_o(), this.max.func_177952_p());
        }
        if (addedPos.func_177956_o() < this.min.func_177956_o()) {
            this.min = new Vec3i(this.min.func_177958_n(), addedPos.func_177956_o(), this.min.func_177952_p());
        }
        if (addedPos.func_177956_o() > this.max.func_177956_o()) {
            this.max = new Vec3i(this.max.func_177958_n(), addedPos.func_177956_o(), this.max.func_177952_p());
        }
        if (addedPos.func_177952_p() < this.min.func_177952_p()) {
            this.min = new Vec3i(this.min.func_177958_n(), this.min.func_177956_o(), addedPos.func_177952_p());
        }
        if (addedPos.func_177952_p() > this.max.func_177952_p()) {
            this.max = new Vec3i(this.max.func_177958_n(), this.max.func_177956_o(), addedPos.func_177952_p());
        }
        this.size = new Vec3i(this.max.func_177958_n() - this.min.func_177958_n() + 1, this.max.func_177956_o() - this.min.func_177956_o() + 1, this.max.func_177952_p() - this.min.func_177952_p() + 1);
    }

    public Map<BlockPos, BlockInformation> getPattern() {
        return this.pattern;
    }

    public Map<BlockPos, TileEntityCallback> getTileCallbacks() {
        return this.tileCallbacks;
    }

    public void addBlockCube(@Nonnull IBlockState state, int ox, int oy, int oz, int tx, int ty, int tz) {
        this.addBlockCube(state, new BlockStateCheck.Meta(state.func_177230_c(), state.func_177230_c().func_176201_c(state)), ox, oy, oz, tx, ty, tz);
    }

    public void addBlockCube(@Nonnull IBlockState state, BlockStateCheck match, int ox, int oy, int oz, int tx, int ty, int tz) {
        int hz;
        int lz;
        int hy;
        int ly;
        int hx;
        int lx;
        if (ox < tx) {
            lx = ox;
            hx = tx;
        } else {
            lx = tx;
            hx = ox;
        }
        if (oy < ty) {
            ly = oy;
            hy = ty;
        } else {
            ly = ty;
            hy = oy;
        }
        if (oz < tz) {
            lz = oz;
            hz = tz;
        } else {
            lz = tz;
            hz = oz;
        }
        for (int xx = lx; xx <= hx; ++xx) {
            for (int zz = lz; zz <= hz; ++zz) {
                for (int yy = ly; yy <= hy; ++yy) {
                    this.addBlock(new BlockPos(xx, yy, zz), state, match);
                }
            }
        }
    }

    public Map<BlockPos, IBlockState> placeInWorld(World world, BlockPos center) {
        HashMap<BlockPos, IBlockState> result = new HashMap<BlockPos, IBlockState>();
        for (Map.Entry<BlockPos, BlockInformation> entry : this.pattern.entrySet()) {
            TileEntityCallback callback;
            IBlockState state;
            BlockInformation info = entry.getValue();
            BlockPos at = center.func_177971_a((Vec3i)entry.getKey());
            if (!world.func_180501_a(at, state = info.state, 3)) continue;
            result.put(at, state);
            if (MiscUtils.isFluidBlock(state)) {
                world.func_190524_a(at, state.func_177230_c(), at);
            }
            TileEntity placed = world.func_175625_s(at);
            if (!this.tileCallbacks.containsKey(entry.getKey()) || !(callback = this.tileCallbacks.get(entry.getKey())).isApplicable(placed)) continue;
            callback.onPlace((IBlockAccess)world, at, placed);
        }
        return result;
    }

    public List<ItemStack> getAsDescriptiveStacks() {
        LinkedList<ItemStack> out = new LinkedList<ItemStack>();
        for (BlockInformation info : this.pattern.values()) {
            ItemStack s;
            int meta = info.metadata;
            if (info.type instanceof BlockFluidBase) {
                s = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)((BlockFluidBase)info.type).getFluid());
            } else {
                if (info.type instanceof BlockStructural) continue;
                if (info.type instanceof ISpecialStackDescriptor) {
                    s = ((ISpecialStackDescriptor)info.type).getDecriptor(info.state);
                } else {
                    Item i = Item.func_150898_a((Block)info.type);
                    if (i == Items.field_190931_a) continue;
                    s = new ItemStack(i, 1, meta);
                }
            }
            if (s.func_190926_b()) continue;
            boolean found = false;
            for (ItemStack stack : out) {
                if (!stack.func_77973_b().getRegistryName().equals((Object)s.func_77973_b().getRegistryName()) || stack.func_77952_i() != s.func_77952_i()) continue;
                stack.func_190920_e(stack.func_190916_E() + 1);
                found = true;
                break;
            }
            if (found) continue;
            out.add(s);
        }
        return out;
    }

    public static class BlockInformation {
        public final Block type;
        public final IBlockState state;
        public final int metadata;
        public final BlockStateCheck matcher;

        protected BlockInformation(Block type, IBlockState state) {
            this(type, state, new BlockStateCheck.Meta(type, type.func_176201_c(state)));
        }

        protected BlockInformation(Block type, IBlockState state, BlockStateCheck matcher) {
            this.type = type;
            this.state = state;
            this.metadata = type.func_176201_c(state);
            this.matcher = matcher;
        }
    }

    public static interface TileEntityCallback {
        public boolean isApplicable(TileEntity var1);

        public void onPlace(IBlockAccess var1, BlockPos var2, TileEntity var3);
    }
}

