/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.BlockFlareLight;
import hellfirepvp.astralsorcery.common.entities.EntityFlare;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.base.TileSkybound;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.DirectionalLayerBlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileIlluminator
extends TileSkybound {
    private static final Random rand = new Random();
    public static final LightCheck illuminatorCheck = new LightCheck();
    public static final int SEARCH_RADIUS = 64;
    public static final int STEP_WIDTH = 4;
    private LinkedList<BlockPos>[] validPositions = null;
    private boolean recalcRequested = false;
    private int ticksUntilNext = 180;
    private boolean playerPlaced = false;
    private int skyLightIgnoreTimeout = 0;
    private EnumDyeColor chosenColor = EnumDyeColor.YELLOW;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.playerPlaced) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && (this.skyLightIgnoreTimeout > 0 || this.doesSeeSky())) {
            if (this.validPositions == null) {
                this.recalculate();
            }
            if (rand.nextInt(3) == 0 && this.placeFlares()) {
                this.recalcRequested = true;
            }
            --this.skyLightIgnoreTimeout;
            --this.ticksUntilNext;
            if (this.ticksUntilNext <= 0) {
                int n = this.ticksUntilNext = this.skyLightIgnoreTimeout > 0 ? 30 : 180;
                if (this.recalcRequested) {
                    this.recalcRequested = false;
                    this.recalculate();
                }
            }
        }
        if (this.field_145850_b.field_72995_K) {
            this.playEffects();
        }
    }

    public void setPlayerPlaced() {
        this.playerPlaced = true;
        this.markForUpdate();
    }

    public void onWandUsed(EnumDyeColor color) {
        this.skyLightIgnoreTimeout = 12000;
        this.chosenColor = color;
        this.markForUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffects() {
        if (Minecraft.func_71375_t() || rand.nextInt(5) == 0) {
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
            p.motion(rand.nextFloat() * 0.025f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.025f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.025f * (float)(rand.nextBoolean() ? 1 : -1));
            p.scale(0.25f);
            Color col = MiscUtils.flareColorFromDye(EnumDyeColor.YELLOW);
            if (this.chosenColor != null) {
                col = MiscUtils.flareColorFromDye(this.chosenColor);
            }
            switch (rand.nextInt(3)) {
                case 0: {
                    p.setColor(Color.WHITE);
                    break;
                }
                case 1: {
                    p.setColor(col.brighter().brighter());
                    break;
                }
                case 2: {
                    p.setColor(col);
                }
            }
        }
    }

    private boolean placeFlares() {
        boolean needsRecalc = false;
        for (LinkedList<BlockPos> list : this.validPositions) {
            IBlockState lightState;
            if (list.isEmpty()) {
                needsRecalc = true;
                continue;
            }
            int index = rand.nextInt(list.size());
            BlockPos at = list.remove(index);
            if (!needsRecalc && list.isEmpty()) {
                needsRecalc = true;
            }
            if (!this.field_145850_b.func_175667_e(at = at.func_177982_a(rand.nextInt(5) - 2, rand.nextInt(13) - 6, rand.nextInt(5) - 2)) || !illuminatorCheck.isStateValid(this.field_145850_b, at, this.field_145850_b.func_180495_p(at))) continue;
            EnumDyeColor color = EnumDyeColor.YELLOW;
            if (this.chosenColor != null) {
                color = this.chosenColor;
            }
            if (!this.field_145850_b.func_175656_a(at, lightState = BlocksAS.blockVolatileLight.func_176223_P().func_177226_a(BlockFlareLight.COLOR, (Comparable)color)) || rand.nextInt(4) != 0) continue;
            EntityFlare.spawnAmbient(this.field_145850_b, new Vector3(this).add(-1.0f + rand.nextFloat() * 3.0f, 0.6, -1.0f + rand.nextFloat() * 3.0f));
        }
        return needsRecalc;
    }

    private void recalculate() {
        int parts = this.yPartsFromHeight();
        this.validPositions = new LinkedList[parts];
        for (int i = 1; i <= parts; ++i) {
            int yLevel = (int)((float)this.func_174877_v().func_177956_o() * ((float)i / (float)parts));
            LinkedList<BlockPos> calcPositions = new DirectionalLayerBlockDiscoverer(this.field_145850_b, new BlockPos(this.func_174877_v().func_177958_n(), yLevel, this.func_174877_v().func_177952_p()), 64, 4).discoverApplicableBlocks();
            this.validPositions[i - 1] = this.repeatList(calcPositions);
        }
    }

    private int yPartsFromHeight() {
        return Math.max(2, this.func_174877_v().func_177956_o() / 8);
    }

    private LinkedList<BlockPos> repeatList(LinkedList<BlockPos> list) {
        LinkedList<BlockPos> rep = new LinkedList<BlockPos>();
        for (int i = 0; i < 4; ++i) {
            rep.addAll(list);
        }
        return rep;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("playerPlaced", this.playerPlaced);
        compound.func_74768_a("boostTimeout", this.skyLightIgnoreTimeout);
        if (this.chosenColor != null) {
            compound.func_74768_a("wandColor", this.chosenColor.func_176765_a());
        } else {
            compound.func_74768_a("wandColor", EnumDyeColor.YELLOW.func_176765_a());
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.playerPlaced = compound.func_74767_n("playerPlaced");
        this.skyLightIgnoreTimeout = compound.func_74762_e("boostTimeout");
        if (compound.func_74764_b("wandColor")) {
            this.chosenColor = EnumDyeColor.func_176764_b((int)compound.func_74762_e("wandColor"));
        }
        if (this.chosenColor == null) {
            this.chosenColor = EnumDyeColor.YELLOW;
        }
    }

    @Override
    protected void onFirstTick() {
        this.recalculate();
    }

    public static class LightCheck
    implements BlockStateCheck {
        @Override
        public boolean isStateValid(World world, BlockPos pos, IBlockState state) {
            return world.func_175623_d(pos) && !world.func_175678_i(pos) && world.func_175699_k(pos) < 8 && world.func_175642_b(EnumSkyBlock.SKY, pos) < 6;
        }
    }
}

