/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.block.MaterialAirish;
import hellfirepvp.astralsorcery.common.item.ItemColoredLens;
import hellfirepvp.astralsorcery.common.item.ItemConstellationPaper;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.ItemHandTelescope;
import hellfirepvp.astralsorcery.common.item.ItemInfusedGlass;
import hellfirepvp.astralsorcery.common.item.ItemJournal;
import hellfirepvp.astralsorcery.common.item.ItemKnowledgeShare;
import hellfirepvp.astralsorcery.common.item.base.IItemVariants;
import hellfirepvp.astralsorcery.common.item.base.render.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockAltar;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockCustomName;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockRitualPedestal;
import hellfirepvp.astralsorcery.common.item.block.ItemCollectorCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemRockCrystalSimple;
import hellfirepvp.astralsorcery.common.item.crystal.ItemTunedCelestialCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemTunedRockCrystal;
import hellfirepvp.astralsorcery.common.item.knowledge.ItemFragmentCapsule;
import hellfirepvp.astralsorcery.common.item.knowledge.ItemKnowledgeFragment;
import hellfirepvp.astralsorcery.common.item.tool.ItemChargedCrystalAxe;
import hellfirepvp.astralsorcery.common.item.tool.ItemChargedCrystalPickaxe;
import hellfirepvp.astralsorcery.common.item.tool.ItemChargedCrystalShovel;
import hellfirepvp.astralsorcery.common.item.tool.ItemChargedCrystalSword;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalAxe;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalPickaxe;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalShovel;
import hellfirepvp.astralsorcery.common.item.tool.ItemCrystalSword;
import hellfirepvp.astralsorcery.common.item.tool.ItemLinkingTool;
import hellfirepvp.astralsorcery.common.item.tool.ItemSkyResonator;
import hellfirepvp.astralsorcery.common.item.tool.sextant.ItemSextant;
import hellfirepvp.astralsorcery.common.item.tool.wand.ItemWand;
import hellfirepvp.astralsorcery.common.item.useables.ItemPerkSeal;
import hellfirepvp.astralsorcery.common.item.useables.ItemShiftingStar;
import hellfirepvp.astralsorcery.common.item.useables.ItemUsableDust;
import hellfirepvp.astralsorcery.common.item.wand.ItemArchitectWand;
import hellfirepvp.astralsorcery.common.item.wand.ItemExchangeWand;
import hellfirepvp.astralsorcery.common.item.wand.ItemGrappleWand;
import hellfirepvp.astralsorcery.common.item.wand.ItemIlluminationWand;
import hellfirepvp.astralsorcery.common.item.wearable.ItemCape;
import hellfirepvp.astralsorcery.common.item.wearable.ItemEnchantmentAmulet;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.registry.RegistryBlocks;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryItems {
    public static List<ItemDynamicColor> pendingDynamicColorItems = new LinkedList<ItemDynamicColor>();
    public static Item.ToolMaterial crystalToolMaterial;
    public static EnumRarity rarityCelestial;
    public static EnumRarity rarityRelic;
    public static Material materialTransparentReplaceable;
    public static ItemArmor.ArmorMaterial imbuedLeatherMaterial;
    public static CreativeTabs creativeTabAstralSorcery;
    public static CreativeTabs creativeTabAstralSorceryPapers;
    public static CreativeTabs creativeTabAstralSorceryTunedCrystals;

    public static void setupDefaults() {
        creativeTabAstralSorcery = new CreativeTabs("astralsorcery"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ItemsAS.journal);
            }
        };
        creativeTabAstralSorceryPapers = new CreativeTabs("astralsorcery.papers"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ItemsAS.constellationPaper);
            }
        };
        creativeTabAstralSorceryTunedCrystals = new CreativeTabs("astralsorcery.crystals"){

            public ItemStack func_78016_d() {
                return new ItemStack((Item)ItemsAS.tunedRockCrystal);
            }
        };
        crystalToolMaterial = EnumHelper.addToolMaterial((String)"CRYSTAL", (int)3, (int)1000, (float)20.0f, (float)5.5f, (int)40);
        crystalToolMaterial.setRepairItem(ItemStack.field_190927_a);
        rarityCelestial = EnumHelper.addRarity((String)"CELESTIAL", (TextFormatting)TextFormatting.BLUE, (String)"Celestial");
        rarityRelic = EnumHelper.addRarity((String)"AS_RELIC", (TextFormatting)TextFormatting.GOLD, (String)"Relic");
        materialTransparentReplaceable = new MaterialAirish();
        imbuedLeatherMaterial = EnumHelper.addArmorMaterial((String)"AS_IMBUEDLEATHER", (String)"as.imbuedleather", (int)26, (int[])new int[]{0, 0, 7, 0}, (int)30, (SoundEvent)SoundEvents.field_187728_s, (float)2.0f);
        imbuedLeatherMaterial.setRepairItem(ItemCraftingComponent.MetaType.STARDUST.asStack());
    }

    public static void init() {
        RegistryItems.registerItems();
        RegistryItems.registerBlockItems();
        RegistryItems.registerDispenseBehavior();
    }

    private static void registerItems() {
        ItemsAS.craftingComponent = RegistryItems.registerItem(new ItemCraftingComponent());
        ItemsAS.constellationPaper = RegistryItems.registerItem(new ItemConstellationPaper());
        ItemsAS.infusedGlass = RegistryItems.registerItem(new ItemInfusedGlass());
        ItemsAS.rockCrystal = RegistryItems.registerItem(new ItemRockCrystalSimple());
        ItemsAS.tunedRockCrystal = RegistryItems.registerItem(new ItemTunedRockCrystal());
        ItemsAS.celestialCrystal = RegistryItems.registerItem(new ItemCelestialCrystal());
        ItemsAS.tunedCelestialCrystal = RegistryItems.registerItem(new ItemTunedCelestialCrystal());
        ItemsAS.journal = RegistryItems.registerItem(new ItemJournal());
        ItemsAS.handTelescope = RegistryItems.registerItem(new ItemHandTelescope());
        ItemsAS.linkingTool = RegistryItems.registerItem(new ItemLinkingTool());
        ItemsAS.wand = RegistryItems.registerItem(new ItemWand());
        ItemsAS.sextant = RegistryItems.registerItem(new ItemSextant());
        ItemsAS.illuminationWand = RegistryItems.registerItem(new ItemIlluminationWand());
        ItemsAS.coloredLens = RegistryItems.registerItem(new ItemColoredLens());
        ItemsAS.skyResonator = RegistryItems.registerItem(new ItemSkyResonator());
        ItemsAS.shiftingStar = RegistryItems.registerItem(new ItemShiftingStar());
        ItemsAS.architectWand = RegistryItems.registerItem(new ItemArchitectWand());
        ItemsAS.exchangeWand = RegistryItems.registerItem(new ItemExchangeWand());
        ItemsAS.grapplingWand = RegistryItems.registerItem(new ItemGrappleWand());
        ItemsAS.useableDust = RegistryItems.registerItem(new ItemUsableDust());
        ItemsAS.knowledgeShare = RegistryItems.registerItem(new ItemKnowledgeShare());
        ItemsAS.perkSeal = RegistryItems.registerItem(new ItemPerkSeal());
        ItemsAS.knowledgeFragment = RegistryItems.registerItem(new ItemKnowledgeFragment());
        ItemsAS.fragmentCapsule = RegistryItems.registerItem(new ItemFragmentCapsule());
        ItemsAS.crystalPickaxe = RegistryItems.registerItem(new ItemCrystalPickaxe());
        ItemsAS.crystalShovel = RegistryItems.registerItem(new ItemCrystalShovel());
        ItemsAS.crystalAxe = RegistryItems.registerItem(new ItemCrystalAxe());
        ItemsAS.crystalSword = RegistryItems.registerItem(new ItemCrystalSword());
        ItemsAS.chargedCrystalAxe = RegistryItems.registerItem(new ItemChargedCrystalAxe());
        ItemsAS.chargedCrystalSword = RegistryItems.registerItem(new ItemChargedCrystalSword());
        ItemsAS.chargedCrystalPickaxe = RegistryItems.registerItem(new ItemChargedCrystalPickaxe());
        ItemsAS.chargedCrystalShovel = RegistryItems.registerItem(new ItemChargedCrystalShovel());
        ItemsAS.armorImbuedCape = RegistryItems.registerItem(new ItemCape());
        ItemsAS.enchantmentAmulet = RegistryItems.registerItem(new ItemEnchantmentAmulet());
    }

    private static void registerBlockItems() {
        RegistryBlocks.defaultItemBlocksToRegister.forEach(RegistryItems::registerDefaultItemBlock);
        RegistryItems.registerItem(new ItemSlab((Block)BlocksAS.blockMarbleSlab, (BlockSlab)BlocksAS.blockMarbleSlab, (BlockSlab)BlocksAS.blockMarbleDoubleSlab));
        RegistryBlocks.customNameItemBlocksToRegister.forEach(RegistryItems::registerCustomNameItemBlock);
        RegistryItems.registerItem(new ItemBlockRitualPedestal());
        RegistryItems.registerItem(new ItemBlockAltar());
        RegistryItems.registerItem(new ItemCollectorCrystal(BlocksAS.collectorCrystal));
        RegistryItems.registerItem(new ItemCollectorCrystal(BlocksAS.celestialCollectorCrystal));
    }

    private static void registerDispenseBehavior() {
        BlockDispenser.field_149943_a.func_82595_a((Object)ItemsAS.useableDust, (Object)ItemsAS.useableDust);
    }

    private static <T extends Block> void registerCustomNameItemBlock(T block) {
        RegistryItems.registerItem(new ItemBlockCustomName(block), block.getClass().getSimpleName().toLowerCase());
    }

    private static <T extends Block> void registerDefaultItemBlock(T block) {
        RegistryItems.registerDefaultItemBlock(block, block.getClass().getSimpleName().toLowerCase());
    }

    private static <T extends Block> void registerDefaultItemBlock(T block, String name) {
        RegistryItems.registerItem(new ItemBlock(block), name);
    }

    private static <T extends Item> T registerItem(T item, String name) {
        item.func_77655_b(name);
        item.setRegistryName(name);
        RegistryItems.register(item, name);
        return item;
    }

    private static <T extends Item> T registerItem(T item) {
        String simpleName = item.getClass().getSimpleName().toLowerCase();
        if (item instanceof ItemBlock) {
            simpleName = ((ItemBlock)item).func_179223_d().getClass().getSimpleName().toLowerCase();
        }
        return RegistryItems.registerItem(item, simpleName);
    }

    private static <T extends IForgeRegistryEntry<T>> void register(T item, String name) {
        CommonProxy.registryPrimer.register(item);
        if (item instanceof Item) {
            RegistryItems.registerItemInformations((Item)item, name);
            if (item instanceof ItemDynamicColor) {
                pendingDynamicColorItems.add((ItemDynamicColor)item);
            }
        }
    }

    private static <T extends Item> void registerItemInformations(T item, String name) {
        if (item instanceof IItemVariants) {
            for (int i = 0; i < ((IItemVariants)item).getVariants().length; ++i) {
                int m = i;
                if (((IItemVariants)item).getVariantMetadatas() != null) {
                    m = ((IItemVariants)item).getVariantMetadatas()[i];
                }
                String vName = name + "_" + ((IItemVariants)item).getVariants()[i];
                if (((IItemVariants)item).getVariants()[i].equals("*")) {
                    vName = name;
                }
                AstralSorcery.proxy.registerItemRender(item, m, vName, true);
            }
        } else if (!(item instanceof ItemBlockCustomName)) {
            AstralSorcery.proxy.registerFromSubItems(item, name);
        }
    }
}

