/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.useables;

import hellfirepvp.astralsorcery.common.entities.EntityIlluminationSpark;
import hellfirepvp.astralsorcery.common.entities.EntityNocturnalSpark;
import hellfirepvp.astralsorcery.common.item.base.IItemVariants;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemUsableDust
extends Item
implements IItemVariants,
IBehaviorDispenseItem {
    public ItemUsableDust() {
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (DustType type : DustType.values()) {
                items.add((Object)type.asStack());
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        DustType type = DustType.fromMeta(stack.func_77952_i());
        if (stack.func_190926_b() || worldIn.field_72995_K || !(stack.func_77973_b() instanceof ItemUsableDust) || type == null) {
            return EnumActionResult.SUCCESS;
        }
        type.rightClickBlock(player, worldIn, pos, stack, facing);
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        DustType type = DustType.fromMeta(stack.func_77952_i());
        if (stack.func_190926_b() || worldIn.field_72995_K || !(stack.func_77973_b() instanceof ItemUsableDust) || type == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        type.rightClickAir(worldIn, playerIn, stack);
        if (!playerIn.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public String func_77667_c(ItemStack stack) {
        Item i = stack.func_77973_b();
        if (i instanceof ItemUsableDust) {
            DustType type = DustType.fromMeta(stack.func_77952_i());
            return super.func_77667_c(stack) + "." + type.getUnlocalizedName();
        }
        return super.func_77667_c(stack);
    }

    @Override
    public String[] getVariants() {
        String[] sub = new String[DustType.values().length];
        DustType[] values = DustType.values();
        for (int i = 0; i < values.length; ++i) {
            DustType mt = values[i];
            sub[i] = mt.getUnlocalizedName();
        }
        return sub;
    }

    @Override
    public int[] getVariantMetadatas() {
        int[] sub = new int[DustType.values().length];
        DustType[] values = DustType.values();
        for (int i = 0; i < values.length; ++i) {
            DustType mt = values[i];
            sub[i] = mt.getMeta();
        }
        return sub;
    }

    public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
        DustType type = DustType.fromMeta(stack.func_77952_i());
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemUsableDust) || type == null) {
            return stack;
        }
        if (type.dispense(source)) {
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                stack = ItemStack.field_190927_a;
            }
            return stack;
        }
        return stack;
    }

    public static enum DustType {
        ILLUMINATION,
        NOCTURNAL;


        public boolean dispense(IBlockSource source) {
            IBlockState sourceState = source.func_189992_e();
            if (!sourceState.func_177230_c().equals(Blocks.field_150367_z) || !sourceState.func_177228_b().containsKey((Object)BlockDispenser.field_176441_a)) {
                return false;
            }
            IPosition pos = BlockDispenser.func_149939_a((IBlockSource)source);
            EnumFacing rotation = (EnumFacing)sourceState.func_177229_b((IProperty)BlockDispenser.field_176441_a);
            switch (this) {
                case ILLUMINATION: {
                    EntityIlluminationSpark spark = new EntityIlluminationSpark(source.func_82618_k(), pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
                    spark.func_70186_c(rotation.func_82601_c(), (float)rotation.func_96559_d() + 0.1f, rotation.func_82599_e(), 0.7f, 0.9f);
                    source.func_82618_k().func_72838_d((Entity)spark);
                    return true;
                }
                case NOCTURNAL: {
                    EntityNocturnalSpark nocSpark = new EntityNocturnalSpark(source.func_82618_k(), pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
                    nocSpark.func_70186_c(rotation.func_82601_c(), (float)rotation.func_96559_d() + 0.1f, rotation.func_82599_e(), 0.7f, 0.9f);
                    source.func_82618_k().func_72838_d((Entity)nocSpark);
                    return true;
                }
            }
            return false;
        }

        public void rightClickAir(World worldIn, EntityPlayer player, ItemStack dustStack) {
            switch (this) {
                case ILLUMINATION: {
                    worldIn.func_72838_d((Entity)new EntityIlluminationSpark(worldIn, (EntityLivingBase)player));
                    break;
                }
                case NOCTURNAL: {
                    worldIn.func_72838_d((Entity)new EntityNocturnalSpark(worldIn, (EntityLivingBase)player));
                }
            }
        }

        public void rightClickBlock(EntityPlayer playerIn, World worldIn, BlockPos pos, ItemStack dustStack, EnumFacing facing) {
            switch (this) {
                case ILLUMINATION: {
                    IBlockState iblockstate = worldIn.func_180495_p(pos);
                    Block block = iblockstate.func_177230_c();
                    if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
                        pos = pos.func_177972_a(facing);
                    }
                    if (!playerIn.func_175151_a(pos, facing, dustStack) || !worldIn.func_190527_a((Block)BlocksAS.blockVolatileLight, pos, true, facing, null) || !worldIn.func_180501_a(pos, BlocksAS.blockVolatileLight.func_176223_P(), 3)) break;
                    SoundType soundtype = worldIn.func_180495_p(pos).func_177230_c().getSoundType(worldIn.func_180495_p(pos), worldIn, pos, (Entity)playerIn);
                    worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    if (playerIn.func_184812_l_()) break;
                    dustStack.func_190918_g(1);
                    break;
                }
                case NOCTURNAL: {
                    pos = pos.func_177972_a(facing);
                    EntityNocturnalSpark noc = new EntityNocturnalSpark(worldIn, (EntityLivingBase)playerIn);
                    noc.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    noc.setSpawning();
                    worldIn.func_72838_d((Entity)noc);
                    if (playerIn.func_184812_l_()) break;
                    dustStack.func_190918_g(1);
                }
            }
        }

        public ItemStack asStack() {
            return new ItemStack((Item)ItemsAS.useableDust, 1, this.getMeta());
        }

        public String getUnlocalizedName() {
            return this.name().toLowerCase();
        }

        public int getMeta() {
            return this.ordinal();
        }

        public static DustType fromMeta(int meta) {
            int ord = MathHelper.func_76125_a((int)meta, (int)0, (int)(DustType.values().length - 1));
            return DustType.values()[ord];
        }
    }
}

