/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.useables;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.base.render.INBTModel;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShiftingStar
extends Item
implements INBTModel {
    public ItemShiftingStar() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack, ModelResourceLocation suggestedDefaultLocation) {
        IMajorConstellation cst = ItemShiftingStar.getAttunement(stack);
        if (cst != null) {
            return new ModelResourceLocation(new ResourceLocation(suggestedDefaultLocation.func_110624_b(), suggestedDefaultLocation.func_110623_a() + "_" + cst.getSimpleName()), suggestedDefaultLocation.func_177518_c());
        }
        return suggestedDefaultLocation;
    }

    @Override
    public List<ResourceLocation> getAllPossibleLocations(ModelResourceLocation defaultLocation) {
        ArrayList all = Lists.newArrayList();
        all.add(defaultLocation);
        for (IMajorConstellation cst : ConstellationRegistry.getMajorConstellations()) {
            all.add(new ResourceLocation(defaultLocation.func_110624_b(), defaultLocation.func_110623_a() + "_" + cst.getSimpleName()));
        }
        return all;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (IMajorConstellation cst : ConstellationRegistry.getMajorConstellations()) {
                ItemStack star = new ItemStack((Item)this);
                ItemShiftingStar.setAttunement(star, cst);
                items.add((Object)star);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerProgress prog;
        IMajorConstellation cst = ItemShiftingStar.getAttunement(stack);
        if (cst != null && (prog = ResearchManager.clientProgress) != null) {
            if (prog.hasConstellationDiscovered(cst.getUnlocalizedName())) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)cst.getUnlocalizedName(), (Object[])new Object[0]));
            } else {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"progress.missing.knowledge", (Object[])new Object[0]));
            }
        }
    }

    public static ItemStack createStack(@Nullable IMajorConstellation cst) {
        ItemStack stack = new ItemStack((Item)ItemsAS.shiftingStar);
        if (cst != null) {
            ItemShiftingStar.setAttunement(stack, cst);
        }
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        String unloc = super.func_77667_c(stack);
        if (ItemShiftingStar.getAttunement(stack) != null) {
            unloc = unloc + ".enhanced";
        }
        return unloc;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ItemShiftingStar.getAttunement(stack) != null ? RegistryItems.rarityRelic : super.func_77613_e(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (worldIn.field_72995_K || !(entityLiving instanceof EntityPlayerMP)) return ItemStack.field_190927_a;
        EntityPlayer pl = (EntityPlayer)entityLiving;
        IMajorConstellation cst = ItemShiftingStar.getAttunement(stack);
        if (cst != null) {
            PlayerProgress prog = ResearchManager.getProgress(pl, Side.SERVER);
            if (prog == null || !prog.wasOnceAttuned() || !prog.hasConstellationDiscovered(cst.getUnlocalizedName())) {
                return stack;
            }
            double exp = prog.getPerkExp();
            if (!ResearchManager.setAttunedConstellation(pl, cst)) return stack;
            ResearchManager.setExp(pl, (int)Math.floor(exp));
            pl.func_145747_a(new TextComponentTranslation("progress.switch.attunement", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
            SoundHelper.playSoundAround(SoundEvents.field_187561_bM, worldIn, (Vec3i)entityLiving.func_180425_c(), 1.0f, 1.0f);
            return ItemStack.field_190927_a;
        } else {
            if (!ResearchManager.setAttunedConstellation(pl, null)) return stack;
            pl.func_145747_a(new TextComponentTranslation("progress.remove.attunement", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
            SoundHelper.playSoundAround(SoundEvents.field_187561_bM, worldIn, (Vec3i)entityLiving.func_180425_c(), 1.0f, 1.0f);
        }
        return ItemStack.field_190927_a;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player.func_130014_f_().field_72995_K) {
            this.playEffects(player, ItemShiftingStar.getAttunement(stack), this.func_77626_a(stack) - count, this.func_77626_a(stack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffects(EntityLivingBase pl, @Nullable IMajorConstellation attunement, int tick, int total) {
        if (attunement != null) {
            float percCycle = (float)((double)((float)(tick % total) / (float)total * 2.0f) * Math.PI);
            int parts = 5;
            for (int i = 0; i < parts; ++i) {
                float angleSwirl = 75.0f;
                Vector3 center = Vector3.atEntityCorner((Entity)pl).setY(pl.field_70163_u);
                Vector3 v = new Vector3(1, 0, 0);
                float originalAngle = (float)i / (float)parts * 360.0f;
                double angle = originalAngle + MathHelper.func_76126_a((float)percCycle) * angleSwirl;
                v.rotate(-Math.toRadians(angle), Vector3.RotAxis.Y_AXIS).normalize().multiply(4);
                Vector3 pos = center.clone().add(v);
                Vector3 mot = center.clone().subtract(pos).normalize().multiply(0.1);
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(pos);
                particle.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).scale(field_77697_d.nextFloat() * 0.4f + 0.27f);
                particle.setMaxAge(50);
                particle.scale(0.2f + field_77697_d.nextFloat());
                if (field_77697_d.nextInt(4) == 0) {
                    particle.setColor(Color.WHITE);
                } else if (field_77697_d.nextInt(3) == 0) {
                    particle.setColor(attunement.getConstellationColor().brighter());
                } else {
                    particle.setColor(attunement.getConstellationColor());
                }
                particle.motion(mot.getX(), mot.getY(), mot.getZ());
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(pl.field_70165_t, pl.field_70163_u + (double)(pl.func_70047_e() / 2.0f), pl.field_70161_v);
                particle.motion(-0.1 + (double)field_77697_d.nextFloat() * 0.2, 0.01, -0.1 + (double)field_77697_d.nextFloat() * 0.2);
                if (field_77697_d.nextInt(3) == 0) {
                    particle.setColor(Color.WHITE);
                }
                particle.scale(0.2f + field_77697_d.nextFloat());
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return ItemShiftingStar.getAttunement(stack) == null ? 60 : 100;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public static void setAttunement(ItemStack stack, IMajorConstellation cst) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemShiftingStar)) {
            return;
        }
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        cmp.func_74778_a("starAttunement", cst.getUnlocalizedName());
    }

    @Nullable
    public static IMajorConstellation getAttunement(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemShiftingStar)) {
            return null;
        }
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        if (!cmp.func_74764_b("starAttunement")) {
            return null;
        }
        return ConstellationRegistry.getMajorConstellationByName(cmp.func_74779_i("starAttunement"));
    }
}

