/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.common.base.FluidRarityRegistry;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.base.ISpecialInteractItem;
import hellfirepvp.astralsorcery.common.item.base.render.INBTModel;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktPlayLiquidSpring;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.IStructureAreaOfInfluence;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SkyCollectionHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSkyResonator
extends Item
implements INBTModel,
ISpecialInteractItem {
    private static Random rand = new Random();

    public ItemSkyResonator() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack enhanced = new ItemStack((Item)this);
            ItemSkyResonator.setEnhanced(enhanced);
            for (ResonatorUpgrade upgrade : ResonatorUpgrade.values()) {
                if (!upgrade.obtainable()) continue;
                ItemSkyResonator.setUpgradeUnlocked(enhanced, upgrade);
            }
            items.add((Object)enhanced);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ItemSkyResonator.isEnhanced(stack)) {
            return;
        }
        ResonatorUpgrade current = ItemSkyResonator.getCurrentUpgrade(null, stack);
        for (ResonatorUpgrade upgrade : ItemSkyResonator.getUpgrades(stack)) {
            tooltip.add((upgrade == current ? TextFormatting.AQUA : TextFormatting.BLUE) + I18n.func_135052_a((String)upgrade.getUnlocalizedUpgradeName(), (Object[])new Object[0]));
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (!ItemSkyResonator.isEnhanced(stack)) {
            return super.func_77667_c(stack);
        }
        return ItemSkyResonator.getCurrentUpgrade(null, stack).getUnlocalizedName();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (!worldIn.field_72995_K && player.func_70093_af() && ItemSkyResonator.cycleUpgrade(player, player.func_184586_b(hand))) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    public boolean needsSpecialHandling(World world, BlockPos at, EntityPlayer player, ItemStack stack) {
        ResonatorUpgrade upgr = ItemSkyResonator.getCurrentUpgrade(player, stack);
        return upgr == ResonatorUpgrade.AREA_SIZE && MiscUtils.getTileAt((IBlockAccess)world, at, IStructureAreaOfInfluence.class, false) != null;
    }

    @Override
    public boolean onRightClick(World world, BlockPos pos, EntityPlayer player, EnumFacing side, EnumHand hand, ItemStack stack) {
        IStructureAreaOfInfluence aoe;
        ResonatorUpgrade upgr = ItemSkyResonator.getCurrentUpgrade(player, stack);
        if (upgr == ResonatorUpgrade.AREA_SIZE && world.field_72995_K && (aoe = MiscUtils.getTileAt((IBlockAccess)world, pos, IStructureAreaOfInfluence.class, false)) != null) {
            this.playAoEDisplayEffect(aoe);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void playAoEDisplayEffect(IStructureAreaOfInfluence aoe) {
        EffectHandler.getInstance().requestSizePreviewFor(aoe);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!isSelected) {
            boolean bl = isSelected = entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184592_cb() == stack;
        }
        if (!worldIn.field_72995_K && isSelected && entityIn instanceof EntityPlayerMP && ItemSkyResonator.getCurrentUpgrade((EntityPlayer)((EntityPlayerMP)entityIn), stack) == ResonatorUpgrade.FLUID_FIELDS && ItemSkyResonator.getCurrentUpgrade((EntityPlayer)entityIn, stack).obtainable()) {
            double dstr = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(worldIn);
            if (dstr <= 1.0E-4) {
                return;
            }
            if ((double)rand.nextFloat() < dstr && rand.nextInt(15) == 0) {
                FluidStack display;
                int oX = rand.nextInt(30) * (rand.nextBoolean() ? 1 : -1);
                int oZ = rand.nextInt(30) * (rand.nextBoolean() ? 1 : -1);
                BlockPos pos = new BlockPos((Vec3i)entityIn.func_180425_c()).func_177982_a(oX, 0, oZ);
                if ((pos = worldIn.func_175672_r(pos)).func_185332_f(MathHelper.func_76128_c((double)entityIn.field_70165_t), MathHelper.func_76128_c((double)entityIn.field_70163_u), MathHelper.func_76128_c((double)entityIn.field_70161_v)) > 75.0) {
                    return;
                }
                FluidRarityRegistry.ChunkFluidEntry at = FluidRarityRegistry.getChunkEntry(worldIn.func_175726_f(pos));
                FluidStack fluidStack = display = at == null ? new FluidStack(FluidRegistry.WATER, 1) : at.tryDrain(1, false);
                if (display == null || display.getFluid() == null) {
                    display = new FluidStack(FluidRegistry.WATER, 1);
                }
                PktPlayLiquidSpring pkt = new PktPlayLiquidSpring(display, new Vector3(pos).add(rand.nextFloat(), 0.0, rand.nextFloat()));
                PacketChannel.CHANNEL.sendToAllAround((IMessage)pkt, PacketChannel.pointFromPos(worldIn, (Vec3i)entityIn.func_180425_c(), 32.0));
            }
        }
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack, ModelResourceLocation defaultModelPath) {
        if (!ItemSkyResonator.isEnhanced(stack)) {
            return defaultModelPath;
        }
        String path = defaultModelPath.func_110623_a() + "_upgraded";
        ResonatorUpgrade upgrade = ItemSkyResonator.getCurrentUpgrade(this.getCurrentClientPlayer(), stack);
        path = path + "_" + upgrade.appendixUpgrade;
        return new ModelResourceLocation(new ResourceLocation(defaultModelPath.func_110624_b(), path), defaultModelPath.func_177518_c());
    }

    @Override
    public List<ResourceLocation> getAllPossibleLocations(ModelResourceLocation defaultLocation) {
        LinkedList<ResourceLocation> out = new LinkedList<ResourceLocation>();
        out.add((ResourceLocation)defaultLocation);
        for (ResonatorUpgrade upgrade : ResonatorUpgrade.values()) {
            if (!upgrade.obtainable()) continue;
            out.add(new ResourceLocation(defaultLocation.func_110624_b(), defaultLocation.func_110623_a() + "_upgraded_" + upgrade.appendixUpgrade));
        }
        return out;
    }

    public static boolean isEnhanced(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSkyResonator)) {
            return false;
        }
        return NBTHelper.getPersistentData(stack).func_74767_n("enhanced");
    }

    public static ItemStack setEnhanced(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSkyResonator)) {
            return stack;
        }
        NBTHelper.getPersistentData(stack).func_74757_a("enhanced", true);
        ItemSkyResonator.setUpgradeUnlocked(stack, ResonatorUpgrade.STARLIGHT);
        return stack;
    }

    public static boolean cycleUpgrade(@Nonnull EntityPlayer player, ItemStack stack) {
        if (!ItemSkyResonator.isEnhanced(stack)) {
            return false;
        }
        ResonatorUpgrade current = ItemSkyResonator.getCurrentUpgrade(player, stack);
        ResonatorUpgrade next = ItemSkyResonator.getNextSelectableUpgrade(player, stack);
        return next != null && next != current && ItemSkyResonator.setCurrentUpgrade(player, stack, next);
    }

    @Nullable
    public static ResonatorUpgrade getNextSelectableUpgrade(@Nonnull EntityPlayer viewing, ItemStack stack) {
        int currentOrd;
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSkyResonator)) {
            return null;
        }
        if (!ItemSkyResonator.isEnhanced(stack)) {
            return null;
        }
        ResonatorUpgrade current = ItemSkyResonator.getCurrentUpgrade(viewing, stack);
        int test = currentOrd = current.ordinal();
        do {
            ++test;
            ResonatorUpgrade testUpgrade = ResonatorUpgrade.values()[test %= ResonatorUpgrade.values().length];
            if (!testUpgrade.obtainable() || !testUpgrade.canSwitchTo(viewing, stack) || testUpgrade == current) continue;
            return testUpgrade;
        } while (test != currentOrd);
        return null;
    }

    public static boolean setCurrentUpgrade(EntityPlayer setting, ItemStack stack, ResonatorUpgrade upgrade) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSkyResonator)) {
            return false;
        }
        if (upgrade.obtainable() && upgrade.canSwitchTo(setting, stack)) {
            NBTHelper.getPersistentData(stack).func_74768_a("selected_upgrade", upgrade.ordinal());
            return true;
        }
        return false;
    }

    public static ItemStack setCurrentUpgradeUnsafe(ItemStack stack, ResonatorUpgrade upgrade) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSkyResonator) || !upgrade.obtainable()) {
            return stack;
        }
        NBTHelper.getPersistentData(stack).func_74768_a("selected_upgrade", upgrade.ordinal());
        return stack;
    }

    @Nonnull
    public static ResonatorUpgrade getCurrentUpgrade(@Nullable EntityPlayer viewing, ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSkyResonator)) {
            return ResonatorUpgrade.STARLIGHT;
        }
        if (!ItemSkyResonator.isEnhanced(stack)) {
            return ResonatorUpgrade.STARLIGHT;
        }
        NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
        int current = cmp.func_74762_e("selected_upgrade");
        ResonatorUpgrade upgrade = ResonatorUpgrade.values()[MathHelper.func_76125_a((int)current, (int)0, (int)(ResonatorUpgrade.values().length - 1))];
        if (!upgrade.obtainable()) {
            return ResonatorUpgrade.STARLIGHT;
        }
        if (viewing != null && !upgrade.canSwitchTo(viewing, stack)) {
            return ResonatorUpgrade.STARLIGHT;
        }
        return upgrade;
    }

    public static ItemStack setUpgradeUnlocked(ItemStack stack, ResonatorUpgrade upgrade) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSkyResonator)) {
            return stack;
        }
        if (!ItemSkyResonator.isEnhanced(stack)) {
            return stack;
        }
        if (upgrade.obtainable()) {
            upgrade.applyUpgrade(stack);
        }
        return stack;
    }

    public static boolean hasUpgrade(ItemStack stack, ResonatorUpgrade upgrade) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSkyResonator)) {
            return false;
        }
        if (!ItemSkyResonator.isEnhanced(stack)) {
            return false;
        }
        if (!upgrade.obtainable()) {
            return false;
        }
        return upgrade.hasUpgrade(stack);
    }

    public static List<ResonatorUpgrade> getUpgrades(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSkyResonator)) {
            return Lists.newArrayList();
        }
        if (!ItemSkyResonator.isEnhanced(stack)) {
            return Lists.newArrayList((Object[])new ResonatorUpgrade[]{ResonatorUpgrade.STARLIGHT});
        }
        LinkedList upgrades = Lists.newLinkedList();
        for (ResonatorUpgrade ru : ResonatorUpgrade.values()) {
            if (!ru.hasUpgrade(stack) || !ru.obtainable()) continue;
            upgrades.add(ru);
        }
        return upgrades;
    }

    public static interface ResonatorUpgradeCheck {
        public boolean hasAccessToUpgrade(@Nonnull EntityPlayer var1, ItemStack var2);
    }

    public static enum ResonatorUpgrade {
        STARLIGHT("starlight", (p, s) -> true),
        FLUID_FIELDS("liquid", (p, s) -> ResearchManager.getProgressTestAccess(p).getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)),
        AREA_SIZE("structure", (p, s) -> ResearchManager.getProgressTestAccess(p).getTierReached().isThisLaterOrEqual(ProgressionTier.ATTUNEMENT));

        private final ResonatorUpgradeCheck check;
        private final String appendixUpgrade;

        private ResonatorUpgrade(String appendixUpgrade, ResonatorUpgradeCheck check) {
            this.check = check;
            this.appendixUpgrade = appendixUpgrade;
        }

        public String getUnlocalizedName() {
            return "item.itemskyresonator." + this.appendixUpgrade;
        }

        public String getUnlocalizedUpgradeName() {
            return "item.itemskyresonator.upgrade." + this.appendixUpgrade + ".name";
        }

        public boolean obtainable() {
            return true;
        }

        public boolean hasUpgrade(ItemStack stack) {
            int id = this.ordinal();
            NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
            if (cmp.func_150297_b("upgrades", 9)) {
                NBTTagList list = cmp.func_150295_c("upgrades", 3);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    if (list.func_186858_c(i) != id) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean canSwitchTo(@Nonnull EntityPlayer player, ItemStack stack) {
            return this.hasUpgrade(stack) && this.check.hasAccessToUpgrade(player, stack);
        }

        public void applyUpgrade(ItemStack stack) {
            if (this.hasUpgrade(stack)) {
                return;
            }
            NBTTagCompound cmp = NBTHelper.getPersistentData(stack);
            if (!cmp.func_150297_b("upgrades", 9)) {
                cmp.func_74782_a("upgrades", (NBTBase)new NBTTagList());
            }
            NBTTagList list = cmp.func_150295_c("upgrades", 3);
            list.func_74742_a((NBTBase)new NBTTagInt(this.ordinal()));
        }

        @SideOnly(value=Side.CLIENT)
        public void playResonatorEffects() {
            switch (this) {
                case STARLIGHT: {
                    this.playStarlightFieldEffect();
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void playStarlightFieldEffect() {
            if (!ConstellationSkyHandler.getInstance().getSeedIfPresent((World)Minecraft.func_71410_x().field_71441_e).isPresent()) {
                return;
            }
            float nightPerc = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution((World)Minecraft.func_71410_x().field_71441_e);
            if ((double)nightPerc >= 0.05) {
                Color c = new Color(0, 6, 58);
                BlockPos center = Minecraft.func_71410_x().field_71439_g.func_180425_c();
                int offsetX = center.func_177958_n();
                int offsetZ = center.func_177952_p();
                BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185342_g((Vec3i)center);
                for (int xx = -30; xx <= 30; ++xx) {
                    for (int zz = -30; zz <= 30; ++zz) {
                        BlockPos top = Minecraft.func_71410_x().field_71441_e.func_175672_r((BlockPos)pos.func_181079_c(offsetX + xx, 0, offsetZ + zz));
                        Float opF = SkyCollectionHelper.getSkyNoiseDistributionClient((World)Minecraft.func_71410_x().field_71441_e, top).get();
                        float fPerc = (float)Math.pow((opF.floatValue() - 0.4f) * 1.65f, 2.0);
                        if (!(opF.floatValue() >= 0.4f) || !(rand.nextFloat() <= fPerc) || !(rand.nextFloat() <= fPerc) || rand.nextInt(6) != 0) continue;
                        EffectHelper.genericFlareParticle((float)top.func_177958_n() + rand.nextFloat(), (double)top.func_177956_o() + 0.15, (float)top.func_177952_p() + rand.nextFloat()).scale(4.0f).setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.PYRAMID).gravity(0.004).setAlphaMultiplier(nightPerc * fPerc);
                        if (!(opF.floatValue() >= 0.8f) || rand.nextInt(3) != 0) continue;
                        EffectHelper.genericFlareParticle((float)top.func_177958_n() + rand.nextFloat(), (double)top.func_177956_o() + 0.15, (float)top.func_177952_p() + rand.nextFloat()).scale(0.3f).setColor(Color.WHITE).gravity(0.01).setAlphaMultiplier(nightPerc);
                    }
                }
                pos.func_185344_t();
            }
        }
    }
}

