/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.entities.EntityItemHighlighted;
import hellfirepvp.astralsorcery.common.item.ItemJournal;
import hellfirepvp.astralsorcery.common.item.base.ItemHighlighted;
import hellfirepvp.astralsorcery.common.item.base.render.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import hellfirepvp.astralsorcery.common.util.WRItemObject;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemConstellationPaper
extends Item
implements ItemHighlighted,
ItemDynamicColor {
    public ItemConstellationPaper() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(RegistryItems.creativeTabAstralSorceryPapers);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1));
            for (IConstellation c : ConstellationRegistry.getAllConstellations()) {
                ItemStack cPaper = new ItemStack((Item)this, 1);
                ItemConstellationPaper.setConstellation(cPaper, c);
                items.add((Object)cPaper);
            }
        }
    }

    @Override
    public int getColorForItemStack(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return -1;
        }
        IConstellation c = ItemConstellationPaper.getConstellation(stack);
        if (c != null && ResearchManager.clientProgress.hasConstellationDiscovered(c.getUnlocalizedName())) {
            return 0xFF000000 | c.getConstellationColor().getRGB();
        }
        return -13421773;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemstack) {
        EntityItemHighlighted ei = new EntityItemHighlighted(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemstack);
        ei.func_174869_p();
        ei.field_70159_w = entity.field_70159_w;
        ei.field_70181_x = entity.field_70181_x;
        ei.field_70179_y = entity.field_70179_y;
        if (entity instanceof EntityItem) {
            ei.func_145799_b(((EntityItem)entity).func_145800_j());
            ei.func_145797_a(((EntityItem)entity).func_145798_i());
        }
        return ei;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IConstellation c = ItemConstellationPaper.getConstellation(stack);
        if (c != null) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)c.getUnlocalizedName(), (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"constellation.noInformation", (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (itemStackIn.func_190926_b()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        if (worldIn.field_72995_K && ItemConstellationPaper.getConstellation(itemStackIn) != null) {
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
            AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.CONSTELLATION_PAPER, playerIn, worldIn, ConstellationRegistry.getConstellationId(ItemConstellationPaper.getConstellation(itemStackIn)), 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IConstellation c;
        PlayerProgress progress;
        if (worldIn.field_72995_K || entityIn == null || !(entityIn instanceof EntityPlayer)) {
            return;
        }
        IConstellation cst = ItemConstellationPaper.getConstellation(stack);
        if (cst == null && (progress = ResearchManager.getProgress((EntityPlayer)entityIn, Side.SERVER)) != null) {
            ArrayList<IConstellation> constellations = new ArrayList<IConstellation>();
            for (IConstellation c2 : ConstellationRegistry.getAllConstellations()) {
                if (!c2.canDiscover(progress)) continue;
                constellations.add(c2);
            }
            for (String strConstellation : progress.getKnownConstellations()) {
                c = ConstellationRegistry.getConstellationByName(strConstellation);
                if (c == null) continue;
                constellations.remove(c);
            }
            for (String strConstellation : progress.getSeenConstellations()) {
                c = ConstellationRegistry.getConstellationByName(strConstellation);
                if (c == null) continue;
                constellations.remove(c);
            }
            if (!constellations.isEmpty()) {
                List<WRItemObject<IConstellation>> wrp = this.buildWeightedRandomList(constellations);
                WRItemObject result = (WRItemObject)WeightedRandom.func_76271_a((Random)worldIn.field_73012_v, wrp);
                ItemConstellationPaper.setConstellation(stack, (IConstellation)result.getValue());
            }
        }
        if ((cst = ItemConstellationPaper.getConstellation(stack)) != null && (progress = ResearchManager.getProgress((EntityPlayer)entityIn, Side.SERVER)) != null) {
            boolean has = false;
            for (String strConstellation : progress.getSeenConstellations()) {
                c = ConstellationRegistry.getConstellationByName(strConstellation);
                if (c == null || !c.equals(cst)) continue;
                has = true;
                break;
            }
            if (!has && ResearchManager.memorizeConstellation(cst, (EntityPlayer)entityIn)) {
                entityIn.func_145747_a(new TextComponentTranslation("progress.seen.constellation.chat", new Object[]{new TextComponentTranslation(cst.getUnlocalizedName(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY))}).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
                if (ResearchManager.clientProgress.getSeenConstellations().size() == 1) {
                    entityIn.func_145747_a(new TextComponentTranslation("progress.seen.constellation.first.chat", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)));
                }
            }
        }
    }

    private void removeInventoryConstellations(InventoryPlayer inventory, List<IConstellation> constellations) {
        if (inventory == null) {
            return;
        }
        for (ItemStack stack : inventory.field_70462_a) {
            IConstellation c;
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemConstellationPaper && (c = ItemConstellationPaper.getConstellation(stack)) != null) {
                constellations.remove(c);
            }
            if (!(stack.func_77973_b() instanceof ItemJournal)) continue;
            for (IConstellation c2 : ItemJournal.getStoredConstellations(stack)) {
                if (c2 == null) continue;
                constellations.remove(c2);
            }
        }
    }

    private List<WRItemObject<IConstellation>> buildWeightedRandomList(List<IConstellation> constellations) {
        ArrayList<WRItemObject<IConstellation>> wrc = new ArrayList<WRItemObject<IConstellation>>();
        for (IConstellation c : constellations) {
            WRItemObject<IConstellation> i = new WRItemObject<IConstellation>(1, c);
            wrc.add(i);
        }
        return wrc;
    }

    @Override
    public Color getHightlightColor(ItemStack stack) {
        IConstellation c = ItemConstellationPaper.getConstellation(stack);
        if (c != null) {
            if (ResearchManager.clientProgress.hasConstellationDiscovered(c.getUnlocalizedName())) {
                return c.getConstellationColor();
            }
            return c.getTierRenderColor();
        }
        return Color.GRAY;
    }

    public static IConstellation getConstellation(ItemStack stack) {
        Item i = stack.func_77973_b();
        if (!(i instanceof ItemConstellationPaper)) {
            return null;
        }
        return IConstellation.readFromNBT(NBTHelper.getPersistentData(stack));
    }

    public static void setConstellation(ItemStack stack, IConstellation constellation) {
        Item i = stack.func_77973_b();
        if (!(i instanceof ItemConstellationPaper)) {
            return;
        }
        NBTTagCompound tag = NBTHelper.getPersistentData(stack);
        constellation.writeToNBT(tag);
    }
}

