/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet;

import baubles.api.BaubleType;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.enchantment.EnchantmentPlayerWornTick;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletHolderCapability;
import hellfirepvp.astralsorcery.common.enchantment.amulet.EnchantmentUpgradeHelper;
import hellfirepvp.astralsorcery.common.event.DynamicEnchantmentEvent;
import hellfirepvp.astralsorcery.common.item.wearable.ItemEnchantmentAmulet;
import hellfirepvp.astralsorcery.common.registry.RegistryEnchantments;
import hellfirepvp.astralsorcery.common.util.BaublesHelper;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.EnumSet;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerAmuletHandler
implements ITickHandler {
    public static final PlayerAmuletHandler INSTANCE = new PlayerAmuletHandler();

    private PlayerAmuletHandler() {
    }

    @SubscribeEvent
    public void attachAmuletItemCapability(AttachCapabilitiesEvent<ItemStack> itemCapEvent) {
        if (!EnchantmentUpgradeHelper.isItemBlacklisted((ItemStack)itemCapEvent.getObject())) {
            itemCapEvent.addCapability(AmuletHolderCapability.CAP_AMULETHOLDER_NAME, (ICapabilityProvider)new AmuletHolderCapability.Provider());
        }
    }

    @SubscribeEvent
    public void onAmuletEnchantApply(DynamicEnchantmentEvent.Add event) {
        if (EnchantmentUpgradeHelper.isItemBlacklisted(event.getEnchantedItemStack())) {
            return;
        }
        Tuple<ItemStack, EntityPlayer> linkedAmulet = EnchantmentUpgradeHelper.getWornAmulet(event.getEnchantedItemStack());
        if (linkedAmulet == null || ((ItemStack)linkedAmulet.key).func_190926_b() || linkedAmulet.value == null) {
            return;
        }
        event.getEnchantmentsToApply().addAll(ItemEnchantmentAmulet.getAmuletEnchantments((ItemStack)linkedAmulet.key));
        event.setResolvedPlayer((EntityPlayer)linkedAmulet.value);
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        EntityPlayer player = (EntityPlayer)context[0];
        this.clearAmuletTags(player);
        boolean client = player.func_130014_f_().field_72995_K;
        for (EnchantmentPlayerWornTick e : RegistryEnchantments.wearableTickEnchantments) {
            int max = EnchantmentHelper.func_185284_a((Enchantment)e, (EntityLivingBase)player);
            if (max <= 0) continue;
            e.onWornTick(client, player, max);
        }
    }

    public void clearAmuletTags(EntityPlayer player) {
        boolean hasAmulet = false;
        for (ItemStack bauble : BaublesHelper.getWornBaublesForType(player, BaubleType.AMULET)) {
            if (bauble.func_190926_b() || !(bauble.func_77973_b() instanceof ItemEnchantmentAmulet)) continue;
            hasAmulet = true;
        }
        EnchantmentUpgradeHelper.removeAmuletTagsAndCleanup(player, hasAmulet);
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "PlayerAmuletHandler";
    }
}

