/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkLevelManager;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncKnowledge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class PlayerProgress {
    private List<String> knownConstellations = new ArrayList<String>();
    private List<String> seenConstellations = new ArrayList<String>();
    private IMajorConstellation attunedConstellation = null;
    private boolean wasOnceAttuned = false;
    private List<ResearchProgression> researchProgression = new LinkedList<ResearchProgression>();
    private List<SextantFinder.TargetObject> usedTargets = new LinkedList<SextantFinder.TargetObject>();
    private ProgressionTier tierReached = ProgressionTier.DISCOVERY;
    private List<String> freePointTokens = Lists.newArrayList();
    private Map<AbstractPerk, NBTTagCompound> unlockedPerks = new HashMap<AbstractPerk, NBTTagCompound>();
    private List<AbstractPerk> sealedPerks = new ArrayList<AbstractPerk>();
    private double perkExp = 0.0;

    public void load(NBTTagCompound compound) {
        int perkTreeLevel;
        int i;
        NBTTagList list;
        this.knownConstellations.clear();
        this.seenConstellations.clear();
        this.researchProgression.clear();
        this.usedTargets.clear();
        this.attunedConstellation = null;
        this.tierReached = ProgressionTier.DISCOVERY;
        this.wasOnceAttuned = false;
        this.unlockedPerks.clear();
        this.sealedPerks.clear();
        this.freePointTokens.clear();
        this.perkExp = 0.0;
        if (compound.func_74764_b("seenConstellations")) {
            list = compound.func_150295_c("seenConstellations", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.seenConstellations.add(list.func_150307_f(i));
            }
        }
        if (compound.func_74764_b("constellations")) {
            list = compound.func_150295_c("constellations", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                String s = list.func_150307_f(i);
                this.knownConstellations.add(s);
                if (this.seenConstellations.contains(s)) continue;
                this.seenConstellations.add(s);
            }
        }
        if (compound.func_74764_b("attuned")) {
            String cst = compound.func_74779_i("attuned");
            IConstellation c = ConstellationRegistry.getConstellationByName(cst);
            if (c == null || !(c instanceof IMajorConstellation)) {
                AstralSorcery.log.warn("Failed to load attuned Constellation: " + cst + " - constellation doesn't exist or isn't major.");
            } else {
                this.attunedConstellation = (IMajorConstellation)c;
            }
        }
        if ((perkTreeLevel = compound.func_74762_e("perkTreeVersion")) < 1) {
            AbstractPerk root;
            AstralSorcery.log.info("Clearing perk-tree because the player's skill-tree version was outdated!");
            if (this.attunedConstellation != null && (root = PerkTree.PERK_TREE.getRootPerk(this.attunedConstellation)) != null) {
                NBTTagCompound data = new NBTTagCompound();
                root.onUnlockPerkServer(null, this, data);
                this.unlockedPerks.put(root, data);
            }
        } else {
            String perkRegName;
            NBTTagCompound tag;
            if (compound.func_74764_b("perks")) {
                NBTTagList list2 = compound.func_150295_c("perks", 10);
                for (int i2 = 0; i2 < list2.func_74745_c(); ++i2) {
                    tag = list2.func_150305_b(i2);
                    perkRegName = tag.func_74779_i("perkName");
                    NBTTagCompound data = tag.func_74775_l("perkData");
                    AbstractPerk perk = PerkTree.PERK_TREE.getPerk(new ResourceLocation(perkRegName));
                    if (perk == null) continue;
                    this.unlockedPerks.put(perk, data);
                }
            }
            if (compound.func_74764_b("sealedPerks")) {
                NBTTagList list3 = compound.func_150295_c("sealedPerks", 10);
                for (int i3 = 0; i3 < list3.func_74745_c(); ++i3) {
                    tag = list3.func_150305_b(i3);
                    perkRegName = tag.func_74779_i("perkName");
                    AbstractPerk perk = PerkTree.PERK_TREE.getPerk(new ResourceLocation(perkRegName));
                    if (perk == null) continue;
                    this.sealedPerks.add(perk);
                }
            }
        }
        if (compound.func_74764_b("tierReached")) {
            int tierOrdinal = compound.func_74762_e("tierReached");
            this.tierReached = ProgressionTier.values()[MathHelper.func_76125_a((int)tierOrdinal, (int)0, (int)(ProgressionTier.values().length - 1))];
        }
        if (compound.func_74764_b("research")) {
            int[] research;
            for (int resOrdinal : research = compound.func_74759_k("research")) {
                ResearchProgression prog = ResearchProgression.getById(resOrdinal);
                if (prog == null) continue;
                this.researchProgression.add(prog);
            }
        }
        if (compound.func_74764_b("sextanttargets")) {
            NBTTagList list4 = compound.func_150295_c("sextanttargets", 8);
            for (int i4 = 0; i4 < list4.func_74745_c(); ++i4) {
                String strTarget = list4.func_150307_f(i4);
                SextantFinder.TargetObject to = SextantFinder.getByName(strTarget);
                if (to == null || this.usedTargets.contains(to)) continue;
                this.usedTargets.add(to);
            }
        }
        if (compound.func_74764_b("pointTokens")) {
            NBTTagList list5 = compound.func_150295_c("pointTokens", 8);
            for (int i5 = 0; i5 < list5.func_74745_c(); ++i5) {
                this.freePointTokens.add(list5.func_150307_f(i5));
            }
        }
        this.wasOnceAttuned = compound.func_74767_n("wasAttuned");
        if (compound.func_74764_b("perkExp")) {
            this.perkExp = compound.func_74769_h("perkExp");
        }
    }

    public void store(NBTTagCompound cmp) {
        NBTTagCompound tag;
        NBTTagList list = new NBTTagList();
        for (String string : this.knownConstellations) {
            list.func_74742_a((NBTBase)new NBTTagString(string));
        }
        NBTTagList l = new NBTTagList();
        for (String string : this.seenConstellations) {
            l.func_74742_a((NBTBase)new NBTTagString(string));
        }
        cmp.func_74782_a("constellations", (NBTBase)list);
        cmp.func_74782_a("seenConstellations", (NBTBase)l);
        cmp.func_74768_a("tierReached", this.tierReached.ordinal());
        cmp.func_74757_a("wasAttuned", this.wasOnceAttuned);
        NBTTagList nBTTagList = new NBTTagList();
        for (String s : this.freePointTokens) {
            nBTTagList.func_74742_a((NBTBase)new NBTTagString(s));
        }
        cmp.func_74782_a("pointTokens", (NBTBase)nBTTagList);
        int[] nArray = new int[this.researchProgression.size()];
        for (int i = 0; i < this.researchProgression.size(); ++i) {
            ResearchProgression progression = this.researchProgression.get(i);
            nArray[i] = progression.getProgressId();
        }
        cmp.func_74783_a("research", nArray);
        if (this.attunedConstellation != null) {
            cmp.func_74778_a("attuned", this.attunedConstellation.getUnlocalizedName());
        }
        list = new NBTTagList();
        for (Map.Entry<AbstractPerk, NBTTagCompound> entry : this.unlockedPerks.entrySet()) {
            tag = new NBTTagCompound();
            tag.func_74778_a("perkName", entry.getKey().getRegistryName().toString());
            tag.func_74782_a("perkData", (NBTBase)entry.getValue());
            list.func_74742_a((NBTBase)tag);
        }
        cmp.func_74782_a("perks", (NBTBase)list);
        list = new NBTTagList();
        for (AbstractPerk perk : this.sealedPerks) {
            tag = new NBTTagCompound();
            tag.func_74778_a("perkName", perk.getRegistryName().toString());
            list.func_74742_a((NBTBase)tag);
        }
        cmp.func_74782_a("sealedPerks", (NBTBase)list);
        cmp.func_74768_a("perkTreeVersion", 1);
        list = new NBTTagList();
        for (SextantFinder.TargetObject to : this.usedTargets) {
            list.func_74742_a((NBTBase)new NBTTagString(to.getRegistryName()));
        }
        cmp.func_74782_a("sextanttargets", (NBTBase)list);
        cmp.func_74780_a("perkExp", this.perkExp);
    }

    public void storeKnowledge(NBTTagCompound cmp) {
        NBTTagList list = new NBTTagList();
        for (String string : this.knownConstellations) {
            list.func_74742_a((NBTBase)new NBTTagString(string));
        }
        NBTTagList l = new NBTTagList();
        for (String string : this.seenConstellations) {
            l.func_74742_a((NBTBase)new NBTTagString(string));
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (SextantFinder.TargetObject targetObject : this.usedTargets) {
            nBTTagList.func_74742_a((NBTBase)new NBTTagString(targetObject.getRegistryName()));
        }
        NBTTagList nBTTagList2 = new NBTTagList();
        for (String s : this.freePointTokens) {
            nBTTagList2.func_74742_a((NBTBase)new NBTTagString(s));
        }
        cmp.func_74782_a("constellations", (NBTBase)list);
        cmp.func_74782_a("seenConstellations", (NBTBase)l);
        cmp.func_74782_a("sextanttargets", (NBTBase)nBTTagList);
        cmp.func_74782_a("pointTokens", (NBTBase)nBTTagList2);
        cmp.func_74768_a("tierReached", this.tierReached.ordinal());
        cmp.func_74757_a("wasAttuned", this.wasOnceAttuned);
        int[] nArray = new int[this.researchProgression.size()];
        for (int i = 0; i < this.researchProgression.size(); ++i) {
            ResearchProgression progression = this.researchProgression.get(i);
            nArray[i] = progression.getProgressId();
        }
        cmp.func_74783_a("research", nArray);
    }

    public void loadKnowledge(NBTTagCompound compound) {
        int i;
        NBTTagList list;
        this.knownConstellations.clear();
        this.researchProgression.clear();
        this.usedTargets.clear();
        this.attunedConstellation = null;
        this.tierReached = ProgressionTier.DISCOVERY;
        this.wasOnceAttuned = false;
        this.unlockedPerks.clear();
        this.sealedPerks.clear();
        this.freePointTokens.clear();
        this.perkExp = 0.0;
        if (compound.func_74764_b("seenConstellations")) {
            list = compound.func_150295_c("seenConstellations", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.seenConstellations.add(list.func_150307_f(i));
            }
        }
        if (compound.func_74764_b("constellations")) {
            list = compound.func_150295_c("constellations", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                String s = list.func_150307_f(i);
                this.knownConstellations.add(s);
                if (this.seenConstellations.contains(s)) continue;
                this.seenConstellations.add(s);
            }
        }
        if (compound.func_74764_b("tierReached")) {
            int tierOrdinal = compound.func_74762_e("tierReached");
            this.tierReached = ProgressionTier.values()[MathHelper.func_76125_a((int)tierOrdinal, (int)0, (int)(ProgressionTier.values().length - 1))];
        }
        if (compound.func_74764_b("research")) {
            int[] research;
            for (int resOrdinal : research = compound.func_74759_k("research")) {
                ResearchProgression prog = ResearchProgression.getById(resOrdinal);
                if (prog == null) continue;
                this.researchProgression.add(prog);
            }
        }
        if (compound.func_74764_b("sextanttargets")) {
            NBTTagList list2 = compound.func_150295_c("sextanttargets", 8);
            for (int i2 = 0; i2 < list2.func_74745_c(); ++i2) {
                String strTarget = list2.func_150307_f(i2);
                SextantFinder.TargetObject to = SextantFinder.getByName(strTarget);
                if (to == null || this.usedTargets.contains(to)) continue;
                this.usedTargets.add(to);
            }
        }
        if (compound.func_74764_b("pointTokens")) {
            NBTTagList list3 = compound.func_150295_c("pointTokens", 8);
            for (int i3 = 0; i3 < list3.func_74745_c(); ++i3) {
                this.freePointTokens.add(list3.func_150307_f(i3));
            }
        }
        this.wasOnceAttuned = compound.func_74767_n("wasAttuned");
    }

    protected boolean forceGainResearch(ResearchProgression progression) {
        if (!this.researchProgression.contains((Object)progression)) {
            this.researchProgression.add(progression);
            return true;
        }
        return false;
    }

    protected void setAttunedConstellation(IMajorConstellation constellation) {
        this.attunedConstellation = constellation;
        this.wasOnceAttuned = true;
    }

    public Collection<AbstractPerk> getAppliedPerks() {
        return this.unlockedPerks == null ? Lists.newArrayList() : Collections.unmodifiableCollection(this.unlockedPerks.keySet());
    }

    public List<AbstractPerk> getSealedPerks() {
        return this.sealedPerks == null ? Lists.newArrayList() : Collections.unmodifiableList(this.sealedPerks);
    }

    public Map<AbstractPerk, NBTTagCompound> getUnlockedPerkData() {
        return this.unlockedPerks == null ? Maps.newHashMap() : Collections.unmodifiableMap(this.unlockedPerks);
    }

    @Nullable
    protected NBTTagCompound getPerkData(AbstractPerk perk) {
        return this.unlockedPerks.get(perk);
    }

    public boolean hasPerkEffect(AbstractPerk perk) {
        return this.hasPerkUnlocked(perk) && !this.isPerkSealed(perk);
    }

    public boolean hasPerkUnlocked(AbstractPerk perk) {
        return this.unlockedPerks.containsKey(perk);
    }

    public boolean isPerkSealed(AbstractPerk perk) {
        return this.sealedPerks.contains(perk);
    }

    public void putPerk(AbstractPerk perk, NBTTagCompound data) {
        this.unlockedPerks.put(perk, data);
    }

    protected boolean removePerk(AbstractPerk perk) {
        return this.unlockedPerks.remove(perk) != null && (!this.sealedPerks.contains(perk) || this.sealedPerks.remove(perk));
    }

    protected boolean sealPerk(AbstractPerk perk) {
        if (this.sealedPerks.contains(perk) || !this.hasPerkUnlocked(perk)) {
            return false;
        }
        return this.sealedPerks.add(perk);
    }

    protected boolean breakSeal(AbstractPerk perk) {
        if (!this.sealedPerks.contains(perk) || !this.hasPerkUnlocked(perk)) {
            return false;
        }
        return this.sealedPerks.remove(perk);
    }

    public List<ResearchProgression> getResearchProgression() {
        this.researchProgression.removeIf(Objects::isNull);
        return Lists.newLinkedList(this.researchProgression);
    }

    public List<SextantFinder.TargetObject> getUsedTargets() {
        return this.usedTargets;
    }

    public void useTarget(SextantFinder.TargetObject target) {
        if (!this.usedTargets.contains(target)) {
            this.usedTargets.add(target);
        }
    }

    public ProgressionTier getTierReached() {
        return this.tierReached;
    }

    public IMajorConstellation getAttunedConstellation() {
        return this.attunedConstellation;
    }

    public boolean wasOnceAttuned() {
        return this.wasOnceAttuned;
    }

    protected void setAttunedBefore(boolean attuned) {
        this.wasOnceAttuned = attuned;
    }

    protected boolean grantFreeAllocationPoint(String freePointToken) {
        if (this.freePointTokens.contains(freePointToken)) {
            return false;
        }
        this.freePointTokens.add(freePointToken);
        return true;
    }

    protected boolean tryRevokeAllocationPoint(String token) {
        return this.freePointTokens.remove(token);
    }

    public List<String> getFreePointTokens() {
        return Collections.unmodifiableList(this.freePointTokens);
    }

    public int getAvailablePerkPoints() {
        int allocatedPerks = this.unlockedPerks.size() - 1;
        int allocationLevels = PerkLevelManager.INSTANCE.getLevel(MathHelper.func_76128_c((double)this.getPerkExp()));
        return allocationLevels + this.freePointTokens.size() - allocatedPerks;
    }

    public boolean hasFreeAllocationPoint() {
        return this.getAvailablePerkPoints() > 0;
    }

    public double getPerkExp() {
        return this.perkExp;
    }

    protected void modifyExp(double exp) {
        int currLevel = PerkLevelManager.INSTANCE.getLevel(MathHelper.func_76128_c((double)this.getPerkExp()));
        if (exp >= 0.0 && currLevel >= PerkLevelManager.INSTANCE.getLevelCap()) {
            return;
        }
        int expThisLevel = PerkLevelManager.INSTANCE.getExpForLevel(currLevel);
        int expNextLevel = PerkLevelManager.INSTANCE.getExpForLevel(currLevel + 1);
        int cap = MathHelper.func_76141_d((float)((float)(expNextLevel - expThisLevel) * 0.08f));
        if (exp > (double)cap) {
            exp = cap;
        }
        this.perkExp = Math.max(this.perkExp + exp, 0.0);
    }

    protected void setExp(double exp) {
        this.perkExp = Math.max(exp, 0.0);
    }

    protected boolean stepTier() {
        if (this.getTierReached().hasNextTier()) {
            this.setTierReached(ProgressionTier.values()[this.getTierReached().ordinal() + 1]);
            return true;
        }
        return false;
    }

    protected void setTierReached(ProgressionTier tier) {
        this.tierReached = tier;
    }

    public List<String> getKnownConstellations() {
        return this.knownConstellations;
    }

    public List<String> getSeenConstellations() {
        return this.seenConstellations;
    }

    public boolean hasConstellationDiscovered(IConstellation constellation) {
        return this.hasConstellationDiscovered(constellation.getUnlocalizedName());
    }

    public boolean hasConstellationDiscovered(String constellation) {
        return this.knownConstellations.contains(constellation);
    }

    protected void discoverConstellation(String name) {
        this.memorizeConstellation(name);
        if (!this.knownConstellations.contains(name)) {
            this.knownConstellations.add(name);
        }
    }

    protected void memorizeConstellation(String name) {
        if (!this.seenConstellations.contains(name)) {
            this.seenConstellations.add(name);
        }
    }

    protected void receive(PktSyncKnowledge message) {
        this.knownConstellations = message.knownConstellations;
        this.seenConstellations = message.seenConstellations;
        this.researchProgression = message.researchProgression;
        this.tierReached = ProgressionTier.values()[MathHelper.func_76125_a((int)message.progressTier, (int)0, (int)(ProgressionTier.values().length - 1))];
        this.attunedConstellation = message.attunedConstellation;
        this.wasOnceAttuned = message.wasOnceAttuned;
        this.usedTargets = message.usedTargets;
        this.freePointTokens = message.freePointTokens;
        this.unlockedPerks = message.usedPerks;
        this.sealedPerks = message.sealedPerks;
        this.perkExp = message.perkExp;
    }

    public void acceptMergeFrom(PlayerProgress toMergeFrom) {
        for (String seen : toMergeFrom.seenConstellations) {
            this.memorizeConstellation(seen);
        }
        for (String known : toMergeFrom.knownConstellations) {
            this.discoverConstellation(known);
        }
        if (toMergeFrom.wasOnceAttuned) {
            this.wasOnceAttuned = true;
        }
        if (toMergeFrom.tierReached.isThisLaterOrEqual(this.tierReached)) {
            this.tierReached = toMergeFrom.tierReached;
        }
        for (ResearchProgression prog : toMergeFrom.researchProgression) {
            this.forceGainResearch(prog);
        }
        for (SextantFinder.TargetObject target : toMergeFrom.usedTargets) {
            this.useTarget(target);
        }
    }
}

