/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data;

import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffectHelper;
import hellfirepvp.astralsorcery.common.base.patreon.flare.PatreonPartialEntity;
import hellfirepvp.astralsorcery.common.data.AbstractData;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;

public class DataPatreonFlares
extends AbstractData {
    private Map<UUID, PatreonPartialEntity> patreonFlaresClient = new HashMap<UUID, PatreonPartialEntity>();
    private Map<UUID, PatreonPartialEntity> patreonFlaresServer = new HashMap<UUID, PatreonPartialEntity>();
    private List<UUID> flareAdditions = new LinkedList<UUID>();
    private List<UUID> flareRemovals = new LinkedList<UUID>();
    private NBTTagCompound clientReadBuffer = new NBTTagCompound();

    @Nullable
    public PatreonPartialEntity getEntity(Side side, UUID uuid) {
        if (side == Side.CLIENT) {
            return this.patreonFlaresClient.get(uuid);
        }
        return this.patreonFlaresServer.get(uuid);
    }

    public Collection<PatreonPartialEntity> getEntities(Side side) {
        return side == Side.CLIENT ? this.patreonFlaresClient.values() : this.patreonFlaresServer.values();
    }

    public PatreonPartialEntity createEntity(EntityPlayer player, PatreonEffectHelper.PatreonEffect value) {
        UUID owner = player.func_110124_au();
        PatreonPartialEntity entity = value.createEntity(owner);
        entity.setPositionNear(player);
        this.patreonFlaresServer.put(owner, entity);
        this.flareRemovals.remove(owner);
        if (!this.flareAdditions.contains(owner)) {
            this.flareAdditions.add(owner);
        }
        this.markDirty();
        return entity;
    }

    public void updateEntity(PatreonPartialEntity flare) {
        UUID owner = flare.getOwnerUUID();
        this.flareRemovals.remove(owner);
        if (!this.flareAdditions.contains(owner)) {
            this.flareAdditions.add(owner);
        }
        this.markDirty();
    }

    public void destroyEntity(PatreonPartialEntity flare) {
        UUID owner = flare.getOwnerUUID();
        this.flareAdditions.remove(owner);
        if (!this.flareRemovals.contains(owner)) {
            this.flareRemovals.add(owner);
        }
        this.markDirty();
        flare.setRemoved(true);
    }

    public void cleanUp(Side side) {
        if (side == Side.CLIENT) {
            this.patreonFlaresClient.clear();
            this.clientReadBuffer = new NBTTagCompound();
        } else {
            this.patreonFlaresServer.clear();
            this.flareRemovals.clear();
            this.flareAdditions.clear();
        }
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        NBTTagList entries = new NBTTagList();
        for (Map.Entry<UUID, PatreonPartialEntity> flares : this.patreonFlaresServer.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_186854_a("owner", flares.getKey());
            NBTTagCompound flareTag = new NBTTagCompound();
            flares.getValue().writeToNBT(flareTag);
            tag.func_74782_a("flareData", (NBTBase)flareTag);
            entries.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("flareAdditions", (NBTBase)entries);
        compound.func_74782_a("flareRemovals", (NBTBase)new NBTTagList());
    }

    @Override
    public void writeToPacket(NBTTagCompound compound) {
        NBTTagList additions = new NBTTagList();
        for (UUID added : this.flareAdditions) {
            NBTTagCompound tag = new NBTTagCompound();
            PatreonPartialEntity flare = this.patreonFlaresServer.get(added);
            if (flare == null) continue;
            tag.func_186854_a("owner", added);
            NBTTagCompound flareTag = new NBTTagCompound();
            flare.writeToNBT(flareTag);
            tag.func_74782_a("flareData", (NBTBase)flareTag);
            additions.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("flareAdditions", (NBTBase)additions);
        NBTTagList removals = new NBTTagList();
        for (UUID added : this.flareRemovals) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_186854_a("owner", added);
            removals.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("flareRemovals", (NBTBase)removals);
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        this.clientReadBuffer = compound;
    }

    @Override
    public void handleIncomingData(AbstractData serverData) {
        if (serverData == null || !(serverData instanceof DataPatreonFlares)) {
            return;
        }
        NBTTagList add = ((DataPatreonFlares)serverData).clientReadBuffer.func_150295_c("flareAdditions", 10);
        for (int i = 0; i < add.func_74745_c(); ++i) {
            NBTTagCompound cmp = add.func_150305_b(i);
            UUID owner = cmp.func_186857_a("owner");
            NBTTagCompound flareTag = cmp.func_74775_l("flareData");
            PatreonEffectHelper.PatreonEffect pe = PatreonEffectHelper.getEffect(Side.SERVER, owner);
            if (pe == null || !pe.hasPartialEntity()) continue;
            PatreonPartialEntity entity = this.patreonFlaresClient.get(owner);
            if (entity == null) {
                entity = pe.createEntity(owner);
                if (entity == null) {
                    throw new IllegalStateException("FATAL ERROR: Eventhough a PatreonEffect guaranteed a proper partial entity, it was unable to provide one!");
                }
                this.patreonFlaresClient.put(owner, entity);
            }
            entity.readFromNBT(flareTag);
        }
        NBTTagList remove = ((DataPatreonFlares)serverData).clientReadBuffer.func_150295_c("flareRemovals", 10);
        for (int i = 0; i < remove.func_74745_c(); ++i) {
            NBTTagCompound cmp = remove.func_150305_b(i);
            UUID owner = cmp.func_186857_a("owner");
            PatreonPartialEntity flare = this.patreonFlaresClient.remove(owner);
            if (flare == null) continue;
            flare.setRemoved(true);
        }
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataPatreonFlares> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataPatreonFlares provideNewInstance(Side side) {
            return new DataPatreonFlares();
        }
    }
}

