/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.util.DamageSourceEntity;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class KeyLightningArc
extends KeyPerk {
    private static boolean chainingDamage = false;
    private static float arcChance = 0.6f;
    private static float arcPercent = 0.75f;
    private static int arcTicks = 3;
    private static float distanceSearch = 7.0f;
    private static int arcBaseChains = 3;

    public KeyLightningArc(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                arcChance = cfg.getFloat("Chance", this.getConfigurationSection(), arcChance, 0.0f, 1.0f, "Sets the chance to spawn a damage-arc effect when an enemy is hit (value is in percent)");
                arcPercent = cfg.getFloat("DamagePercent", this.getConfigurationSection(), arcPercent, 0.1f, 64.0f, "Defines the damage-multiplier which gets added to the damage dealt initially.");
                distanceSearch = cfg.getFloat("Distance", this.getConfigurationSection(), distanceSearch, 0.2f, 16.0f, "Defines the distance for how far a single arc can jump/search for nearby entities");
                arcTicks = cfg.getInt("DamageTicks", this.getConfigurationSection(), arcTicks, 1, 128, "Defines the amount of times an arc will repetitively chain between the mobs and deal damage after initially spawned/triggered");
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttack(LivingHurtEvent event) {
        Side side;
        EntityPlayer player;
        PlayerProgress prog;
        if (chainingDamage) {
            return;
        }
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && (prog = ResearchManager.getProgress(player = (EntityPlayer)source.func_76346_g(), side = player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER)) != null && side == Side.SERVER && prog.hasPerkEffect(this)) {
            float chance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue("astralsorcery.perkeffect", arcChance);
            if (rand.nextFloat() < chance) {
                float dmg = event.getAmount();
                dmg = Math.max(MathHelper.func_76129_c((float)dmg), 1.5f);
                new RepetitiveArcEffect(player.field_70170_p, player, arcTicks, event.getEntityLiving().func_145782_y(), dmg).fire();
            }
        }
    }

    static class RepetitiveArcEffect {
        private World world;
        private EntityPlayer player;
        private int count;
        private int entityStartId;
        private float damage;

        public RepetitiveArcEffect(World world, EntityPlayer player, int count, int entityStartId, float damage) {
            this.world = world;
            this.player = player;
            this.count = count;
            this.entityStartId = entityStartId;
            this.damage = damage;
        }

        void fire() {
            if (this.player.field_70128_L) {
                return;
            }
            Color c = new Color(103935);
            int chainTimes = Math.round(PerkAttributeHelper.getOrCreateMap(this.player, Side.SERVER).modifyValue("astralsorcery.archops", arcBaseChains));
            ArrayList visitedEntities = Lists.newArrayList();
            Entity start = this.world.func_73045_a(this.entityStartId);
            if (start != null && start instanceof EntityLivingBase && !start.field_70128_L) {
                AxisAlignedBB box = new AxisAlignedBB((double)(-distanceSearch), (double)(-distanceSearch), (double)(-distanceSearch), (double)distanceSearch, (double)distanceSearch, (double)distanceSearch);
                DamageSourceEntity src = CommonProxy.dmgSourceStellar.setSource((EntityLivingBase)this.player);
                EntityLivingBase last = null;
                EntityLivingBase entity = (EntityLivingBase)start;
                while (entity != null && !entity.field_70128_L && chainTimes > 0) {
                    visitedEntities.add(entity);
                    --chainTimes;
                    if (last != null) {
                        AstralSorcery.proxy.fireLightning(entity.func_130014_f_(), Vector3.atEntityCenter(last), Vector3.atEntityCenter((Entity)entity), c);
                        AstralSorcery.proxy.fireLightning(entity.func_130014_f_(), Vector3.atEntityCenter((Entity)entity), Vector3.atEntityCenter(last), c);
                    }
                    List entities = entity.func_130014_f_().func_175647_a(EntityLivingBase.class, box.func_191194_a(entity.func_174791_d()), EntityUtils.selectEntities(EntityLivingBase.class));
                    entities.remove(entity);
                    if (last != null) {
                        entities.remove(last);
                    }
                    if (this.player != null) {
                        entities.remove(this.player);
                    }
                    entities.removeAll(visitedEntities);
                    entities.removeIf(e -> !MiscUtils.canPlayerAttackServer((EntityLivingBase)this.player, e));
                    if (!entities.isEmpty()) {
                        EntityLivingBase tmpEntity = entity;
                        EntityLivingBase closest = EntityUtils.selectClosest(entities, e -> e.func_70032_d((Entity)tmpEntity));
                        if (closest != null && !closest.field_70128_L) {
                            last = entity;
                            entity = closest;
                            continue;
                        }
                        entity = null;
                        continue;
                    }
                    entity = null;
                }
                if (visitedEntities.size() > 1) {
                    visitedEntities.forEach(e -> {
                        chainingDamage = true;
                        e.func_70097_a(src, this.damage);
                        chainingDamage = false;
                    });
                }
            }
            if (this.count > 0) {
                --this.count;
                AstralSorcery.proxy.scheduleDelayed(this::fire, 12);
            }
        }
    }
}

