/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class KeyLastBreath
extends KeyPerk {
    private static float digSpeedIncrease = 1.5f;
    private static float damageIncrease = 3.0f;

    public KeyLastBreath(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                digSpeedIncrease = cfg.getFloat("HarvestSpeed_Increase", this.getConfigurationSection(), digSpeedIncrease, 1.0f, 32.0f, "Defines the dig speed multiplier you get additionally to your normal dig speed when being low on health (25% health = 75% of this additional multiplier)");
                damageIncrease = cfg.getFloat("Damage_Increase", this.getConfigurationSection(), damageIncrease, 1.0f, 32.0f, "Defines the damage multiplier you get additionally to your normal damage when being low on health (25% health = 75% of this additional multiplier)");
            }
        });
    }

    @SubscribeEvent
    public void onAttack(LivingHurtEvent event) {
        Side side;
        EntityPlayer player;
        PlayerProgress prog;
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && (prog = ResearchManager.getProgress(player = (EntityPlayer)source.func_76346_g(), side = player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER)) != null && prog.hasPerkEffect(this)) {
            float actIncrease = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue("astralsorcery.perkeffect", damageIncrease);
            float healthPerc = 1.0f - player.func_110143_aJ() / player.func_110138_aP();
            event.setAmount(event.getAmount() * (1.0f + healthPerc * actIncrease));
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Side side;
        EntityPlayer player = event.getEntityPlayer();
        PlayerProgress prog = ResearchManager.getProgress(player, side = event.getEntityLiving().field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
        if (prog != null && prog.hasPerkEffect(this)) {
            float actIncrease = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue("astralsorcery.perkeffect", digSpeedIncrease);
            float healthPerc = 1.0f - player.func_110143_aJ() / player.func_110138_aP();
            event.setNewSpeed(event.getNewSpeed() * (1.0f + healthPerc * actIncrease));
        }
    }
}

