/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.types.IPlayerTickPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.CropHelper;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class KeyGrowable
extends KeyPerk
implements IPlayerTickPerk {
    private static int chanceToBonemeal = 3;
    private static int radius = 3;

    public KeyGrowable(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                chanceToBonemeal = cfg.getInt("Growth_Chance", this.getConfigurationSection(), chanceToBonemeal, 1, 1000000, "Sets the chance (Random.nextInt(chance) == 0) to try to see if a random plant near the player gets bonemeal'd; the lower the more likely");
                radius = cfg.getInt("Radius", this.getConfigurationSection(), radius, 1, 16, "Defines the radius around which the perk effect should apply around the player");
            }
        });
    }

    @Override
    public void onPlayerTick(EntityPlayer player, Side side) {
        if (side != Side.SERVER) {
            return;
        }
        float cChance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue("astralsorcery.perkeffect", chanceToBonemeal);
        int chance = Math.max(MathHelper.func_76141_d((float)cChance), 1);
        if (rand.nextInt(chance) == 0) {
            float fRadius = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue("astralsorcery.perkeffect", radius);
            int rRadius = Math.max(MathHelper.func_76141_d((float)fRadius), 1);
            BlockPos pos = player.func_180425_c().func_177982_a(rand.nextInt(rRadius * 2) + 1 - rRadius, rand.nextInt(rRadius * 2) + 1 - rRadius, rand.nextInt(rRadius * 2) + 1 - rRadius);
            World w = player.func_130014_f_();
            CropHelper.GrowablePlant plant = CropHelper.wrapPlant(w, pos);
            PktParticleEvent pkt = null;
            if (plant != null) {
                if (plant.tryGrow(w, rand)) {
                    pkt = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_CROP_INTERACT, (Vec3i)pos);
                }
            } else {
                IBlockState at = w.func_180495_p(pos);
                if (at.func_177230_c() instanceof BlockDirt && ((BlockDirt.DirtType)at.func_177229_b((IProperty)BlockDirt.field_176386_a)).equals((Object)BlockDirt.DirtType.DIRT) && w.func_175656_a(pos, Blocks.field_150349_c.func_176223_P())) {
                    pkt = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_CROP_INTERACT, (Vec3i)pos);
                }
            }
            if (pkt != null) {
                PacketChannel.CHANNEL.sendToAllAround((IMessage)pkt, PacketChannel.pointFromPos(w, (Vec3i)pos, 16.0));
            }
        }
    }
}

