/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree;

import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.resource.SpriteQuery;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkTreePoint {
    private Point offset;
    private final AbstractPerk perk;
    private int renderSize;
    private static final int spriteSize = 11;
    private SpriteQuery querySpriteUnallocated;
    private SpriteQuery querySpriteAllocated;
    private SpriteQuery querySpriteUnlockable;
    private SpriteQuery querySpriteSeal;

    public PerkTreePoint(AbstractPerk perk, Point offset) {
        this.offset = offset;
        this.perk = perk;
        this.renderSize = 11;
    }

    public void setRenderSize(int renderSize) {
        this.renderSize = renderSize;
    }

    public int getRenderSize() {
        return this.renderSize;
    }

    public AbstractPerk getPerk() {
        return this.perk;
    }

    public Point getOffset() {
        return this.offset;
    }

    public void setQuerySpriteAllocated(SpriteQuery querySpriteAllocated) {
        this.querySpriteAllocated = querySpriteAllocated;
    }

    public void setQuerySpriteUnallocated(SpriteQuery querySpriteUnallocated) {
        this.querySpriteUnallocated = querySpriteUnallocated;
    }

    public void setQuerySpriteUnlockable(SpriteQuery querySpriteUnlockable) {
        this.querySpriteUnlockable = querySpriteUnlockable;
    }

    public void setQuerySpriteSeal(SpriteQuery querySpriteSeal) {
        this.querySpriteSeal = querySpriteSeal;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Rectangle renderAtCurrentPos(AllocationStatus status, long spriteOffsetTick, float pTicks) {
        SpriteSheetResource tex;
        if (this.querySpriteUnallocated == null) {
            this.querySpriteUnallocated = SpriteQuery.of(SpriteLibrary.spritePerkInactive);
        }
        if (this.querySpriteAllocated == null) {
            this.querySpriteAllocated = SpriteQuery.of(SpriteLibrary.spritePerkActive);
        }
        if (this.querySpriteUnlockable == null) {
            this.querySpriteUnlockable = SpriteQuery.of(SpriteLibrary.spritePerkActivateable);
        }
        switch (status) {
            case UNALLOCATED: {
                tex = this.querySpriteUnallocated.resolveSprite();
                break;
            }
            case ALLOCATED: {
                tex = this.querySpriteAllocated.resolveSprite();
                break;
            }
            case UNLOCKABLE: {
                tex = this.querySpriteUnlockable.resolveSprite();
                break;
            }
            default: {
                tex = this.querySpriteUnallocated.resolveSprite();
            }
        }
        if (tex == null) {
            return null;
        }
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_179118_c();
        Vector3 starVec = new Vector3(-this.renderSize, -this.renderSize, 0);
        tex.bindTexture();
        double uLength = tex.getULength();
        double vLength = tex.getVLength();
        Tuple<Double, Double> frameUV = tex.getUVOffset(spriteOffsetTick);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(this.renderSize * u * 2).addY(this.renderSize * v * 2);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181675_d();
        }
        tes.func_78381_a();
        GlStateManager.func_179141_d();
        return new Rectangle(-this.renderSize, -this.renderSize, this.renderSize * 2, this.renderSize * 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSealAtCurrentPos(double radius, long spriteOffsetTick, float pTicks) {
        SpriteSheetResource tex;
        if (this.querySpriteSeal == null) {
            this.querySpriteSeal = SpriteQuery.of(SpriteLibrary.spritePerkSeal);
        }
        if ((tex = this.querySpriteSeal.resolveSprite()) == null) {
            return;
        }
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GlStateManager.func_179118_c();
        tex.bindTexture();
        double uLength = tex.getULength();
        double vLength = tex.getVLength();
        Tuple<Double, Double> frameUV = tex.getUVOffset(spriteOffsetTick);
        Vector3 starVec = new Vector3(-radius, -radius, 0.0);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(radius * (double)u * 2.0).addY(radius * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181675_d();
        }
        tes.func_78381_a();
        GlStateManager.func_179141_d();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerkTreePoint that = (PerkTreePoint)o;
        return Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.offset);
    }

    public static enum AllocationStatus {
        UNALLOCATED,
        ALLOCATED,
        UNLOCKABLE;

    }
}

