/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree;

import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.resource.SpriteQuery;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkTreeOffset
extends PerkTreePoint {
    private final IConstellation associatedConstellation;
    private static final int haloSpriteSize = 45;
    private SpriteQuery queryCstUnAllocated;
    private SpriteQuery queryCstAllocated;
    private SpriteQuery queryCstUnlockable;

    public PerkTreeOffset(AbstractPerk perk, Point offset, IConstellation associatedConstellation) {
        super(perk, offset);
        this.associatedConstellation = associatedConstellation;
        this.setRenderSize(22);
    }

    public void setQueryRootPerkHaloUnAllocated(SpriteQuery queryCstUnAllocated) {
        this.queryCstUnAllocated = queryCstUnAllocated;
    }

    public void setQueryRootPerkHaloUnlockable(SpriteQuery queryCstUnlockable) {
        this.queryCstUnlockable = queryCstUnlockable;
    }

    public void setQueryRootPerkHaloAllocated(SpriteQuery queryCstAllocated) {
        this.queryCstAllocated = queryCstAllocated;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Rectangle renderAtCurrentPos(PerkTreePoint.AllocationStatus status, long spriteOffsetTick, float pTicks) {
        SpriteSheetResource tex;
        if (this.queryCstUnAllocated == null) {
            this.queryCstUnAllocated = SpriteQuery.of(SpriteLibrary.spriteHalo4);
        }
        if (this.queryCstAllocated == null) {
            this.queryCstAllocated = SpriteQuery.of(SpriteLibrary.spriteHalo5);
        }
        if (this.queryCstUnlockable == null) {
            this.queryCstUnlockable = SpriteQuery.of(SpriteLibrary.spriteHalo6);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.renderAtCurrentPos(status, spriteOffsetTick, pTicks);
        int haloRenderSize = 45;
        switch (status) {
            case UNALLOCATED: {
                tex = this.queryCstUnAllocated.resolveSprite();
                break;
            }
            case ALLOCATED: {
                haloRenderSize = (int)((double)haloRenderSize * 1.3);
                tex = this.queryCstAllocated.resolveSprite();
                break;
            }
            case UNLOCKABLE: {
                tex = this.queryCstUnlockable.resolveSprite();
                break;
            }
            default: {
                tex = this.queryCstUnAllocated.resolveSprite();
            }
        }
        if (tex == null) {
            return null;
        }
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Vector3 starVec = new Vector3(-haloRenderSize, -haloRenderSize, 0);
        tex.bindTexture();
        double uLength = tex.getULength();
        double vLength = tex.getVLength();
        Tuple<Double, Double> frameUV = tex.getUVOffset(spriteOffsetTick);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(haloRenderSize * u * 2).addY(haloRenderSize * v * 2);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181675_d();
        }
        GlStateManager.func_179118_c();
        tes.func_78381_a();
        GlStateManager.func_179141_d();
        if (this.associatedConstellation != null) {
            Color overlay = Color.WHITE;
            switch (status) {
                case UNALLOCATED: {
                    overlay = new Color(0x3333FF);
                    break;
                }
                case ALLOCATED: {
                    overlay = new Color(0xEEEE00);
                    break;
                }
                case UNLOCKABLE: {
                    overlay = new Color(13181149);
                }
            }
            int size = MathHelper.func_76128_c((double)38.25);
            RenderConstellation.renderConstellationIntoGUI(overlay, this.associatedConstellation, -size, -size, 0.0f, size * 2, size * 2, 1.5, new RenderConstellation.BrightnessFunction(){

                @Override
                public float getBrightness() {
                    return 0.75f;
                }
            }, true, false);
        }
        return new Rectangle(-45, -45, 90, 90);
    }
}

