/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.root.RootPerk;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkTree {
    public static final int PERK_TREE_VERSION = 1;
    public static final PerkTree PERK_TREE = new PerkTree();
    private static Map<ResourceLocation, AbstractPerk> perkMap = new HashMap<ResourceLocation, AbstractPerk>();
    private List<PerkTreePoint> treePoints = new LinkedList<PerkTreePoint>();
    private Map<AbstractPerk, Collection<AbstractPerk>> doubleConnections = new HashMap<AbstractPerk, Collection<AbstractPerk>>();
    private List<Tuple<AbstractPerk, AbstractPerk>> connections = new LinkedList<Tuple<AbstractPerk, AbstractPerk>>();
    private Map<IConstellation, AbstractPerk> rootPerks = new HashMap<IConstellation, AbstractPerk>();

    private PerkTree() {
    }

    public PointConnector registerRootPerk(RootPerk perk) {
        perkMap.put(perk.getRegistryName(), perk);
        this.rootPerks.put(perk.getConstellation(), perk);
        MinecraftForge.EVENT_BUS.register((Object)perk);
        return PERK_TREE.setPoint(perk);
    }

    public PointConnector registerPerk(AbstractPerk perk) {
        perkMap.put(perk.getRegistryName(), perk);
        MinecraftForge.EVENT_BUS.register((Object)perk);
        return PERK_TREE.setPoint(perk);
    }

    @Nullable
    public AbstractPerk getPerk(ResourceLocation key) {
        return perkMap.get(key);
    }

    @Nullable
    public AbstractPerk getAstralSorceryPerk(String keyName) {
        return this.getPerk(new ResourceLocation("astralsorcery", keyName));
    }

    @Nullable
    public AbstractPerk getRootPerk(IConstellation constellation) {
        return this.rootPerks.get(constellation);
    }

    @Nonnull
    private PointConnector setPoint(AbstractPerk perk) throws IllegalArgumentException {
        PerkTreePoint offsetPoint = perk.getPoint();
        if (this.treePoints.contains(offsetPoint)) {
            throw new IllegalArgumentException("Tried to register perk-point at already placed position: " + offsetPoint.getOffset().toString());
        }
        this.treePoints.add(offsetPoint);
        return new PointConnector(perk);
    }

    @Nullable
    public PointConnector tryGetConnector(AbstractPerk point) {
        if (point == null) {
            return null;
        }
        if (this.treePoints.contains(point.getPoint())) {
            return new PointConnector(point);
        }
        return null;
    }

    public Collection<AbstractPerk> getConnectedPerks(AbstractPerk perk) {
        return this.doubleConnections.getOrDefault(perk, Lists.newArrayList());
    }

    public Collection<PerkTreePoint> getPerkPoints() {
        return ImmutableList.copyOf(this.treePoints);
    }

    @SideOnly(value=Side.CLIENT)
    public Collection<Tuple<AbstractPerk, AbstractPerk>> getConnections() {
        return ImmutableList.copyOf(this.connections);
    }

    public void clearCache(Side side) {
        this.treePoints.stream().map(PerkTreePoint::getPerk).forEach(p -> p.clearCaches(side));
    }

    public void removePerk(AbstractPerk perk) {
        if (perk instanceof RootPerk) {
            this.rootPerks.remove(((RootPerk)perk).getConstellation());
        }
        perkMap.remove(perk.getRegistryName());
        MinecraftForge.EVENT_BUS.unregister((Object)perk);
        PerkTreePoint point = perk.getPoint();
        this.treePoints.remove(point);
        new PointConnector(perk).disconnectAll();
    }

    public class PointConnector {
        private final AbstractPerk point;

        public PointConnector(AbstractPerk point) {
            this.point = point;
        }

        public boolean disconnectAll() {
            boolean removedAll = true;
            LinkedList otherLinked = new LinkedList((Collection)PerkTree.this.doubleConnections.get(this.point));
            for (AbstractPerk other : otherLinked) {
                if (this.disconnect(other)) continue;
                removedAll = false;
            }
            return removedAll;
        }

        public boolean disconnect(AbstractPerk other) {
            if (other == null) {
                return false;
            }
            Collection others = (Collection)PerkTree.this.doubleConnections.get(this.point);
            if (others == null) {
                return false;
            }
            if (!others.remove(other)) {
                return false;
            }
            return PerkTree.this.connections.removeIf(t -> ((AbstractPerk)t.getKey()).equals(other) && ((AbstractPerk)t.getValue()).equals(this.point) || ((AbstractPerk)t.getKey()).equals(this.point) && ((AbstractPerk)t.getValue()).equals(other));
        }

        public PointConnector connect(AbstractPerk other) {
            if (other == null) {
                return this;
            }
            Collection pointsTo = PerkTree.this.doubleConnections.computeIfAbsent(other, p -> new LinkedList());
            if (!pointsTo.contains(this.point)) {
                pointsTo.add(this.point);
            }
            if (!(pointsTo = PerkTree.this.doubleConnections.computeIfAbsent(this.point, p -> new LinkedList())).contains(other)) {
                pointsTo.add(other);
            }
            Tuple<AbstractPerk, AbstractPerk> connection = new Tuple<AbstractPerk, AbstractPerk>(this.point, other);
            Tuple<AbstractPerk, AbstractPerk> reverse = new Tuple<AbstractPerk, AbstractPerk>(other, this.point);
            if (!PerkTree.this.connections.contains(connection) && !PerkTree.this.connections.contains(reverse)) {
                PerkTree.this.connections.add(connection);
            }
            return this;
        }

        public PointConnector connect(PointConnector other) {
            return this.connect(other.point);
        }
    }
}

