/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.attribute;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkConverter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;

public class PerkAttributeModifier {
    private static int counter = 0;
    private final int id;
    private float value;
    private final Mode mode;
    private final String attributeType;
    private boolean absolute = false;
    private Map<PerkConverter, Table<String, Mode, PerkAttributeModifier>> cachedConverters = new HashMap<PerkConverter, Table<String, Mode, PerkAttributeModifier>>();

    private PerkAttributeModifier(int id, String type, Mode mode, float value) {
        this.id = id;
        this.attributeType = type;
        this.value = value;
        this.mode = mode;
    }

    public PerkAttributeModifier(String type, Mode mode, float value) {
        this.id = counter++;
        this.attributeType = type;
        this.mode = mode;
        this.value = value;
    }

    private void setAbsolute() {
        this.absolute = true;
    }

    @Nonnull
    public final PerkAttributeModifier convertModifier(String attributeType, Mode mode, float value) {
        if (this.absolute) {
            return this;
        }
        return new PerkAttributeModifier(this.id, attributeType, mode, value);
    }

    @Nonnull
    public final PerkAttributeModifier gainAsExtraModifier(PerkConverter converter, String attributeType, Mode mode, float value) {
        Table cachedModifiers = this.cachedConverters.computeIfAbsent(converter, c -> HashBasedTable.create());
        PerkAttributeModifier modifier = (PerkAttributeModifier)cachedModifiers.get((Object)attributeType, (Object)mode);
        if (modifier == null) {
            modifier = new PerkAttributeModifier(attributeType, mode, value);
            modifier.setAbsolute();
            cachedModifiers.put((Object)attributeType, (Object)mode, (Object)modifier);
        }
        return modifier;
    }

    public float getValue() {
        return this.value;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerkAttributeModifier that = (PerkAttributeModifier)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public static enum Mode {
        ADDITION,
        ADDED_MULTIPLY,
        STACKING_MULTIPLY;


        public static Mode fromVanillaAttributeOperation(int op) {
            return Mode.values()[MathHelper.func_76125_a((int)op, (int)0, (int)(Mode.values().length - 1))];
        }

        public int getVanillaAttributeOperation() {
            return this.ordinal();
        }
    }
}

