/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

public abstract class PerkConverter {
    private static int counter = 0;
    private final int id = counter++;
    public static final PerkConverter IDENTITY = new PerkConverter(){

        @Override
        @Nonnull
        public PerkAttributeModifier convertModifier(PerkAttributeModifier perkAttributeModifier, @Nullable AbstractPerk owningPerk) {
            return perkAttributeModifier;
        }
    };

    @Nonnull
    public abstract PerkAttributeModifier convertModifier(PerkAttributeModifier var1, @Nullable AbstractPerk var2);

    @Nonnull
    public Collection<PerkAttributeModifier> gainExtraModifiers(PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
        return Lists.newArrayList();
    }

    public void onApply(EntityPlayer player, Side side) {
    }

    public void onRemove(EntityPlayer player, Side side) {
    }

    public PerkConverter andThen(final PerkConverter next) {
        final PerkConverter thisConverter = this;
        return new PerkConverter(){

            @Override
            @Nonnull
            public PerkAttributeModifier convertModifier(PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                return thisConverter.convertModifier(next.convertModifier(modifier, owningPerk), owningPerk);
            }
        };
    }

    public Radius asRangedConverter(Point2D.Double offset, double radius) {
        final PerkConverter thisConverter = this;
        return new Radius(offset, radius){

            @Override
            @Nonnull
            public PerkAttributeModifier convertModifierInRange(PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                return thisConverter.convertModifier(modifier, owningPerk);
            }

            @Override
            @Nonnull
            public Collection<PerkAttributeModifier> gainExtraModifiersInRange(PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                return thisConverter.gainExtraModifiers(modifier, owningPerk);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerkConverter that = (PerkConverter)o;
        return this.id == that.id;
    }

    public static abstract class Radius
    extends PerkConverter {
        private final double radius;
        private final Point2D.Double offset;

        public Radius(Point2D.Double point, double radius) {
            this.offset = point;
            this.radius = radius;
        }

        public double getRadius() {
            return this.radius;
        }

        public Point2D.Double getOffset() {
            return this.offset;
        }

        public Radius withNewRadius(double radius) {
            final Radius thisRadius = this;
            return new Radius(thisRadius.getOffset(), radius){

                @Override
                @Nonnull
                public PerkAttributeModifier convertModifierInRange(PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                    return thisRadius.convertModifierInRange(modifier, owningPerk);
                }

                @Override
                @Nonnull
                public Collection<PerkAttributeModifier> gainExtraModifiersInRange(PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
                    return thisRadius.gainExtraModifiersInRange(modifier, owningPerk);
                }
            };
        }

        protected boolean canAffectPerk(@Nullable AbstractPerk otherPerk) {
            return otherPerk != null && this.getOffset().distance(otherPerk.getOffset()) <= this.getRadius();
        }

        @Override
        @Nonnull
        public PerkAttributeModifier convertModifier(PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
            if (!this.canAffectPerk(owningPerk)) {
                return modifier;
            }
            return this.convertModifierInRange(modifier, owningPerk);
        }

        @Override
        @Nonnull
        public Collection<PerkAttributeModifier> gainExtraModifiers(PerkAttributeModifier modifier, @Nullable AbstractPerk owningPerk) {
            if (!this.canAffectPerk(owningPerk)) {
                return Collections.emptyList();
            }
            return this.gainExtraModifiersInRange(modifier, owningPerk);
        }

        @Nonnull
        public abstract PerkAttributeModifier convertModifierInRange(PerkAttributeModifier var1, @Nullable AbstractPerk var2);

        @Nonnull
        public abstract Collection<PerkAttributeModifier> gainExtraModifiersInRange(PerkAttributeModifier var1, @Nullable AbstractPerk var2);
    }
}

