/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.network;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.block.BlockAttunementRelay;
import hellfirepvp.astralsorcery.common.block.BlockCustomName;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.block.network.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.IVariantTileProvider;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import hellfirepvp.astralsorcery.common.util.struct.BlockDiscoverer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAltar
extends BlockStarlightNetwork
implements BlockCustomName,
BlockVariants {
    private static final AxisAlignedBB boxAttenuation = new AxisAlignedBB(-0.5, 0.0, -0.5, 1.5, 1.1875, 1.5);
    private static final AxisAlignedBB boxConstellation = new AxisAlignedBB(-0.75, 0.0, -0.75, 1.75, 1.5, 1.75);
    public static PropertyBool RENDER_FULLY = PropertyBool.func_177716_a((String)"render");
    public static PropertyEnum<AltarType> ALTAR_TYPE = PropertyEnum.func_177709_a((String)"altartype", AltarType.class);

    public BlockAltar() {
        super(Material.field_151576_e, MapColor.field_151670_w);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149752_b(25.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ALTAR_TYPE, (Comparable)((Object)AltarType.ALTAR_1)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileAltar ta;
        if (!worldIn.field_72995_K && (ta = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileAltar.class, true)) != null) {
            switch (ta.getAltarLevel()) {
                case DISCOVERY: {
                    AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.ALTAR_DISCOVERY, playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                case ATTUNEMENT: {
                    AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.ALTAR_ATTUNEMENT, playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                case CONSTELLATION_CRAFT: {
                    AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.ALTAR_CONSTELLATION, playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                case TRAIT_CRAFT: {
                    AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.ALTAR_TRAIT, playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
            }
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (AltarType type : AltarType.values()) {
            if (type == AltarType.ALTAR_5) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        BlockAltar.startSearchForRelayUpdate(worldIn, pos);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        BlockAltar.startSearchForRelayUpdate(worldIn, pos);
    }

    public static void startSearchForRelayUpdate(World world, BlockPos pos) {
        Thread searchThread = new Thread(() -> {
            BlockArray relaysAndAltars = BlockDiscoverer.searchForBlocksAround(world, pos, 16, new BlockStateCheck.Block(new Block[]{BlocksAS.attunementRelay}));
            for (Map.Entry<BlockPos, BlockArray.BlockInformation> entry : relaysAndAltars.getPattern().entrySet()) {
                BlockAttunementRelay.startSearchRelayLinkThreadAt(world, entry.getKey(), false);
            }
        });
        searchThread.setName("AttRelay UpdateFinder at " + pos.toString());
        searchThread.start();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AltarType type = (AltarType)((Object)state.func_177229_b(ALTAR_TYPE));
        AxisAlignedBB box = type.getBox();
        if (box != null) {
            return box;
        }
        return field_185505_j;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        AltarType type = (AltarType)((Object)state.func_177229_b(ALTAR_TYPE));
        return type.provideTileEntity(world, state);
    }

    public IBlockState func_176203_a(int meta) {
        return meta < AltarType.values().length ? this.func_176223_P().func_177226_a(ALTAR_TYPE, (Comparable)((Object)AltarType.values()[meta])) : this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        AltarType type = (AltarType)((Object)state.func_177229_b(ALTAR_TYPE));
        return type.ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ALTAR_TYPE, RENDER_FULLY});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int lvl = stack.func_77952_i();
        TileAltar ta = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileAltar.class, true);
        if (ta != null) {
            ta.onPlace(TileAltar.AltarLevel.values()[lvl]);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (!worldIn.field_72995_K && te != null && te instanceof TileAltar) {
            ItemStack out = new ItemStack((Block)BlocksAS.blockAltar, 1, this.func_180651_a(state));
            ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, out);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return super.getPickBlock(world.func_180495_p(pos), target, world, pos, player);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        AltarType mt = (AltarType)((Object)this.func_176203_a(meta).func_177229_b(ALTAR_TYPE));
        return mt.func_176610_l();
    }

    @Override
    public List<IBlockState> getValidStates() {
        LinkedList<IBlockState> ret = new LinkedList<IBlockState>();
        for (AltarType type : AltarType.values()) {
            ret.add(this.func_176223_P().func_177226_a(ALTAR_TYPE, (Comparable)((Object)type)));
        }
        return ret;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((AltarType)((Object)state.func_177229_b(ALTAR_TYPE))).func_176610_l();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public static enum AltarType implements IStringSerializable,
    IVariantTileProvider
    {
        ALTAR_1((world, state) -> new TileAltar(TileAltar.AltarLevel.DISCOVERY)),
        ALTAR_2((world, state) -> new TileAltar(TileAltar.AltarLevel.ATTUNEMENT)),
        ALTAR_3((world, state) -> new TileAltar(TileAltar.AltarLevel.CONSTELLATION_CRAFT)),
        ALTAR_4((world, state) -> new TileAltar(TileAltar.AltarLevel.TRAIT_CRAFT)),
        ALTAR_5((world, state) -> new TileAltar(TileAltar.AltarLevel.ENDGAME));

        private final IVariantTileProvider provider;

        private AltarType(IVariantTileProvider provider) {
            this.provider = provider;
        }

        @Override
        public TileEntity provideTileEntity(World world, IBlockState state) {
            return this.provider.provideTileEntity(world, state);
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }

        public AxisAlignedBB getBox() {
            switch (this) {
                case ALTAR_1: {
                    return Block.field_185505_j;
                }
                case ALTAR_2: {
                    return Block.field_185505_j;
                }
                case ALTAR_3: {
                    return Block.field_185505_j;
                }
                case ALTAR_4: {
                    return null;
                }
                case ALTAR_5: {
                    return null;
                }
            }
            return null;
        }
    }
}

