/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.util.BlockStateCheck;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public enum TreeTypes {
    OAK("minecraft", "log", "leaves", "sapling", new int[]{0, 4, 8, 12}, new int[]{0, 4, 8, 12}, (Integer)0),
    SPRUCE("minecraft", "log", "leaves", "sapling", new int[]{1, 5, 9, 13}, new int[]{1, 5, 9, 13}, (Integer)1),
    BIRCH("minecraft", "log", "leaves", "sapling", new int[]{2, 6, 10, 14}, new int[]{2, 6, 10, 14}, (Integer)2),
    JUNGLE("minecraft", "log", "leaves", "sapling", new int[]{3, 7, 11, 15}, new int[]{3, 7, 11, 15}, (Integer)3),
    ACACIA("minecraft", "log2", "leaves2", "sapling", new int[]{0, 4, 8, 12}, new int[]{0, 4, 8, 12}, (Integer)4),
    DARK_OAK("minecraft", "log2", "leaves2", "sapling", new int[]{1, 5, 9, 13}, new int[]{1, 5, 9, 13}, (Integer)5),
    SLIME(Mods.TICONSTRUCT, "slime_congealed", "slime_leaves", "slime_sapling", null, null, null);

    private String parentModId;
    private ResourceLocation resBlockName;
    private ResourceLocation resLeavesName;
    private ResourceLocation resSaplingName;
    private boolean exists = false;
    private Collection<IBlockState> logStates = Lists.newArrayList();
    private Collection<IBlockState> leaveStates = Lists.newArrayList();
    private IBlockState saplingState = null;
    private BlockStateCheck logCheck;
    private BlockStateCheck leavesCheck;
    private BlockStateCheck saplingCheck;

    private TreeTypes(Mods parentMod, String resBlockName, @Nullable String resLeavesName, @Nullable String resSaplingName, @Nullable int[] logMeta, int[] leaveMeta, Integer saplingMeta) {
        this(parentMod.modid, new ResourceLocation(parentMod.modid, resBlockName), new ResourceLocation(parentMod.modid, resLeavesName), new ResourceLocation(parentMod.modid, resSaplingName), logMeta, leaveMeta, saplingMeta);
    }

    private TreeTypes(Mods parentMod, ResourceLocation resBlockName, @Nullable ResourceLocation resLeavesName, @Nullable ResourceLocation resSaplingName, @Nullable int[] logMeta, int[] leaveMeta, Integer saplingMeta) {
        this(parentMod.modid, resBlockName, resLeavesName, resSaplingName, logMeta, leaveMeta, saplingMeta);
    }

    private TreeTypes(String parentModId, String resBlockName, @Nullable String resLeavesName, @Nullable String resSaplingName, @Nullable int[] logMeta, int[] leaveMeta, Integer saplingMeta) {
        this(parentModId, new ResourceLocation(parentModId, resBlockName), new ResourceLocation(parentModId, resLeavesName), new ResourceLocation(parentModId, resSaplingName), logMeta, leaveMeta, saplingMeta);
    }

    private TreeTypes(String parentModId, ResourceLocation resBlockName, @Nullable ResourceLocation resLeavesName, @Nullable ResourceLocation resSaplingName, @Nullable int[] logMeta, int[] leaveMeta, Integer saplingMeta) {
        this.parentModId = parentModId;
        this.resBlockName = resBlockName;
        this.resLeavesName = resLeavesName;
        this.resSaplingName = resSaplingName;
        this.load(logMeta, leaveMeta, saplingMeta);
    }

    private void load(@Nullable int[] logMeta, @Nullable int[] leaveMeta, @Nullable Integer saplingMeta) {
        IBlockState state;
        if (!Loader.isModLoaded((String)this.parentModId) && !this.parentModId.equals("minecraft")) {
            AstralSorcery.log.info("Not loading tree type " + this.name() + " as the mod " + this.parentModId + " is not loaded.");
            return;
        }
        Block log = (Block)ForgeRegistries.BLOCKS.getValue(this.resBlockName);
        Block leaf = (Block)ForgeRegistries.BLOCKS.getValue(this.resLeavesName);
        Block sapling = (Block)ForgeRegistries.BLOCKS.getValue(this.resSaplingName);
        if (this.isEmpty(log) || this.isEmpty(leaf) || this.isEmpty(sapling)) {
            AstralSorcery.log.info("Not loading tree type " + this.name() + " as its blocks don't exist in the currently loaded mods.");
            return;
        }
        this.logCheck = logMeta == null ? new BlockStateCheck.Block(log) : new BlockStateCheck.AnyMeta(log, logMeta);
        this.leavesCheck = leaveMeta == null ? new BlockStateCheck.Block(leaf) : new BlockStateCheck.AnyMeta(leaf, leaveMeta);
        BlockStateCheck blockStateCheck = this.saplingCheck = saplingMeta == null ? new BlockStateCheck.Block(sapling) : new BlockStateCheck.Meta(sapling, saplingMeta);
        if (logMeta == null) {
            this.logStates.add(log.func_176223_P());
        } else {
            for (int m : logMeta) {
                state = log.func_176203_a(m);
                if (this.logStates.contains(state)) continue;
                this.logStates.add(state);
            }
        }
        if (leaveMeta == null) {
            this.leaveStates.add(leaf.func_176223_P());
        } else {
            for (int m : leaveMeta) {
                state = leaf.func_176203_a(m);
                if (this.leaveStates.contains(state)) continue;
                this.leaveStates.add(state);
            }
        }
        this.saplingState = saplingMeta == null ? sapling.func_176223_P() : sapling.func_176203_a(saplingMeta.intValue());
        this.exists = true;
        AstralSorcery.log.info("Loaded " + this.name() + " of " + this.parentModId + " into tree registry.");
    }

    private boolean isEmpty(@Nullable Block block) {
        return block == null || block.equals(Blocks.field_150350_a);
    }

    public boolean exists() {
        return this.exists;
    }

    public Collection<IBlockState> getLeaveStates() {
        return this.leaveStates;
    }

    public Collection<IBlockState> getLogStates() {
        return this.logStates;
    }

    public IBlockState getSaplingState() {
        return this.saplingState;
    }

    public BlockStateCheck getLogCheck() {
        return this.logCheck;
    }

    public BlockStateCheck getLeavesCheck() {
        return this.leavesCheck;
    }

    public BlockStateCheck getSaplingCheck() {
        return this.saplingCheck;
    }

    @Nullable
    public static TreeTypes getTree(World world, BlockPos pos) {
        return TreeTypes.getTree(world, pos, world.func_180495_p(pos));
    }

    @Nullable
    public static TreeTypes getTree(World world, BlockPos pos, IBlockState blockToTest) {
        for (TreeTypes type : TreeTypes.values()) {
            if (!type.exists() || !type.logCheck.isStateValid(world, pos, blockToTest) && !type.leavesCheck.isStateValid(world, pos, blockToTest)) continue;
            return type;
        }
        return null;
    }

    public static void init() {
    }
}

