/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.GatewayCache;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktUpdateGateways;
import hellfirepvp.astralsorcery.common.util.FileStorageUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class CelestialGatewaySystem {
    private boolean startup = false;
    public static CelestialGatewaySystem instance = new CelestialGatewaySystem();
    private Map<Integer, List<GatewayCache.GatewayNode>> serverCache = new HashMap<Integer, List<GatewayCache.GatewayNode>>();
    private Map<Integer, List<GatewayCache.GatewayNode>> clientCache = new HashMap<Integer, List<GatewayCache.GatewayNode>>();

    private CelestialGatewaySystem() {
    }

    public GatewayWorldFilter getFilter() {
        File f = FileStorageUtil.getGeneralSubDirectory("gatewayFilter");
        File worldFilter = new File(f, "worldFilter.dat");
        if (!worldFilter.exists()) {
            try {
                worldFilter.createNewFile();
            }
            catch (IOException exc) {
                throw new IllegalStateException("Couldn't create plain world filter file! Are we missing file permissions?", exc);
            }
        }
        return new GatewayWorldFilter(worldFilter);
    }

    public void onServerStart() {
        this.startup = true;
        Integer[] worlds = DimensionManager.getStaticDimensionIDs();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        List<Integer> involved = this.getFilter().getInvolvedWorlds();
        for (Integer id : worlds) {
            if (id == null || !involved.contains(id)) continue;
            WorldServer world = server.func_71218_a(id.intValue());
            this.loadWorldCache((World)world);
            if (world.func_72863_F().func_73152_e() > 0 || ForgeChunkManager.getPersistentChunksFor((World)world).size() != 0 || world.field_73011_w.func_186058_p().shouldLoadSpawn()) continue;
            DimensionManager.unloadWorld((int)world.field_73011_w.getDimension());
        }
        this.startup = false;
        this.syncToAll();
    }

    @SubscribeEvent
    public void onWorldInit(WorldEvent.Load event) {
        if (this.startup) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        this.loadWorldCache(world);
        this.syncToAll();
    }

    public void syncTo(EntityPlayer pl) {
        PktUpdateGateways pkt = new PktUpdateGateways(this.serverCache);
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)pl);
    }

    public void syncToAll() {
        PktUpdateGateways pkt = new PktUpdateGateways(this.serverCache);
        PacketChannel.CHANNEL.sendToAll((IMessage)pkt);
    }

    public List<GatewayCache.GatewayNode> getGatewaysForWorld(World world, Side side) {
        return (side == Side.SERVER ? this.serverCache : this.clientCache).get(world.field_73011_w.getDimension());
    }

    public Map<Integer, List<GatewayCache.GatewayNode>> getGatewayCache(Side side) {
        return Collections.unmodifiableMap(side == Side.SERVER ? this.serverCache : this.clientCache);
    }

    public void addPosition(World world, GatewayCache.GatewayNode pos) {
        if (world.field_72995_K) {
            return;
        }
        Integer dim = world.field_73011_w.getDimension();
        if (!this.serverCache.containsKey(dim)) {
            this.forceLoad(dim);
        }
        if (!this.serverCache.containsKey(dim)) {
            AstralSorcery.log.info("Couldn't add position for world " + dim + "! - Force loading the world resulted in... nothing.");
            return;
        }
        this.getFilter().appendAndSave(dim);
        List<GatewayCache.GatewayNode> cache = this.serverCache.get(dim);
        if (!cache.contains((Object)pos)) {
            cache.add(pos);
            this.syncToAll();
        }
    }

    public void removePosition(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        Integer dim = world.field_73011_w.getDimension();
        if (!this.serverCache.containsKey(dim)) {
            return;
        }
        if (this.serverCache.get(dim).remove(pos)) {
            if (this.serverCache.get(dim).isEmpty()) {
                this.getFilter().removeAndSave(dim);
            }
            this.syncToAll();
        }
    }

    private void forceLoad(int dim) {
        WorldServer serv = DimensionManager.getWorld((int)dim);
        if (serv == null) {
            DimensionManager.initDimension((int)dim);
        }
    }

    public void updateClientCache(Map<Integer, List<GatewayCache.GatewayNode>> positions) {
        this.clientCache = positions;
    }

    private void loadWorldCache(World world) {
        GatewayCache cache = (GatewayCache)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.GATEWAY_DATA);
        this.serverCache.put(world.field_73011_w.getDimension(), cache.getGatewayPositions());
    }

    public static class GatewayWorldFilter {
        private final File gatewayCacheFile;
        private List<Integer> cache = null;

        private GatewayWorldFilter(File gatewayCacheFile) {
            this.gatewayCacheFile = gatewayCacheFile;
        }

        public List<Integer> getInvolvedWorlds() {
            if (this.cache == null) {
                this.loadCache();
            }
            return this.cache;
        }

        private void loadCache() {
            try {
                NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)this.gatewayCacheFile);
                NBTTagList list = tag.func_150295_c("list", 3);
                this.cache = Lists.newArrayList((Object[])new Integer[]{0});
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    Integer id = list.func_186858_c(i);
                    if (this.cache.contains(id)) continue;
                    this.cache.add(id);
                }
            }
            catch (IOException ignored) {
                this.cache = Lists.newArrayList((Object[])new Integer[]{0});
            }
        }

        private void appendAndSave(Integer id) {
            if (this.cache == null) {
                this.loadCache();
            }
            if (!this.cache.contains(id)) {
                this.cache.add(id);
                try {
                    NBTTagList list = new NBTTagList();
                    for (int dimId : this.cache) {
                        list.func_74742_a((NBTBase)new NBTTagInt(dimId));
                    }
                    NBTTagCompound cmp = new NBTTagCompound();
                    cmp.func_74782_a("list", (NBTBase)list);
                    CompressedStreamTools.func_74795_b((NBTTagCompound)cmp, (File)this.gatewayCacheFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void removeAndSave(Integer dim) {
            if (this.cache == null) {
                this.loadCache();
            }
            if (this.cache.contains(dim)) {
                this.cache.remove(dim);
                try {
                    NBTTagList list = new NBTTagList();
                    for (int dimId : this.cache) {
                        list.func_74742_a((NBTBase)new NBTTagInt(dimId));
                    }
                    NBTTagCompound cmp = new NBTTagCompound();
                    cmp.func_74782_a("list", (NBTBase)list);
                    CompressedStreamTools.func_74795_b((NBTTagCompound)cmp, (File)this.gatewayCacheFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

