/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal;

import hellfirepvp.astralsorcery.client.gui.journal.SizeHandler;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import java.awt.Point;
import javax.annotation.Nullable;

public class PerkTreeSizeHandler
extends SizeHandler {
    public PerkTreeSizeHandler(int height, int width) {
        super(height, width);
        this.setWidthHeightNodes(10);
        this.setSpaceBetweenNodes(10);
    }

    @Override
    @Nullable
    public int[] buildRequiredRectangle() {
        int leftMost = 0;
        int rightMost = 0;
        int upperMost = 0;
        int lowerMost = 0;
        for (PerkTreePoint point : PerkTree.PERK_TREE.getPerkPoints()) {
            Point offset = point.getOffset();
            int x = offset.x;
            int y = offset.y;
            if (x < leftMost) {
                leftMost = x;
            }
            if (x > rightMost) {
                rightMost = x;
            }
            if (y > lowerMost) {
                lowerMost = y;
            }
            if (y >= upperMost) continue;
            upperMost = y;
        }
        return new int[]{leftMost, rightMost, upperMost, lowerMost};
    }

    @Override
    public double clampX(double centerX) {
        if (centerX + this.widthToBorder > this.getTotalWidth()) {
            centerX = this.getTotalWidth() - this.widthToBorder;
        }
        if (centerX - this.widthToBorder < 0.0) {
            centerX = Math.min(this.widthToBorder, this.getMidX());
        }
        return centerX;
    }

    @Override
    public double clampY(double centerY) {
        if (centerY + this.heightToBorder > this.getTotalHeight()) {
            centerY = this.getTotalHeight() - this.heightToBorder;
        }
        if (centerY - this.heightToBorder < 0.0) {
            centerY = Math.min(this.heightToBorder, this.getMidY());
        }
        return centerY;
    }
}

