/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.client.data.KnowledgeFragmentData;
import hellfirepvp.astralsorcery.client.data.PersistentDataManager;
import hellfirepvp.astralsorcery.client.gui.GuiJournalConstellationCluster;
import hellfirepvp.astralsorcery.client.gui.GuiJournalKnowledgeIndex;
import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkTree;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.base.GuiWHScreen;
import hellfirepvp.astralsorcery.client.gui.journal.overlay.GuiJournalOverlayKnowledge;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.fragment.KnowledgeFragment;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public abstract class GuiScreenJournal
extends GuiWHScreen {
    public static final BindableResource textureResBlank = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijblankbook");
    public static final BindableResource textureResShell = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijspacebook");
    public static final BindableResource textureResShellCst = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijspaceconstellation");
    public static final BindableResource textureBookmark = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijbookmark");
    public static final BindableResource textureBookmarkStr = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijbookmarkstretched");
    public static final BindableResource textureKnBookmark = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiknowledgebookmark");
    public static final BindableResource textureKnBookmarkStr = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiknowledgebookmarkstretched");
    protected final int bookmarkIndex;
    protected Rectangle rectResearchBookmark;
    protected Rectangle rectConstellationBookmark;
    protected Rectangle rectPerkMapBookmark;
    protected Rectangle rectKnowledgeBookmark;
    protected Collection<KnowledgeFragment> fragmentList = null;
    protected Map<Rectangle, KnowledgeFragment> pageFragments = Maps.newHashMap();

    public GuiScreenJournal(int bookmarkIndex) {
        super(270, 420);
        this.bookmarkIndex = bookmarkIndex;
    }

    private void resolveFragments() {
        KnowledgeFragmentData data = (KnowledgeFragmentData)PersistentDataManager.INSTANCE.getData(PersistentDataManager.PersistentKey.KNOWLEDGE_FRAGMENTS);
        this.fragmentList = data.getFragmentsFor(this);
    }

    public void drawDefault(BindableResource background, Point mouse) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        this.field_73735_i += 100.0f;
        this.drawWHRect(background);
        this.drawBookmarks(this.field_73735_i, mouse);
        this.field_73735_i -= 100.0f;
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void drawBookmarks(float zLevel, Point mousePoint) {
        KnowledgeFragmentData data;
        IMajorConstellation attuned;
        if (this.fragmentList == null) {
            this.resolveFragments();
        }
        this.rectResearchBookmark = null;
        this.rectConstellationBookmark = null;
        this.rectPerkMapBookmark = null;
        this.rectKnowledgeBookmark = null;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double bookmarkWidth = 67.0;
        double bookmarkHeight = 15.0;
        double bookmarkGap = 18.0;
        double knBookmarkWidth = 83.0;
        double offsetX = (double)(this.guiLeft + this.guiWidth) - 17.25;
        double offsetY = this.guiTop + 20;
        this.rectResearchBookmark = this.drawBookmark(offsetX, offsetY, bookmarkWidth, bookmarkHeight, bookmarkWidth + (double)(this.bookmarkIndex == 0 ? 0 : 5), zLevel, "gui.journal.bm.research.name", -572662307, mousePoint, textureBookmark, textureBookmarkStr);
        if (!ResearchManager.clientProgress.getSeenConstellations().isEmpty()) {
            this.rectConstellationBookmark = this.drawBookmark(offsetX, offsetY += bookmarkGap, bookmarkWidth, bookmarkHeight, bookmarkWidth + (double)(this.bookmarkIndex == 1 ? 0 : 5), zLevel, "gui.journal.bm.constellations.name", -572662307, mousePoint, textureBookmark, textureBookmarkStr);
        }
        if ((attuned = ResearchManager.clientProgress.getAttunedConstellation()) != null) {
            this.rectPerkMapBookmark = this.drawBookmark(offsetX, offsetY += bookmarkGap, bookmarkWidth, bookmarkHeight, bookmarkWidth + (double)(this.bookmarkIndex == 2 ? 0 : 5), zLevel, "gui.journal.bm.perks.name", -572662307, mousePoint, textureBookmark, textureBookmarkStr);
        }
        if (!(data = (KnowledgeFragmentData)PersistentDataManager.INSTANCE.getData(PersistentDataManager.PersistentKey.KNOWLEDGE_FRAGMENTS)).getAllFragments().isEmpty()) {
            this.rectKnowledgeBookmark = this.drawBookmark(offsetX, offsetY += bookmarkGap, bookmarkWidth, bookmarkHeight, bookmarkWidth + (double)(this.bookmarkIndex == 3 ? 0 : 5), zLevel, "gui.journal.bm.knowledge.name", -572662307, mousePoint, textureBookmark, textureBookmarkStr);
        }
        offsetY += bookmarkGap / 2.0;
        this.pageFragments.clear();
        for (KnowledgeFragment frag : this.fragmentList) {
            if (!frag.isFullyPresent()) continue;
            Rectangle rctFragment = this.drawBookmark(offsetX, offsetY += bookmarkGap, knBookmarkWidth, bookmarkHeight, knBookmarkWidth + (double)(this.bookmarkIndex == 0 ? 0 : 5), zLevel, frag.getUnlocalizedBookmark(), -572662307, mousePoint, textureKnBookmark, textureKnBookmarkStr);
            this.pageFragments.put(rctFragment, frag);
        }
        GL11.glPopMatrix();
    }

    private Rectangle drawBookmark(double offsetX, double offsetY, double width, double height, double mouseOverWidth, float zLevel, String title, int titleRGBColor, Point mousePoint, AbstractRenderableTexture texture, AbstractRenderableTexture textureStretched) {
        TextureHelper.setActiveTextureToAtlasSprite();
        if (titleRGBColor == Color.WHITE.getRGB()) {
            this.field_146289_q.func_78276_b("", 0, 0, Color.BLACK.getRGB());
        } else {
            this.field_146289_q.func_78276_b("", 0, 0, Color.WHITE.getRGB());
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        texture.bindTexture();
        Rectangle r = new Rectangle(MathHelper.func_76128_c((double)offsetX), MathHelper.func_76128_c((double)offsetY), MathHelper.func_76128_c((double)width), MathHelper.func_76128_c((double)height));
        if (r.contains(mousePoint)) {
            if (mouseOverWidth > width) {
                textureStretched.bindTexture();
            }
            width = mouseOverWidth;
            r = new Rectangle(MathHelper.func_76128_c((double)offsetX), MathHelper.func_76128_c((double)offsetY), MathHelper.func_76128_c((double)width), MathHelper.func_76128_c((double)height));
        }
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(offsetX, offsetY + height, (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b(offsetX + width, offsetY + height, (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b(offsetX + width, offsetY, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b(offsetX, offsetY, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_78381_a();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + 2.0), (double)(offsetY + 4.0), (double)(zLevel + 50.0f));
        GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)title, (Object[])new Object[0]), 0, 0, titleRGBColor);
        GL11.glPopMatrix();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        return r;
    }

    protected boolean handleBookmarkClick(Point p) {
        return this.handleJournalNavigationBookmarkClick(p) || this.handleFragmentClick(p);
    }

    private boolean handleJournalNavigationBookmarkClick(Point p) {
        if (this.bookmarkIndex != 0 && this.rectResearchBookmark != null && this.rectResearchBookmark.contains(p)) {
            GuiJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalProgression.getJournalInstance());
            return true;
        }
        if (this.bookmarkIndex != 1 && this.rectConstellationBookmark != null && this.rectConstellationBookmark.contains(p)) {
            GuiJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalConstellationCluster.getConstellationScreen());
            return true;
        }
        if (this.bookmarkIndex != 2 && this.rectPerkMapBookmark != null && this.rectPerkMapBookmark.contains(p)) {
            GuiJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalPerkTree());
            return true;
        }
        if (this.bookmarkIndex != 3 && this.rectKnowledgeBookmark != null && this.rectKnowledgeBookmark.contains(p)) {
            GuiJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalKnowledgeIndex());
            return true;
        }
        return false;
    }

    private boolean handleFragmentClick(Point mouse) {
        for (Rectangle r : this.pageFragments.keySet()) {
            if (!r.contains(mouse)) continue;
            KnowledgeFragment frag = this.pageFragments.get(r);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalOverlayKnowledge(this, frag));
            SoundHelper.playSoundClient(Sounds.bookFlip, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean func_73868_f() {
        return false;
    }
}

