/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal;

import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.journal.GalaxySizeHandler;
import hellfirepvp.astralsorcery.client.gui.journal.GuiProgressionClusterRenderer;
import hellfirepvp.astralsorcery.client.gui.journal.GuiRenderBoundingBox;
import hellfirepvp.astralsorcery.client.gui.journal.ScalingPoint;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.mappings.ClientJournalMapping;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiProgressionRenderer {
    private static final BindableResource textureResBack = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiresbg");
    private static final BindableResource textureResOVL = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijresoverlay");
    private GalaxySizeHandler sizeHandler;
    private GuiJournalProgression parentGui;
    public GuiRenderBoundingBox realRenderBox;
    private int realCoordLowerX;
    private int realCoordLowerY;
    private int realRenderWidth;
    private int realRenderHeight;
    private ScalingPoint mousePointScaled;
    private ScalingPoint previousMousePointScaled;
    private ResearchProgression focusedClusterZoom = null;
    private ResearchProgression focusedClusterMouse = null;
    private GuiProgressionClusterRenderer clusterRenderer = null;
    private long doubleClickLast = 0L;
    private boolean hasPrevOffset = false;
    private Map<Rectangle, ResearchProgression> clusterRectMap = new HashMap<Rectangle, ResearchProgression>();

    public GuiProgressionRenderer(GuiJournalProgression gui, int guiHeight, int guiWidth) {
        this.parentGui = gui;
        this.sizeHandler = new GalaxySizeHandler(guiHeight, guiWidth);
        this.refreshSize();
        this.mousePointScaled = ScalingPoint.createPoint(this.sizeHandler.clampX(this.sizeHandler.getMidX()), this.sizeHandler.clampY(this.sizeHandler.getMidY()), this.sizeHandler.getScalingFactor(), false);
        this.moveMouse(this.sizeHandler.getTotalWidth() / 2.0, this.sizeHandler.getTotalHeight() / 2.0);
        this.applyMovedMouseOffset();
    }

    public void refreshSize() {
        this.sizeHandler.updateSize();
    }

    public void setBox(int left, int top, int right, int bottom) {
        this.realRenderBox = new GuiRenderBoundingBox(left, top, right, bottom);
        this.realRenderWidth = (int)this.realRenderBox.getWidth();
        this.realRenderHeight = (int)this.realRenderBox.getHeight();
    }

    public void moveMouse(double changedX, double changedY) {
        if (this.sizeHandler.getScalingFactor() >= 6.1 && this.clusterRenderer != null) {
            this.clusterRenderer.moveMouse(changedX, changedY);
        } else if (this.hasPrevOffset) {
            this.mousePointScaled.updateScaledPos(this.sizeHandler.clampX(this.previousMousePointScaled.getScaledPosX() + changedX), this.sizeHandler.clampY(this.previousMousePointScaled.getScaledPosY() + changedY), this.sizeHandler.getScalingFactor());
        } else {
            this.mousePointScaled.updateScaledPos(this.sizeHandler.clampX(changedX), this.sizeHandler.clampY(changedY), this.sizeHandler.getScalingFactor());
        }
    }

    public void applyMovedMouseOffset() {
        if (this.sizeHandler.getScalingFactor() >= 6.1 && this.clusterRenderer != null) {
            this.clusterRenderer.applyMovedMouseOffset();
        } else {
            this.previousMousePointScaled = ScalingPoint.createPoint(this.mousePointScaled.getScaledPosX(), this.mousePointScaled.getScaledPosY(), this.sizeHandler.getScalingFactor(), true);
            this.hasPrevOffset = true;
        }
    }

    public void updateOffset(int guiLeft, int guiTop) {
        this.realCoordLowerX = guiLeft;
        this.realCoordLowerY = guiTop;
    }

    public void centerMouse() {
        this.moveMouse((double)this.parentGui.getGuiLeft() + this.sizeHandler.getMidX(), (double)this.parentGui.getGuiTop() + this.sizeHandler.getMidY());
    }

    public void updateMouseState() {
        this.moveMouse(0.0, 0.0);
    }

    public void unfocus() {
        this.focusedClusterZoom = null;
    }

    public void focus(@Nonnull ResearchProgression researchCluster) {
        this.focusedClusterZoom = researchCluster;
        this.clusterRenderer = new GuiProgressionClusterRenderer(researchCluster, this.realRenderHeight, this.realRenderWidth, this.realCoordLowerX, this.realCoordLowerY);
    }

    public void propagateClick(Point p) {
        if (this.clusterRenderer != null && this.sizeHandler.getScalingFactor() > 6.0) {
            this.clusterRenderer.propagateClick(this.parentGui, p);
            return;
        }
        if (this.focusedClusterMouse != null && this.sizeHandler.getScalingFactor() <= 6.0) {
            long current = System.currentTimeMillis();
            if (current - this.doubleClickLast < 400L) {
                for (int timeout = 500; this.focusedClusterMouse != null && this.sizeHandler.getScalingFactor() < 9.9 && timeout > 0; --timeout) {
                    this.handleZoomIn(p);
                }
                this.doubleClickLast = 0L;
            }
            this.doubleClickLast = current;
        }
    }

    public void drawMouseHighlight(float zLevel, Point mousePoint) {
        if (this.clusterRenderer != null && this.sizeHandler.getScalingFactor() > 6.0) {
            this.clusterRenderer.drawMouseHighlight(zLevel, mousePoint);
        }
    }

    public void resetZoom() {
        this.sizeHandler.resetZoom();
        this.rescale(this.sizeHandler.getScalingFactor());
    }

    public void handleZoomOut() {
        this.sizeHandler.handleZoomOut();
        this.rescale(this.sizeHandler.getScalingFactor());
        if (this.sizeHandler.getScalingFactor() <= 4.0) {
            this.unfocus();
        } else if (this.sizeHandler.getScalingFactor() >= 6.0 && this.clusterRenderer != null) {
            this.clusterRenderer.handleZoomOut();
        }
    }

    public void handleZoomIn(Point mouse) {
        double scale = this.sizeHandler.getScalingFactor();
        if (scale >= 4.0) {
            ResearchProgression prog;
            if (this.focusedClusterZoom == null && (prog = this.tryFocusCluster(mouse)) != null) {
                this.focus(prog);
            }
            if (this.focusedClusterZoom == null) {
                return;
            }
            if (scale < 6.1) {
                double vDiv = (2.0 - (scale - 4.0)) * 10.0;
                Rectangle2D rect = this.calcBoundingRectangle(this.focusedClusterZoom);
                Vector3 center = new Vector3(rect.getCenterX(), rect.getCenterY(), 0.0);
                Vector3 mousePos = new Vector3(this.mousePointScaled.getScaledPosX(), this.mousePointScaled.getScaledPosY(), 0.0);
                Vector3 dir = center.subtract(mousePos);
                if (vDiv > 0.05) {
                    dir.divide(vDiv);
                }
                if (!this.hasPrevOffset) {
                    this.mousePointScaled.updateScaledPos(this.sizeHandler.clampX(mousePos.getX() + dir.getX()), this.sizeHandler.clampY(mousePos.getY() + dir.getY()), this.sizeHandler.getScalingFactor());
                } else {
                    this.previousMousePointScaled.updateScaledPos(this.sizeHandler.clampX(mousePos.getX() + dir.getX()), this.sizeHandler.clampY(mousePos.getY() + dir.getY()), this.sizeHandler.getScalingFactor());
                }
                this.updateMouseState();
            } else if (this.clusterRenderer != null) {
                this.clusterRenderer.handleZoomIn();
            }
        }
        this.sizeHandler.handleZoomIn();
        this.rescale(this.sizeHandler.getScalingFactor());
    }

    private void rescale(double newScale) {
        this.mousePointScaled.rescale(newScale);
        if (this.previousMousePointScaled != null) {
            this.previousMousePointScaled.rescale(newScale);
        }
        this.updateMouseState();
    }

    public void drawProgressionPart(float zLevel, Point mouse) {
        ClientJournalMapping.JournalCluster cluster;
        this.drawBaseBackground(zLevel);
        this.drawClusters(zLevel);
        this.focusedClusterMouse = this.tryFocusCluster(mouse);
        double scaleX = this.mousePointScaled.getPosX();
        double scaleY = this.mousePointScaled.getPosY();
        if (this.sizeHandler.getScalingFactor() >= 6.1 && this.focusedClusterZoom != null && this.clusterRenderer != null) {
            cluster = ClientJournalMapping.getClusterMapping(this.focusedClusterZoom);
            this.drawClusterBackground(cluster.clusterBackgroundTexture, zLevel);
            this.clusterRenderer.drawClusterScreen(zLevel);
            scaleX = this.clusterRenderer.getScaleMouseX();
            scaleY = this.clusterRenderer.getScaleMouseY();
        }
        if (this.focusedClusterMouse != null && (cluster = ClientJournalMapping.getClusterMapping(this.focusedClusterMouse)) != null) {
            double lX = this.sizeHandler.evRelativePosX(cluster.leftMost);
            double rX = this.sizeHandler.evRelativePosX(cluster.rightMost);
            double lY = this.sizeHandler.evRelativePosY(cluster.upperMost);
            double rY = this.sizeHandler.evRelativePosY(cluster.lowerMost);
            double scaledLeft = this.mousePointScaled.getScaledPosX() - this.sizeHandler.widthToBorder;
            double scaledTop = this.mousePointScaled.getScaledPosY() - this.sizeHandler.heightToBorder;
            double xAdd = lX - scaledLeft;
            double yAdd = lY - scaledTop;
            double offsetX = (double)this.realCoordLowerX + xAdd;
            double offsetY = (double)this.realCoordLowerY + yAdd;
            double scale = this.sizeHandler.getScalingFactor();
            float br = 1.0f;
            if (scale > 8.01) {
                br = 0.0f;
            } else if (scale >= 6.0) {
                br = (float)(1.0 - (scale - 6.0) / 2.0);
            }
            String name = this.focusedClusterMouse.getUnlocalizedName();
            name = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            TextureHelper.refreshTextureBindState();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(offsetX + (rX - lX) / 2.0), (double)(offsetY + (rY - lY) / 3.0), (double)0.0);
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int width = fr.func_78256_a(name);
            GL11.glTranslated((double)(-width / 2), (double)0.0, (double)0.0);
            GL11.glScaled((double)1.4, (double)1.4, (double)1.4);
            int alpha = 204;
            alpha = (int)((float)alpha * br);
            alpha = Math.max(alpha, 5);
            int color = 0x5A28FF | alpha << 24;
            fr.func_175063_a(name, 0.0f, 0.0f, color);
            GL11.glPopMatrix();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
        }
        this.drawBlendedStarfieldLayers(scaleX, scaleY, zLevel);
    }

    @Nullable
    private ResearchProgression tryFocusCluster(Point mouse) {
        for (Rectangle r : this.clusterRectMap.keySet()) {
            if (!r.contains(mouse)) continue;
            return this.clusterRectMap.get(r);
        }
        return null;
    }

    private Rectangle2D calcBoundingRectangle(ResearchProgression progression) {
        ClientJournalMapping.JournalCluster cluster = ClientJournalMapping.getClusterMapping(progression);
        double lX = this.sizeHandler.evRelativePosX(cluster.leftMost);
        double rX = this.sizeHandler.evRelativePosX(cluster.rightMost);
        double lY = this.sizeHandler.evRelativePosY(cluster.upperMost);
        double rY = this.sizeHandler.evRelativePosY(cluster.lowerMost);
        return new Rectangle2D.Double(lX, lY, rX - lX, rY - lY);
    }

    private void drawClusters(float zLevel) {
        this.clusterRectMap.clear();
        if (this.sizeHandler.getScalingFactor() >= 8.01) {
            return;
        }
        PlayerProgress thisProgress = ResearchManager.clientProgress;
        for (ResearchProgression progress : thisProgress.getResearchProgression()) {
            ClientJournalMapping.JournalCluster cluster = ClientJournalMapping.getClusterMapping(progress);
            double lX = this.sizeHandler.evRelativePosX(cluster.leftMost);
            double rX = this.sizeHandler.evRelativePosX(cluster.rightMost);
            double lY = this.sizeHandler.evRelativePosY(cluster.upperMost);
            double rY = this.sizeHandler.evRelativePosY(cluster.lowerMost);
            this.renderCluster(progress, cluster, lX, lY, rX, rY, zLevel);
        }
    }

    private void renderCluster(ResearchProgression p, ClientJournalMapping.JournalCluster cluster, double lowerPosX, double lowerPosY, double higherPosX, double higherPosY, float zLevel) {
        double scaledLeft = this.mousePointScaled.getScaledPosX() - this.sizeHandler.widthToBorder;
        double scaledTop = this.mousePointScaled.getScaledPosY() - this.sizeHandler.heightToBorder;
        double xAdd = lowerPosX - scaledLeft;
        double yAdd = lowerPosY - scaledTop;
        double offsetX = (double)this.realCoordLowerX + xAdd;
        double offsetY = (double)this.realCoordLowerY + yAdd;
        GL11.glPushMatrix();
        GL11.glTranslated((double)offsetX, (double)offsetY, (double)0.0);
        double width = higherPosX - lowerPosX;
        double height = higherPosY - lowerPosY;
        Rectangle r = new Rectangle(MathHelper.func_76128_c((double)offsetX), MathHelper.func_76128_c((double)offsetY), MathHelper.func_76128_c((double)width), MathHelper.func_76128_c((double)height));
        this.clusterRectMap.put(r, p);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        cluster.cloudTexture.bind();
        double scale = this.sizeHandler.getScalingFactor();
        float br = 1.0f;
        if (scale > 8.01) {
            br = 0.0f;
        } else if (scale >= 6.0) {
            br = (float)(1.0 - (scale - 6.0) / 2.0);
        }
        GL11.glColor4f((float)br, (float)br, (float)br, (float)br);
        Blending.ADDITIVEDARK.apply();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(0.0, height, (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b(width, height, (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b(width, 0.0, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b(0.0, 0.0, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        t.func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPopMatrix();
    }

    private void drawBlendedStarfieldLayers(double scalePosX, double scalePosY, float zLevel) {
        this.drawBlendedStarfieldOverlay(zLevel, scalePosX, scalePosY, 1.5);
        this.drawBlendedStarfieldOverlay(zLevel, scalePosX, scalePosY, 2.5);
        this.drawBlendedStarfieldOverlay(zLevel, scalePosX, scalePosY, 3.5);
    }

    private void drawClusterBackground(BindableResource tex, float zLevel) {
        double scale = this.sizeHandler.getScalingFactor();
        float br = 0.0f;
        if (scale > 8.01) {
            br = 1.0f;
        } else if (scale >= 6.0) {
            br = (float)((scale - 6.0) / 2.0);
        }
        GL11.glColor4f((float)(br *= 0.75f), (float)br, (float)br, (float)br);
        tex.bind();
        Blending.ADDITIVEDARK.apply();
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)this.realCoordLowerX, (double)(this.realCoordLowerY + this.realRenderHeight), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.realCoordLowerX + this.realRenderWidth), (double)(this.realCoordLowerY + this.realRenderHeight), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.realCoordLowerX + this.realRenderWidth), (double)this.realCoordLowerY, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)this.realCoordLowerX, (double)this.realCoordLowerY, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawBaseBackground(float zLevel) {
        float br = 0.5f;
        GL11.glColor4f((float)br, (float)br, (float)br, (float)1.0f);
        GL11.glDisable((int)3042);
        textureResBack.bind();
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)this.realCoordLowerX, (double)(this.realCoordLowerY + this.realRenderHeight), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.realCoordLowerX + this.realRenderWidth), (double)(this.realCoordLowerY + this.realRenderHeight), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.realCoordLowerX + this.realRenderWidth), (double)this.realCoordLowerY, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)this.realCoordLowerX, (double)this.realCoordLowerY, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawBlendedStarfieldOverlay(float zLevel, double scalePosX, double scalePosY, double scaleFactor) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
        GL11.glPushMatrix();
        GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
        textureResOVL.bind();
        double th = this.sizeHandler.getTotalHeight() / this.sizeHandler.getScalingFactor();
        double tw = this.sizeHandler.getTotalWidth() / this.sizeHandler.getScalingFactor();
        double lowU = (scalePosX - this.sizeHandler.widthToBorder) / tw;
        double highU = lowU + (double)this.realRenderWidth / tw;
        double lowV = (scalePosY - this.sizeHandler.heightToBorder) / th;
        double highV = lowV + (double)this.realRenderHeight / th;
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(0.0, (double)this.realRenderHeight, (double)zLevel).func_187315_a(lowU, highV).func_181675_d();
        vb.func_181662_b((double)this.realRenderWidth, (double)this.realRenderHeight, (double)zLevel).func_187315_a(highU, highV).func_181675_d();
        vb.func_181662_b((double)this.realRenderWidth, 0.0, (double)zLevel).func_187315_a(highU, lowV).func_181675_d();
        vb.func_181662_b(0.0, 0.0, (double)zLevel).func_187315_a(lowU, lowV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

