/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.journal.GuiRenderBoundingBox;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.gui.journal.PerkTreeSizeHandler;
import hellfirepvp.astralsorcery.client.gui.journal.ScalingPoint;
import hellfirepvp.astralsorcery.client.gui.journal.SizeHandler;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.GuiTextEntry;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.useables.ItemPerkSeal;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktRequestPerkSealAction;
import hellfirepvp.astralsorcery.common.network.packet.client.PktUnlockPerk;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiJournalPerkTree
extends GuiScreenJournal {
    private static final AbstractRenderableTexture textureResBack = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiresbg2");
    private static final AbstractRenderableTexture texturePerkConnection = AssetLibrary.loadTexture(AssetLoader.TextureLocation.EFFECT, "connectionperks");
    private static final AbstractRenderableTexture textureSearchTextBG = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijtextarea");
    private static final AbstractRenderableTexture textureSearchMark = SpriteLibrary.spriteHalo4;
    private static Rectangle rectSealBox = new Rectangle(29, 16, 16, 16);
    private SizeHandler sizeHandler;
    private GuiRenderBoundingBox guiBox;
    private ScalingPoint mousePosition;
    private ScalingPoint previousMousePosition;
    private int mouseBufferX;
    private int mouseBufferY;
    private boolean mouseDragging = false;
    private AbstractPerk unlockPrimed = null;
    private AbstractPerk sealBreakPrimed = null;
    private int tickSealBreak = 0;
    private int guiOffsetX;
    private int guiOffsetY;
    public boolean expectReinit = false;
    private Map<AbstractPerk, Rectangle2D.Double> thisFramePerks = new HashMap<AbstractPerk, Rectangle2D.Double>();
    private Map<AbstractPerk, Long> unlockEffects = new HashMap<AbstractPerk, Long>();
    private Map<AbstractPerk, Long> breakEffects = new HashMap<AbstractPerk, Long>();
    private GuiTextEntry searchTextEntry = new GuiTextEntry();
    private List<AbstractPerk> searchMatches = Lists.newArrayList();
    private ItemStack mouseSealStack = ItemStack.field_190927_a;
    private ItemStack foundSeals = ItemStack.field_190927_a;

    public GuiJournalPerkTree() {
        super(2);
        this.closeWithInventoryKey = false;
        this.searchTextEntry.setChangeCallback(this::updateSearchHighlight);
        this.buildTree();
    }

    private void buildTree() {
        this.guiBox = new GuiRenderBoundingBox(10.0, 10.0, this.guiWidth - 10, this.guiHeight - 10);
        this.sizeHandler = new PerkTreeSizeHandler(this.guiHeight - 40, this.guiWidth - 20);
        this.sizeHandler.setScaleSpeed(0.04f);
        this.sizeHandler.setMaxScale(1.0);
        this.sizeHandler.setMinScale(0.1f);
        this.sizeHandler.updateSize();
        this.mousePosition = ScalingPoint.createPoint(0.0, 0.0, this.sizeHandler.getScalingFactor(), false);
    }

    @Override
    public void func_73866_w_() {
        AbstractPerk root;
        IMajorConstellation attunement;
        super.func_73866_w_();
        this.guiOffsetX = this.guiLeft + 10;
        this.guiOffsetY = this.guiTop + 10;
        if (this.expectReinit) {
            this.expectReinit = false;
            return;
        }
        boolean shifted = false;
        PlayerProgress progress = ResearchManager.clientProgress;
        if (progress != null && (attunement = progress.getAttunedConstellation()) != null && (root = PerkTree.PERK_TREE.getRootPerk(attunement)) != null) {
            Point2D.Double shift = this.sizeHandler.evRelativePos(root.getOffset());
            this.moveMouse(MathHelper.func_76128_c((double)shift.x), MathHelper.func_76128_c((double)shift.y));
            shifted = true;
        }
        if (!shifted) {
            this.moveMouse(MathHelper.func_76128_c((double)(this.sizeHandler.getTotalWidth() / 2.0)), MathHelper.func_76128_c((double)(this.sizeHandler.getTotalHeight() / 2.0)));
        }
        this.applyMovedMouseOffset();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.thisFramePerks.clear();
        int dWheelChange = Mouse.getDWheel();
        if (dWheelChange < 0) {
            this.sizeHandler.handleZoomOut();
            this.rescaleMouse();
        }
        if (dWheelChange > 0) {
            this.sizeHandler.handleZoomIn();
            this.rescaleMouse();
        }
        this.handleMouseMovement(mouseX, mouseY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GL11.glEnable((int)3042);
        Blending.DEFAULT.applyStateManager();
        Blending.DEFAULT.apply();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawDefault(textureResShell, new Point(mouseX, mouseY));
        this.drawBackground(this.field_73735_i - 50.0f);
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((this.guiLeft + 27) * res.func_78325_e()), (int)((this.guiTop + 27) * res.func_78325_e()), (int)((this.guiWidth - 54) * res.func_78325_e()), (int)((this.guiHeight - 54) * res.func_78325_e()));
        this.drawPerkTree(partialTicks);
        GL11.glDisable((int)3089);
        this.drawSearchBox();
        this.drawMiscInfo();
        this.drawSealBox();
        this.drawHoverTooltips(mouseX, mouseY);
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        if (!this.mouseSealStack.func_190926_b()) {
            GlStateManager.func_179097_i();
            this.field_146296_j.func_180450_b(this.mouseSealStack, mouseX - 8, mouseY - 8);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179121_F();
    }

    public void func_73876_c() {
        int count;
        super.func_73876_c();
        this.foundSeals = Minecraft.func_71410_x().field_71439_g != null ? ((count = ItemPerkSeal.getPlayerSealCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) > 0 ? new ItemStack((Item)ItemsAS.perkSeal, count) : ItemStack.field_190927_a) : ItemStack.field_190927_a;
        --this.tickSealBreak;
        if (this.tickSealBreak <= 0) {
            this.tickSealBreak = 0;
            this.sealBreakPrimed = null;
        }
    }

    private void drawSealBox() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        BindableResource tex = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "gridslot");
        ((AbstractRenderableTexture)tex).bindTexture();
        this.drawTexturedRect((double)(this.guiLeft + GuiJournalPerkTree.rectSealBox.x - 1), (double)(this.guiTop + GuiJournalPerkTree.rectSealBox.y - 1), (double)(GuiJournalPerkTree.rectSealBox.width + 2), (double)(GuiJournalPerkTree.rectSealBox.height + 2), tex);
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        if (!this.foundSeals.func_190926_b()) {
            this.field_146296_j.func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, this.foundSeals, this.guiLeft + GuiJournalPerkTree.rectSealBox.x, this.guiTop + GuiJournalPerkTree.rectSealBox.y);
            this.field_146296_j.func_180453_a(this.field_146289_q, this.foundSeals, this.guiLeft + GuiJournalPerkTree.rectSealBox.x, this.guiTop + GuiJournalPerkTree.rectSealBox.y, null);
        }
    }

    private void drawMiscInfo() {
        PlayerProgress prog = ResearchManager.clientProgress;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (prog.getAttunedConstellation() != null && prog.getAvailablePerkPoints() > 0) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + 50), (float)(this.guiTop + 18), (float)0.0f);
            this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"perk.info.points", (Object[])new Object[]{prog.getAvailablePerkPoints()}), 0.0f, 0.0f, new Color(0xCCCCCC).getRGB(), false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
            GlStateManager.func_179121_F();
            GlStateManager.func_179141_d();
            GlStateManager.func_179126_j();
        }
    }

    private void drawSearchBox() {
        boolean addDots;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLeft + 300), (float)(this.guiTop + 16), (float)0.0f);
        textureSearchTextBG.bindTexture();
        this.drawTexturedRectAtCurrentPos(88.5, 15.0);
        String text = this.searchTextEntry.getText();
        int length = this.field_146289_q.func_78256_a(text);
        boolean bl = addDots = length > 75;
        while (length > 75) {
            text = text.substring(1, text.length());
            length = this.field_146289_q.func_78256_a("..." + text);
        }
        if (addDots) {
            text = "..." + text;
        }
        if (ClientScheduler.getClientTick() % 20L > 10L) {
            text = text + "_";
        }
        GlStateManager.func_179109_b((float)4.0f, (float)4.0f, (float)0.0f);
        this.field_146289_q.func_175065_a(text, 0.0f, 0.0f, new Color(0xCCCCCC).getRGB(), false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179121_F();
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
    }

    private void rescaleMouse() {
        this.mousePosition.rescale(this.sizeHandler.getScalingFactor());
        if (this.previousMousePosition != null) {
            this.previousMousePosition.rescale(this.sizeHandler.getScalingFactor());
        }
        this.moveMouse(0, 0);
    }

    private void drawHoverTooltips(int mouseX, int mouseY) {
        if (!this.foundSeals.func_190926_b() && rectSealBox.contains(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            List toolTip = this.foundSeals.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            toolTip.add("");
            toolTip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"perk.info.sealed.usage", (Object[])new Object[0]));
            RenderingUtils.renderBlueTooltip(mouseX, mouseY, toolTip, Minecraft.func_71410_x().field_71466_p);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            for (Map.Entry<AbstractPerk, Rectangle2D.Double> rctPerk : this.thisFramePerks.entrySet()) {
                Collection<String> modInfo;
                String loc;
                if (!rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop)) continue;
                LinkedList<String> toolTip = new LinkedList<String>();
                AbstractPerk perk = rctPerk.getKey();
                PlayerProgress prog = ResearchManager.clientProgress;
                toolTip.add(perk.getCategory().getTextFormatting() + I18n.func_135052_a((String)(perk.getUnlocalizedName() + ".name"), (Object[])new Object[0]));
                perk.getLocalizedTooltip().forEach(line -> toolTip.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC.toString() + line));
                toolTip.add("");
                if (prog.isPerkSealed(perk)) {
                    toolTip.add(TextFormatting.RED + I18n.func_135052_a((String)"perk.info.sealed", (Object[])new Object[0]));
                    toolTip.add(TextFormatting.RED + I18n.func_135052_a((String)"perk.info.sealed.break", (Object[])new Object[0]));
                } else if (prog.hasPerkUnlocked(perk)) {
                    toolTip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"perk.info.active", (Object[])new Object[0]));
                } else if (perk.mayUnlockPerk(prog)) {
                    toolTip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"perk.info.available", (Object[])new Object[0]));
                } else {
                    toolTip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"perk.info.locked", (Object[])new Object[0]));
                }
                if (Minecraft.func_71410_x().field_71474_y.field_82882_x && (loc = perk.getCategory().getLocalizedName()) != null) {
                    toolTip.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC.toString() + "[" + loc + "]");
                }
                if ((modInfo = perk.getSource()) != null) {
                    for (String line2 : modInfo) {
                        toolTip.add(TextFormatting.BLUE.toString() + TextFormatting.ITALIC.toString() + line2);
                    }
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                    toolTip.add("");
                    toolTip.add(TextFormatting.GRAY + perk.getRegistryName().toString());
                }
                RenderingUtils.renderBlueTooltip(mouseX, mouseY, toolTip, Minecraft.func_71410_x().field_71466_p);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
        }
        GL11.glEnable((int)3008);
        GlStateManager.func_179141_d();
    }

    private void drawPerkTree(float partialTicks) {
        texturePerkConnection.bindTexture();
        for (Tuple<AbstractPerk, AbstractPerk> perkConnection : PerkTree.PERK_TREE.getConnections()) {
            PerkTreePoint.AllocationStatus status = PerkTreePoint.AllocationStatus.UNALLOCATED;
            PlayerProgress progress = ResearchManager.getProgress((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
            if (progress != null) {
                int alloc = 0;
                if (progress.hasPerkUnlocked((AbstractPerk)perkConnection.key)) {
                    ++alloc;
                }
                if (progress.hasPerkUnlocked((AbstractPerk)perkConnection.value)) {
                    ++alloc;
                }
                status = alloc == 2 ? PerkTreePoint.AllocationStatus.ALLOCATED : (alloc == 1 && progress.hasFreeAllocationPoint() ? PerkTreePoint.AllocationStatus.UNLOCKABLE : PerkTreePoint.AllocationStatus.UNALLOCATED);
            }
            Point offsetOne = ((AbstractPerk)perkConnection.key).getPoint().getOffset();
            Point offsetTwo = ((AbstractPerk)perkConnection.value).getPoint().getOffset();
            Point2D.Double shiftOne = this.sizeHandler.evRelativePos(offsetOne);
            Point2D.Double shiftTwo = this.sizeHandler.evRelativePos(offsetTwo);
            this.drawConnection(status, shiftOne, shiftTwo, partialTicks, ClientScheduler.getClientTick() + (long)offsetOne.x + (long)offsetOne.y + (long)offsetTwo.x + (long)offsetTwo.y);
        }
        ArrayList drawHighlight = Lists.newArrayList();
        for (PerkTreePoint perkPoint : PerkTree.PERK_TREE.getPerkPoints()) {
            double y;
            Point offset = perkPoint.getOffset();
            double x = this.sizeHandler.evRelativePosX(offset.x);
            Rectangle2D.Double perkRect = this.drawPerk(perkPoint, x, y = this.sizeHandler.evRelativePosY(offset.y), partialTicks, ClientScheduler.getClientTick() + (long)offset.x + (long)offset.y, ResearchManager.clientProgress.isPerkSealed(perkPoint.getPerk()), drawHighlight);
            if (perkRect == null) continue;
            this.thisFramePerks.put(perkPoint.getPerk(), perkRect);
        }
        drawHighlight.forEach(Runnable::run);
        this.unlockEffects.keySet().removeIf(perk -> !this.drawPerkUnlock((AbstractPerk)perk, this.unlockEffects.get(perk)));
        this.breakEffects.keySet().removeIf(perk -> !this.drawPerkSealBreak((AbstractPerk)perk, this.breakEffects.get(perk), partialTicks));
        TextureHelper.refreshTextureBindState();
    }

    private boolean drawPerkSealBreak(AbstractPerk perk, long tick, float pTicks) {
        SpriteSheetResource sprite;
        int count = (int)(ClientScheduler.getClientTick() - tick);
        if (count >= (sprite = SpriteLibrary.spriteBurstEffect3).getFrameCount()) {
            return false;
        }
        Point2D.Double oPos = this.sizeHandler.evRelativePos(perk.getOffset());
        Point2D.Double offset = this.shift2DOffset(oPos.x, oPos.y);
        float sealFade = 1.0f - ((float)count + pTicks) / (float)sprite.getFrameCount();
        double width = 22.0;
        Rectangle2D.Double rct = this.thisFramePerks.get(perk);
        if (rct != null) {
            width = rct.width;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)offset.x, (double)offset.y, (double)0.0);
        Point pOffset = perk.getPoint().getOffset();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(sealFade * 0.75f));
        perk.getPoint().renderSealAtCurrentPos(width *= 0.75, ClientScheduler.getClientTick() + (long)pOffset.x + (long)pOffset.y, pTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        GlStateManager.func_179118_c();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        sprite.bindTexture();
        Vector3 starVec = new Vector3(-width, -width, 0.0);
        double uLength = sprite.getUWidth();
        double vLength = sprite.getVWidth();
        Tuple<Double, Double> off = sprite.getUVOffset(count);
        Point2D.Double frameUV = new Point2D.Double((Double)off.key, (Double)off.value);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(width * (double)u * 2.0).addY(width * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(frameUV.x + uLength * (double)u, frameUV.y + vLength * (double)v).func_181675_d();
        }
        tes.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureHelper.refreshTextureBindState();
        return true;
    }

    private boolean drawPerkUnlock(AbstractPerk perk, long tick) {
        SpriteSheetResource sprite;
        int count = (int)(ClientScheduler.getClientTick() - tick);
        if (count >= (sprite = SpriteLibrary.spritePerkActivate).getFrameCount()) {
            return false;
        }
        Point2D.Double oPos = this.sizeHandler.evRelativePos(perk.getOffset());
        Point2D.Double offset = this.shift2DOffset(oPos.x, oPos.y);
        double width = 22.0;
        Rectangle2D.Double rct = this.thisFramePerks.get(perk);
        if (rct != null) {
            width = rct.width;
        }
        width *= 2.5;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        sprite.bindTexture();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)offset.x, (double)offset.y, (double)0.0);
        Vector3 starVec = new Vector3(-width, -width, 0.0);
        double uLength = sprite.getUWidth();
        double vLength = sprite.getVWidth();
        Tuple<Double, Double> off = sprite.getUVOffset(count);
        Point2D.Double frameUV = new Point2D.Double((Double)off.key, (Double)off.value);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(width * (double)u * 2.0).addY(width * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(frameUV.x + uLength * (double)u, frameUV.y + vLength * (double)v).func_181675_d();
        }
        GlStateManager.func_179118_c();
        tes.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
        TextureHelper.refreshTextureBindState();
        return true;
    }

    private void drawConnection(PerkTreePoint.AllocationStatus status, Point2D.Double offset, Point2D.Double target, float pTicks, long effectTick) {
        Point2D.Double offsetSrc = this.shift2DOffset(offset.x, offset.y);
        Point2D.Double offsetDst = this.shift2DOffset(target.x, target.y);
        Color overlay = Color.WHITE;
        switch (status) {
            case UNALLOCATED: {
                overlay = new Color(0xBBBBFF);
                break;
            }
            case ALLOCATED: {
                overlay = new Color(0xEEEE00);
                break;
            }
            case UNLOCKABLE: {
                overlay = new Color(29183);
            }
        }
        double effectPart = (Math.sin(Math.toRadians((double)(effectTick * 8L) % 360.0)) + 1.0) / 4.0;
        float br = 0.1f + 0.4f * (2.0f - (float)effectPart);
        float rR = (float)overlay.getRed() / 255.0f * br;
        float rG = (float)overlay.getGreen() / 255.0f * br;
        float rB = (float)overlay.getBlue() / 255.0f * br;
        float rA = (float)overlay.getAlpha() / 255.0f * br;
        GlStateManager.func_179131_c((float)rR, (float)rG, (float)rB, (float)rA);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Vector3 fromStar = new Vector3(offsetSrc.x, offsetSrc.y, 0.0);
        Vector3 toStar = new Vector3(offsetDst.x, offsetDst.y, 0.0);
        double width = 4.0 * this.sizeHandler.getScalingFactor();
        Vector3 dir = toStar.clone().subtract(fromStar);
        Vector3 degLot = dir.clone().crossProduct(new Vector3(0, 0, 1)).normalize().multiply(width);
        Vector3 vec00 = fromStar.clone().add(degLot);
        Vector3 vecV = degLot.clone().multiply(-2);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((double)u, (double)v).func_181675_d();
        }
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Nullable
    private Rectangle2D.Double drawPerk(PerkTreePoint perkPoint, double lowX, double lowY, float pTicks, long effectTick, boolean renderSeal, List<Runnable> outRenderHighlights) {
        Point2D.Double offset = this.shift2DOffset(lowX, lowY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)offset.x, (double)offset.y, (double)0.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)this.sizeHandler.getScalingFactor(), (double)this.sizeHandler.getScalingFactor(), (double)this.sizeHandler.getScalingFactor());
        Rectangle draw = perkPoint.renderAtCurrentPos(perkPoint.getPerk().getPerkStatus((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT), effectTick, pTicks);
        GlStateManager.func_179121_F();
        if (draw == null) {
            return null;
        }
        if (renderSeal) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)offset.x, (double)offset.y, (double)0.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179139_a((double)this.sizeHandler.getScalingFactor(), (double)this.sizeHandler.getScalingFactor(), (double)this.sizeHandler.getScalingFactor());
            perkPoint.renderSealAtCurrentPos((double)draw.width * 0.75, effectTick, pTicks);
            GlStateManager.func_179121_F();
        }
        if (this.searchMatches.contains(perkPoint.getPerk())) {
            outRenderHighlights.add(() -> {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)offset.x, (double)offset.y, (double)0.0);
                GlStateManager.func_179139_a((double)this.sizeHandler.getScalingFactor(), (double)this.sizeHandler.getScalingFactor(), (double)this.sizeHandler.getScalingFactor());
                GlStateManager.func_179131_c((float)0.8f, (float)0.1f, (float)0.1f, (float)1.0f);
                this.drawSearchMarkHalo(draw, effectTick, pTicks);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            });
        }
        double rctWidth = (double)draw.width * this.sizeHandler.getScalingFactor();
        double rctHeight = (double)draw.height * this.sizeHandler.getScalingFactor();
        return new Rectangle2D.Double(offset.x - rctWidth / 2.0, offset.y - rctHeight / 2.0, rctWidth, rctHeight);
    }

    private void drawSearchMarkHalo(Rectangle draw, long effectTick, float pTicks) {
        int size = draw.width;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Vector3 starVec = new Vector3(-size, -size, 0);
        textureSearchMark.bindTexture();
        double uLength = textureSearchMark.getUWidth();
        double vLength = textureSearchMark.getVWidth();
        Point2D.Double frameUV = textureSearchMark.getUVOffset();
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(size * u * 2).addY(size * v * 2);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a(frameUV.x + uLength * (double)u, frameUV.y + vLength * (double)v).func_181675_d();
        }
        GlStateManager.func_179118_c();
        tes.func_78381_a();
        GlStateManager.func_179141_d();
    }

    private Point2D.Double shift2DOffset(double x, double y) {
        double scaledLeft = this.mousePosition.getScaledPosX() - this.sizeHandler.widthToBorder;
        double scaledTop = this.mousePosition.getScaledPosY() - this.sizeHandler.heightToBorder;
        double xAdd = x - scaledLeft;
        double yAdd = y - scaledTop;
        double offsetX = (double)this.guiOffsetX + xAdd;
        double offsetY = (double)this.guiOffsetY + yAdd;
        return new Point2D.Double(offsetX, offsetY);
    }

    private void handleMouseMovement(int mouseX, int mouseY) {
        int guiMouseX = mouseX - this.guiLeft;
        int guiMouseY = mouseY - this.guiTop;
        if (this.mouseSealStack.func_190926_b() && Mouse.isButtonDown((int)0) && this.guiBox.isInBox(guiMouseX, guiMouseY)) {
            if (this.mouseDragging) {
                this.moveMouse(-(guiMouseX - this.mouseBufferX), -(guiMouseY - this.mouseBufferY));
            } else {
                this.mouseBufferX = guiMouseX;
                this.mouseBufferY = guiMouseY;
                this.mouseDragging = true;
            }
        } else {
            this.applyMovedMouseOffset();
            this.mouseDragging = false;
        }
    }

    private void moveMouse(int changeX, int changeY) {
        if (this.previousMousePosition != null) {
            this.mousePosition.updateScaledPos(this.sizeHandler.clampX(this.previousMousePosition.getScaledPosX() + (double)changeX), this.sizeHandler.clampY(this.previousMousePosition.getScaledPosY() + (double)changeY), this.sizeHandler.getScalingFactor());
        } else {
            this.mousePosition.updateScaledPos(this.sizeHandler.clampX(changeX), this.sizeHandler.clampY(changeY), this.sizeHandler.getScalingFactor());
        }
    }

    private void applyMovedMouseOffset() {
        this.previousMousePosition = ScalingPoint.createPoint(this.mousePosition.getScaledPosX(), this.mousePosition.getScaledPosY(), this.sizeHandler.getScalingFactor(), true);
    }

    private void drawBackground(float zLevel) {
        float br = 0.8f;
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)1.0f);
        GlStateManager.func_179084_k();
        textureResBack.bindTexture();
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(this.guiLeft + 10), (double)(this.guiTop - 10 + this.guiHeight), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.guiLeft - 10 + this.guiWidth), (double)(this.guiTop - 10 + this.guiHeight), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)(this.guiLeft - 10 + this.guiWidth), (double)(this.guiTop + 10), (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)(this.guiLeft + 10), (double)(this.guiTop + 10), (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void updateSearchHighlight() {
        this.searchMatches.clear();
        String matchText = this.searchTextEntry.getText().toLowerCase();
        if (matchText.length() < 3) {
            return;
        }
        block0: for (PerkTreePoint point : PerkTree.PERK_TREE.getPerkPoints()) {
            AbstractPerk perk = point.getPerk();
            String name = I18n.func_135052_a((String)(perk.getUnlocalizedName() + ".name"), (Object[])new Object[0]).toLowerCase();
            if (name.contains(matchText)) {
                this.searchMatches.add(perk);
                continue;
            }
            String catStr = perk.getCategory().getLocalizedName();
            if (catStr != null && catStr.toLowerCase().contains(matchText)) {
                this.searchMatches.add(perk);
                continue;
            }
            for (String tooltip : perk.getLocalizedTooltip()) {
                if (!tooltip.toLowerCase().contains(matchText)) continue;
                this.searchMatches.add(perk);
                continue block0;
            }
        }
        if (I18n.func_135052_a((String)"perk.info.sealed", (Object[])new Object[0]).toLowerCase().contains(matchText)) {
            PlayerProgress prog = ResearchManager.clientProgress;
            for (AbstractPerk sealed : prog.getSealedPerks()) {
                if (this.searchMatches.contains(sealed)) continue;
                this.searchMatches.add(sealed);
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (!this.mouseSealStack.func_190926_b()) {
            this.mouseSealStack = ItemStack.field_190927_a;
            if (Minecraft.func_71410_x().field_71439_g == null) {
                return;
            }
            PlayerProgress prog = ResearchManager.clientProgress;
            for (Map.Entry<AbstractPerk, Rectangle2D.Double> rctPerk : this.thisFramePerks.entrySet()) {
                if (!rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop) || !prog.hasPerkUnlocked(rctPerk.getKey()) || prog.isPerkSealed(rctPerk.getKey()) || !ItemPerkSeal.useSeal((EntityPlayer)Minecraft.func_71410_x().field_71439_g, true)) continue;
                PktRequestPerkSealAction pkt = new PktRequestPerkSealAction(rctPerk.getKey(), true);
                PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
                break;
            }
            return;
        }
        if (this.unlockPrimed == null) {
            return;
        }
        for (Map.Entry<AbstractPerk, Rectangle2D.Double> rctPerk : this.thisFramePerks.entrySet()) {
            if (!this.unlockPrimed.equals(rctPerk.getKey()) || !rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop) || !rctPerk.getKey().mayUnlockPerk(ResearchManager.clientProgress)) continue;
            PktUnlockPerk pkt = new PktUnlockPerk(false, rctPerk.getKey());
            PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
            break;
        }
        this.unlockPrimed = null;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.unlockPrimed = null;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        Point p = new Point(mouseX, mouseY);
        if (this.handleBookmarkClick(p)) {
            return;
        }
        if (rectSealBox.contains(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            if (!this.foundSeals.func_190926_b()) {
                this.mouseSealStack = new ItemStack((Item)ItemsAS.perkSeal);
            }
            return;
        }
        PlayerProgress prog = ResearchManager.clientProgress;
        for (Map.Entry<AbstractPerk, Rectangle2D.Double> rctPerk : this.thisFramePerks.entrySet()) {
            if (!rctPerk.getValue().contains(mouseX, mouseY) || !this.guiBox.isInBox(mouseX - this.guiLeft, mouseY - this.guiTop)) continue;
            AbstractPerk perk = rctPerk.getKey();
            if (!prog.hasPerkUnlocked(perk) && perk.mayUnlockPerk(prog)) {
                this.unlockPrimed = perk;
                break;
            }
            if (this.sealBreakPrimed != null && this.tickSealBreak > 0) {
                PktRequestPerkSealAction pkt = new PktRequestPerkSealAction(perk, false);
                PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
                return;
            }
            if (!prog.isPerkSealed(perk)) continue;
            this.sealBreakPrimed = perk;
            this.tickSealBreak = 4;
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode != 1) {
            this.searchTextEntry.textboxKeyTyped(typedChar, keyCode);
        }
    }

    public void playUnlockAnimation(AbstractPerk perk) {
        this.unlockEffects.put(perk, ClientScheduler.getClientTick());
    }

    public void playSealBreakAnimation(AbstractPerk perk) {
        this.updateSearchHighlight();
        this.breakEffects.put(perk, ClientScheduler.getClientTick());
    }
}

