/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.event;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.ClientProxy;
import hellfirepvp.astralsorcery.client.data.PersistentDataManager;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.event.ClientRenderEventHandler;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.render.tile.TESRTranslucentBlock;
import hellfirepvp.astralsorcery.client.util.ClientScreenshotCache;
import hellfirepvp.astralsorcery.client.util.UISextantCache;
import hellfirepvp.astralsorcery.client.util.camera.ClientCameraManager;
import hellfirepvp.astralsorcery.common.auxiliary.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.constellation.charge.PlayerChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.type.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.data.DataLightBlockEndpoints;
import hellfirepvp.astralsorcery.common.data.DataLightConnections;
import hellfirepvp.astralsorcery.common.data.DataPatreonFlares;
import hellfirepvp.astralsorcery.common.data.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.world.data.GatewayCache;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ClientConnectionEventHandler {
    @SubscribeEvent
    public void onDc(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        AstralSorcery.log.info("Cleaning client cache...");
        EffectHandler.cleanUp();
        ClientCameraManager.getInstance().removeAllAndCleanup();
        ConstellationSkyHandler.getInstance().clientClearCache();
        GuiJournalProgression.resetJournal();
        ResearchManager.clientProgress = new PlayerProgress();
        ResearchManager.clientInitialized = false;
        AstralSorcery.proxy.scheduleClientside(ClientScreenshotCache::cleanUp);
        ClientRenderEventHandler.resetPermChargeReveal();
        ClientRenderEventHandler.resetTempChargeReveal();
        AstralSorcery.proxy.scheduleClientside(TESRTranslucentBlock::cleanUp);
        PlayerChargeHandler.INSTANCE.setClientCharge(0.0f);
        PerkEffectHelper.perkCooldownsClient.clear();
        CelestialGatewaySystem.instance.updateClientCache(new HashMap<Integer, List<GatewayCache.GatewayNode>>());
        AttributeTypeRegistry.getTypes().forEach(t -> t.clear(Side.CLIENT));
        PerkTree.PERK_TREE.clearCache(Side.CLIENT);
        UISextantCache.INSTANCE.clearClient();
        ((DataLightConnections)SyncDataHolder.getDataClient("StarlightNetworkConnections")).clientClean();
        ((DataLightBlockEndpoints)SyncDataHolder.getDataClient("StarlightNetworkEndpoints")).clientClean();
        ((DataTimeFreezeEffects)SyncDataHolder.getDataClient("TimeFreezeEffects")).clientClean();
        ((DataPatreonFlares)SyncDataHolder.getDataClient("PatreonFlares")).cleanUp(Side.CLIENT);
        PersistentDataManager.INSTANCE.clearCreative();
        ClientProxy.connected = false;
        AstralSorcery.log.info("Cleared cached client data! Disconnected from server.");
    }

    @SubscribeEvent
    public void onJoin(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        AstralSorcery.proxy.scheduleClientside(() -> {
            NetworkManager nm = event.getManager();
            String addr = nm.func_74430_c().toString();
            if (nm.func_150731_c()) {
                IntegratedServer is = Minecraft.func_71410_x().func_71401_C();
                if (is != null) {
                    addr = is.func_71221_J();
                }
            } else {
                int id = addr.indexOf(92);
                if (id != -1) {
                    addr = addr.substring(0, MathHelper.func_76125_a((int)id, (int)1, (int)addr.length()));
                }
            }
            addr = this.sanitizeFileName(addr);
            ClientScreenshotCache.loadAndInitScreenshotsFor(addr);
        });
    }

    private String sanitizeFileName(String addr) {
        addr = addr.trim();
        addr = addr.replace(' ', '_');
        addr = addr.toLowerCase();
        for (char c0 : ChatAllowedCharacters.field_71567_b) {
            addr = addr.replace(c0, '_');
        }
        addr = addr.replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
        return addr;
    }
}

