/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.texture;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.IComplexEffect;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;

public class TexturePlane
implements IComplexEffect,
IComplexEffect.PreventRemoval {
    protected double u = 0.0;
    protected double v = 0.0;
    protected double uLength = 1.0;
    protected double vLength = 1.0;
    private float lastRenderDegree = 0.0f;
    private boolean alphaGradient = false;
    private int counter = 0;
    private boolean remove = false;
    private EntityComplexFX.RefreshFunction refreshFunc = null;
    private Color colorOverlay = Color.WHITE;
    private int ticksPerFullRot = 100;
    private float fixDegree = 0.0f;
    private int maxAge = -1;
    private Vector3 pos = new Vector3(0, 0, 0);
    private float scale = 1.0f;
    private EntityComplexFX.AlphaFunction alphaFunction = EntityComplexFX.AlphaFunction.CONSTANT;
    private EntityComplexFX.RenderAlphaFunction<TexturePlane> renderAlphaFunction = null;
    private float alphaMultiplier = 1.0f;
    private EntityComplexFX.ScaleFunction<TexturePlane> scaleFunc;
    private boolean flagRemoved = true;
    private final AbstractRenderableTexture texture;
    private final Vector3 axis;

    public TexturePlane(AbstractRenderableTexture texture, Vector3 axis) {
        this.texture = texture;
        this.axis = axis;
    }

    public TexturePlane setPosition(Vector3 pos) {
        this.pos = pos;
        return this;
    }

    public TexturePlane setStaticUVOffset(double u, double v) {
        this.u = u;
        this.v = v;
        return this;
    }

    public TexturePlane setUVLength(double uLength, double vLength) {
        this.uLength = uLength;
        this.vLength = vLength;
        return this;
    }

    public TexturePlane setTicksPerFullRotation(int ticksPerFullRot) {
        this.ticksPerFullRot = ticksPerFullRot;
        return this;
    }

    public TexturePlane setNoRotation(float fixedDregree) {
        this.ticksPerFullRot = -1;
        this.fixDegree = fixedDregree;
        return this;
    }

    public TexturePlane setMaxAge(int ticksMaxAge) {
        this.maxAge = ticksMaxAge;
        return this;
    }

    public TexturePlane setColorOverlay(Color colorOverlay) {
        this.colorOverlay = colorOverlay;
        return this;
    }

    public TexturePlane setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public TexturePlane setScaleFunction(EntityComplexFX.ScaleFunction<TexturePlane> function) {
        this.scaleFunc = function;
        return this;
    }

    public TexturePlane setRefreshFunc(EntityComplexFX.RefreshFunction refreshFunc) {
        this.refreshFunc = refreshFunc;
        return this;
    }

    public TexturePlane setRenderAlphaFunction(EntityComplexFX.RenderAlphaFunction<TexturePlane> renderAlphaFunction) {
        this.renderAlphaFunction = renderAlphaFunction;
        return this;
    }

    public TexturePlane setAlphaFunction(EntityComplexFX.AlphaFunction alphaFunction) {
        this.alphaFunction = alphaFunction;
        return this;
    }

    public TexturePlane setAlphaMultiplier(float alphaMultiplier) {
        this.alphaMultiplier = alphaMultiplier;
        return this;
    }

    public TexturePlane setAlphaOverDistance(boolean alphaGradient) {
        this.alphaGradient = alphaGradient;
        return this;
    }

    public float getAlphaDistanceMultiplier(double dstSq) {
        double maxSqDst = Config.maxEffectRenderDistanceSq;
        return 1.0f - (float)(dstSq / maxSqDst);
    }

    @Override
    public boolean isRemoved() {
        return this.flagRemoved;
    }

    @Override
    public void flagAsRemoved() {
        this.flagRemoved = true;
    }

    @Override
    public void clearRemoveFlag() {
        this.flagRemoved = false;
    }

    public void setDead() {
        this.remove = true;
    }

    public int getAge() {
        return this.counter;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public int getLayer() {
        return 1;
    }

    @Override
    public IComplexEffect.RenderTarget getRenderTarget() {
        return IComplexEffect.RenderTarget.RENDERLOOP;
    }

    @Override
    public void tick() {
        ++this.counter;
        if (this.maxAge >= 0 && this.counter >= this.maxAge) {
            if (this.refreshFunc != null) {
                Entity rView = Minecraft.func_71410_x().func_175606_aa();
                if (rView == null) {
                    rView = Minecraft.func_71410_x().field_71439_g;
                }
                if (rView.func_70092_e(this.pos.getX(), this.pos.getY(), this.pos.getZ()) <= (double)Config.maxEffectRenderDistanceSq && this.refreshFunc.shouldRefresh()) {
                    this.counter = 0;
                    return;
                }
            }
            this.setDead();
        }
    }

    @Override
    public boolean canRemove() {
        return this.remove;
    }

    @Override
    public void render(float partialTicks) {
        float deg;
        double dst;
        Entity rView = Minecraft.func_71410_x().func_175606_aa();
        if (rView == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        if ((dst = rView.func_70092_e(this.pos.getX(), this.pos.getY(), this.pos.getZ())) > (double)Config.maxEffectRenderDistanceSq) {
            return;
        }
        float alphaMul = this.alphaFunction.getAlpha(this.counter, this.maxAge);
        float alphaGrad = (float)this.colorOverlay.getAlpha() / 255.0f * alphaMul * this.alphaMultiplier;
        if (this.alphaGradient) {
            alphaGrad = this.getAlphaDistanceMultiplier(dst) * alphaMul * this.alphaMultiplier;
        }
        if (this.renderAlphaFunction != null) {
            alphaGrad = this.renderAlphaFunction.getRenderAlpha(this, alphaGrad);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)((float)this.colorOverlay.getRed() / 255.0f), (float)((float)this.colorOverlay.getGreen() / 255.0f), (float)((float)this.colorOverlay.getBlue() / 255.0f), (float)alphaGrad);
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        Vector3 axis = this.axis.clone();
        if (this.ticksPerFullRot >= 0) {
            float anglePercent = (float)this.counter / (float)this.ticksPerFullRot;
            deg = anglePercent * 360.0f;
            this.lastRenderDegree = deg = RenderingUtils.interpolateRotation(this.lastRenderDegree, deg, partialTicks);
        } else {
            deg = this.fixDegree;
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179092_a((int)516, (float)1.0E-4f);
        this.currRenderAroundAxis(partialTicks, Math.toRadians(deg), axis);
        GlStateManager.func_179089_o();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void currRenderAroundAxis(float parTicks, double angle, Vector3 axis) {
        float scale = this.scale;
        if (this.scaleFunc != null) {
            scale = this.scaleFunc.getScale(this, this.pos.clone(), parTicks, scale);
        }
        this.texture.bindTexture();
        RenderingUtils.renderAngleRotatedTexturedRect(this.pos, axis, angle, scale, this.u, this.v, this.uLength, this.vLength, parTicks);
    }
}

