/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.fx;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class EntityFXFloatingCube
extends EntityComplexFX {
    private final TextureAtlasSprite tas;
    private final AbstractRenderableTexture tex;
    private EntityComplexFX.MotionController<EntityFXFloatingCube> motionController = (fx, v) -> v;
    private EntityComplexFX.PositionController<EntityFXFloatingCube> positionController = (fx, v, m) -> v.add(m);
    private Vector3 rotationDegreeAxis = new Vector3();
    private Vector3 prevRotationDegreeAxis = new Vector3();
    private Vector3 rotationChange = new Vector3();
    private Vector3 motion = new Vector3();
    private Vector3 position = new Vector3();
    private Vector3 prevPosition = new Vector3();
    private Blending blending = Blending.ADDITIVEDARK;
    private EntityComplexFX.AlphaFunction alphaFunction = EntityComplexFX.AlphaFunction.CONSTANT;
    private EntityComplexFX.RefreshFunction refreshFunction = null;
    private float alphaMultiplier = 1.0f;
    private float tumbleIntensityMultiplier = 1.0f;
    private EntityComplexFX.ScaleFunction<EntityFXFloatingCube> scaleFunction = (fx, pos, pTicks, scaleIn) -> scaleIn;
    private float scale = 1.0f;
    private boolean disableDepth = false;
    private float textureSubSizePercentage = 1.0f;
    private int lightCoordX = -1;
    private int lightCoordY = -1;
    private Function<EntityFXFloatingCube, Color> colorHandler = null;

    public EntityFXFloatingCube(IBlockState blockState) {
        this.tas = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(blockState);
        this.tex = null;
    }

    public EntityFXFloatingCube(TextureAtlasSprite tas) {
        this.tas = tas;
        this.tex = null;
    }

    public EntityFXFloatingCube(AbstractRenderableTexture tex) {
        this.tas = null;
        this.tex = tex;
    }

    public EntityFXFloatingCube setDisableDepth(boolean disableDepth) {
        this.disableDepth = disableDepth;
        return this;
    }

    public EntityFXFloatingCube setWorldLightCoord(World iba, BlockPos pos) {
        int light = iba.func_175667_e(pos) ? iba.func_175626_b(pos, 0) : 0;
        this.lightCoordX = light >> 16 & 0xFFFF;
        this.lightCoordY = light & 0xFFFF;
        return this;
    }

    public EntityFXFloatingCube setColorHandler(Function<EntityFXFloatingCube, Color> colorHandler) {
        this.colorHandler = colorHandler;
        return this;
    }

    public EntityFXFloatingCube setTextureSubSizePercentage(float textureSubSizePercentage) {
        this.textureSubSizePercentage = textureSubSizePercentage;
        return this;
    }

    public EntityFXFloatingCube setTumbleIntensityMultiplier(float tumbleIntensityMultiplier) {
        this.tumbleIntensityMultiplier = tumbleIntensityMultiplier;
        return this;
    }

    public EntityFXFloatingCube setBlendMode(Blending blending) {
        this.blending = blending;
        return this;
    }

    public EntityFXFloatingCube setPosition(Vector3 position) {
        this.position = position;
        this.prevPosition = this.position.clone();
        return this;
    }

    public EntityFXFloatingCube setPosition(double x, double y, double z) {
        this.position = new Vector3(x, y, z);
        this.prevPosition = this.position.clone();
        return this;
    }

    public EntityFXFloatingCube setMotion(Vector3 motion) {
        this.motion = motion;
        return this;
    }

    public EntityFXFloatingCube setMotion(double x, double y, double z) {
        this.motion = new Vector3(x, y, z);
        return this;
    }

    public EntityFXFloatingCube setRefreshFunction(EntityComplexFX.RefreshFunction refreshFunction) {
        this.refreshFunction = refreshFunction;
        return this;
    }

    public EntityFXFloatingCube setMotionController(EntityComplexFX.MotionController<EntityFXFloatingCube> motionController) {
        this.motionController = motionController;
        return this;
    }

    public EntityFXFloatingCube setPositionController(EntityComplexFX.PositionController<EntityFXFloatingCube> positionController) {
        this.positionController = positionController;
        return this;
    }

    public EntityFXFloatingCube setAlphaFunction(EntityComplexFX.AlphaFunction alphaFunction) {
        this.alphaFunction = alphaFunction;
        return this;
    }

    public EntityFXFloatingCube setAlphaMultiplier(float alphaMultiplier) {
        this.alphaMultiplier = alphaMultiplier;
        return this;
    }

    public EntityFXFloatingCube setScaleFunction(EntityComplexFX.ScaleFunction<EntityFXFloatingCube> scaleFunction) {
        this.scaleFunction = scaleFunction;
        return this;
    }

    public EntityFXFloatingCube setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public EntityFXFloatingCube tumble() {
        this.rotationDegreeAxis = Vector3.positiveYRandom().multiply(360);
        this.rotationChange = Vector3.random().multiply(12);
        return this;
    }

    public Vector3 getMotion() {
        return this.motion;
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public Vector3 getRotation() {
        return this.rotationDegreeAxis;
    }

    public Vector3 getInterpolatedPosition(float percent) {
        return new Vector3(RenderingUtils.interpolate(this.prevPosition.getX(), this.position.getX(), percent), RenderingUtils.interpolate(this.prevPosition.getY(), this.position.getY(), percent), RenderingUtils.interpolate(this.prevPosition.getZ(), this.position.getZ(), percent));
    }

    public Vector3 getInterpolatedRotation(float percent) {
        return new Vector3(RenderingUtils.interpolate(this.prevRotationDegreeAxis.getX(), this.rotationDegreeAxis.getX(), percent), RenderingUtils.interpolate(this.prevRotationDegreeAxis.getY(), this.rotationDegreeAxis.getY(), percent), RenderingUtils.interpolate(this.prevRotationDegreeAxis.getZ(), this.rotationDegreeAxis.getZ(), percent));
    }

    @Override
    public int getLayer() {
        return 2;
    }

    @Override
    public void tick() {
        ++this.age;
        Vector3 motion = this.motion.clone();
        if (this.motionController != null) {
            motion = this.motionController.updateMotion(this, motion);
        }
        this.motion = motion.clone();
        if (this.positionController != null) {
            Vector3 newPos = this.positionController.updatePosition(this, this.position.clone(), this.motion);
            this.prevPosition = this.position.clone();
            this.position = newPos;
        } else {
            this.prevPosition = this.position.clone();
            this.position.add(this.motion);
        }
        if (this.tumbleIntensityMultiplier > 0.0f && this.rotationChange.lengthSquared() > 0.0) {
            Vector3 degAxis = this.rotationDegreeAxis.clone();
            Vector3 modify = this.rotationChange.clone().multiply(this.tumbleIntensityMultiplier);
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
            this.rotationDegreeAxis.add(modify);
            Vector3 newDegAxis = this.rotationDegreeAxis;
            newDegAxis.setX(newDegAxis.getX() % 360.0).setY(newDegAxis.getY() % 360.0).setZ(newDegAxis.getZ() % 360.0);
            if (!degAxis.add(modify).equals(newDegAxis)) {
                this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone().subtract(modify);
            }
        } else {
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
        }
        if (this.refreshFunction != null && this.canRemove() && this.refreshFunction.shouldRefresh()) {
            this.age = 0;
        }
    }

    @Override
    public void render(float pTicks) {
        Color tmp;
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.blending == null) {
            GlStateManager.func_179084_k();
        } else {
            GlStateManager.func_179147_l();
            GL11.glEnable((int)3042);
            this.blending.applyStateManager();
            this.blending.apply();
        }
        if (this.disableDepth) {
            GlStateManager.func_179097_i();
            GL11.glDisable((int)2929);
        }
        GlStateManager.func_179129_p();
        GL11.glDisable((int)2884);
        GlStateManager.func_179092_a((int)516, (float)0.001f);
        RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
        Vector3 translateTo = this.getInterpolatedPosition(pTicks);
        GlStateManager.func_179137_b((double)translateTo.getX(), (double)translateTo.getY(), (double)translateTo.getZ());
        float scaleF = this.scale;
        scaleF = this.scaleFunction.getScale(this, translateTo, pTicks, scaleF);
        Vector3 rotation = this.getInterpolatedRotation(pTicks);
        GlStateManager.func_179114_b((float)((float)rotation.getX()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)rotation.getY()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)rotation.getZ()), (float)0.0f, (float)0.0f, (float)1.0f);
        Point2D.Double uv = null;
        if (this.tex != null) {
            this.tex.bindTexture();
            uv = this.tex.getUVOffset();
        }
        double u = uv != null ? uv.x : (double)this.tas.func_94209_e();
        double v = uv != null ? uv.y : (double)this.tas.func_94206_g();
        double uLength = (uv != null ? this.tex.getUWidth() : (double)(this.tas.func_94212_f() - this.tas.func_94209_e())) * (double)this.textureSubSizePercentage;
        double vLength = (uv != null ? this.tex.getVWidth() : (double)(this.tas.func_94210_h() - this.tas.func_94206_g())) * (double)this.textureSubSizePercentage;
        Color c = Color.WHITE;
        if (this.colorHandler != null && (tmp = this.colorHandler.apply(this)) != null) {
            c = tmp;
        }
        float alpha = this.alphaFunction.getAlpha(this.age, this.maxAge);
        alpha *= this.alphaMultiplier;
        float cR = (float)c.getRed() / 255.0f;
        float cG = (float)c.getGreen() / 255.0f;
        float cB = (float)c.getBlue() / 255.0f;
        if (this.lightCoordX == -1 && this.lightCoordY == -1) {
            RenderingUtils.renderTexturedCubeCentralWithColor(new Vector3(), scaleF, u, v, uLength, vLength, cR, cG, cB, alpha);
        } else {
            RenderingUtils.renderTexturedCubeCentralWithLightAndColor(new Vector3(), scaleF, u, v, uLength, vLength, this.lightCoordX, this.lightCoordY, cR, cG, cB, alpha);
        }
        GlStateManager.func_179092_a((int)516, (float)0.001f);
        GlStateManager.func_179089_o();
        if (this.disableDepth) {
            GlStateManager.func_179126_j();
        }
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        TextureHelper.refreshTextureBindState();
    }

    private int getLight() {
        BlockPos blockpos = this.position.toBlockPos();
        return Minecraft.func_71410_x().field_71441_e.func_175667_e(blockpos) ? Minecraft.func_71410_x().field_71441_e.func_175626_b(blockpos, 0) : 0;
    }
}

