/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawNetworkData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawPartData;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;
import org.cyclops.integrateddynamics.network.packet.NetworkDiagnosticsNetworkPacket;

public class NetworkDiagnostics {
    private static final NetworkDiagnostics _INSTANCE = new NetworkDiagnostics();
    private final List<UUID> players = Lists.newArrayList();

    private NetworkDiagnostics() {
    }

    public static NetworkDiagnostics getInstance() {
        return _INSTANCE;
    }

    protected EntityPlayerMP getPlayer(UUID uuid) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid);
    }

    public synchronized void registerPlayer(EntityPlayerMP player) {
        if (!this.players.contains(player.getPersistentID())) {
            this.players.add(player.getPersistentID());
            for (INetwork network : NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getNetworks()) {
                this.sendNetworkUpdateToPlayer(player, network);
            }
        }
    }

    public synchronized void unRegisterPlayer(EntityPlayerMP player) {
        this.players.remove(player.getPersistentID());
    }

    public void sendNetworkUpdateToPlayer(EntityPlayerMP player, INetwork network) {
        ArrayList rawParts = Lists.newArrayList();
        for (INetworkElement networkElement : network.getElements()) {
            if (!(networkElement instanceof IPartNetworkElement)) continue;
            IPartNetworkElement partNetworkElement = (IPartNetworkElement)networkElement;
            PartPos pos = partNetworkElement.getTarget().getCenter();
            long lastSecondDurationNs = network.getLastSecondDuration(networkElement);
            rawParts.add(new RawPartData(pos.getPos().getDimensionId(), pos.getPos().getBlockPos(), pos.getSide(), L10NHelpers.localize((String)partNetworkElement.getPart().getUnlocalizedName(), (Object[])new Object[0]), lastSecondDurationNs));
        }
        RawNetworkData rawNetworkData = new RawNetworkData(network.isKilled(), network.hashCode(), network.getCablesCount(), rawParts);
        IntegratedDynamics._instance.getPacketHandler().sendToPlayer((PacketBase)new NetworkDiagnosticsNetworkPacket(rawNetworkData.toNbt()), player);
    }

    public synchronized void sendNetworkUpdate(INetwork network) {
        Iterator<UUID> it = this.players.iterator();
        while (it.hasNext()) {
            UUID uuid = it.next();
            EntityPlayerMP player = this.getPlayer(uuid);
            if (player != null) {
                this.sendNetworkUpdateToPlayer(player, network);
                continue;
            }
            it.remove();
        }
    }

    public synchronized boolean isBeingDiagnozed() {
        return !this.players.isEmpty();
    }
}

