/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class PositionedAddonsNetwork
implements IPositionedAddonsNetwork {
    private INetwork network;
    private final TIntObjectMap<Set<IPositionedAddonsNetwork.PrioritizedPartPos>> positions = new TIntObjectHashMap();
    private final Set<PartPos> disabledPositions = Sets.newHashSet();
    private final TIntObjectMap<IPositionedAddonsNetwork.PositionsIterator> positionsIterators = new TIntObjectHashMap();
    private final Set<IPositionedAddonsNetwork.PositionsIterator> createdIterators = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public Collection<IPositionedAddonsNetwork.PrioritizedPartPos> getPositions(int channel) {
        if (channel == -1) {
            return this.getPositions();
        }
        Set positions = (Set)this.positions.get(channel);
        Set wildcardPositions = (Set)this.positions.get(-1);
        if (positions == null) {
            positions = Collections.emptySet();
        }
        if (wildcardPositions == null) {
            wildcardPositions = Collections.emptySet();
        }
        return ImmutableSet.copyOf((Iterable)Iterables.concat(positions, wildcardPositions));
    }

    @Override
    public Collection<IPositionedAddonsNetwork.PrioritizedPartPos> getPositions() {
        ArrayList allPositions = Lists.newArrayList();
        for (Set positions : this.positions.valueCollection()) {
            allPositions.addAll(positions);
        }
        return allPositions;
    }

    @Override
    public IPositionedAddonsNetwork.PositionsIterator getPositionIterator(int channel) {
        IPositionedAddonsNetwork.PositionsIterator it = (IPositionedAddonsNetwork.PositionsIterator)this.positionsIterators.get(channel);
        it = it == null ? this.createPositionIterator(channel) : it.cloneState();
        return it;
    }

    @Override
    public void setPositionIterator(@Nullable IPositionedAddonsNetwork.PositionsIterator iterator, int channel) {
        if (iterator == null || !iterator.hasNext()) {
            this.positionsIterators.remove(channel);
        } else {
            this.positionsIterators.put(channel, (Object)iterator);
        }
    }

    @Override
    public IPositionedAddonsNetwork.PositionsIterator createPositionIterator(int channel) {
        IPositionedAddonsNetwork.PositionsIterator it = new IPositionedAddonsNetwork.PositionsIterator(this.getPositions(channel), this);
        this.onPositionIteratorCreated(it);
        return it;
    }

    @Override
    public void onPositionIteratorCreated(IPositionedAddonsNetwork.PositionsIterator positionsIterator) {
        this.createdIterators.add(positionsIterator);
    }

    protected void invalidateIterators() {
        this.positionsIterators.clear();
        this.createdIterators.forEach(IPositionedAddonsNetwork.PositionsIterator::invalidate);
        this.createdIterators.clear();
    }

    @Override
    public boolean addPosition(PartPos pos, int priority, int channel) {
        this.invalidateIterators();
        Set positions = (Set)this.positions.get(channel);
        if (positions == null) {
            positions = Sets.newTreeSet();
            this.positions.put(channel, (Object)positions);
        }
        return positions.add(IPositionedAddonsNetwork.PrioritizedPartPos.of(pos, priority));
    }

    @Override
    public void removePosition(PartPos pos) {
        this.invalidateIterators();
        for (Set positions : this.positions.valueCollection()) {
            positions.removeIf(prioritizedPartPos -> prioritizedPartPos.getPartPos().equals(pos));
        }
    }

    @Override
    public boolean isPositionDisabled(PartPos pos) {
        return this.disabledPositions.contains(pos);
    }

    @Override
    public void disablePosition(PartPos pos) {
        this.disabledPositions.add(pos);
    }

    @Override
    public void enablePosition(PartPos pos) {
        this.disabledPositions.remove(pos);
    }

    public INetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(INetwork network) {
        this.network = network;
    }
}

